/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.StatefulSystemFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntToIntHashMap;
import net.sf.saxon.z.IntToIntMap;

public class Translate
extends SystemFunction
implements Callable,
StatefulSystemFunction {
    private IntToIntMap a = null;

    @Override
    public Expression fixArguments(Expression ... expressionArray) {
        if (expressionArray[1] instanceof StringLiteral && expressionArray[2] instanceof StringLiteral) {
            this.a = Translate.a(((StringLiteral)expressionArray[1]).getValue(), ((StringLiteral)expressionArray[2]).getValue());
        }
        return null;
    }

    public IntToIntMap getStaticMap() {
        return this.a;
    }

    public static CharSequence translate(StringValue object, StringValue object2, StringValue object3) {
        if (((StringValue)object).containsSurrogatePairs() || ((StringValue)object2).containsSurrogatePairs() || ((StringValue)object3).containsSurrogatePairs()) {
            return Translate.translateUsingMap((StringValue)object, Translate.a((StringValue)object2, (StringValue)object3));
        }
        if (((StringValue)object).getStringLength() * ((StringValue)object2).getStringLength() > 1000) {
            return Translate.translateUsingMap((StringValue)object, Translate.a((StringValue)object2, (StringValue)object3));
        }
        object = ((AtomicValue)object).getStringValueCS();
        object2 = ((AtomicValue)object2).getStringValueCS();
        object3 = ((AtomicValue)object3).getStringValueCS();
        object2 = object2.toString();
        FastStringBuffer fastStringBuffer = new FastStringBuffer(object.length());
        int n2 = object3.length();
        int n3 = object.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = object.charAt(i2);
            int n4 = ((String)object2).indexOf(c2);
            if (n4 >= n2) continue;
            fastStringBuffer.append(n4 < 0 ? c2 : object3.charAt(n4));
        }
        return fastStringBuffer;
    }

    private static IntToIntHashMap a(StringValue object, StringValue object2) {
        object = ((StringValue)object).getUnicodeString();
        object2 = ((StringValue)object2).getUnicodeString();
        IntToIntHashMap intToIntHashMap = new IntToIntHashMap(((UnicodeString)object).uLength(), 0.5);
        for (int i2 = 0; i2 < ((UnicodeString)object).uLength(); ++i2) {
            if (intToIntHashMap.find(((UnicodeString)object).uCharAt(i2))) continue;
            intToIntHashMap.put(((UnicodeString)object).uCharAt(i2), i2 > ((UnicodeString)object2).uLength() - 1 ? -1 : ((UnicodeString)object2).uCharAt(i2));
        }
        return intToIntHashMap;
    }

    public static CharSequence translateUsingMap(StringValue object, IntToIntMap intToIntMap) {
        object = ((StringValue)object).getUnicodeString();
        int n2 = ((UnicodeString)object).uLength();
        FastStringBuffer fastStringBuffer = new FastStringBuffer(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = ((UnicodeString)object).uCharAt(i2);
            int n4 = intToIntMap.get(n3);
            if (n4 == Integer.MAX_VALUE) {
                n4 = n3;
            }
            if (n4 == -1) continue;
            fastStringBuffer.appendWideChar(n4);
        }
        return fastStringBuffer;
    }

    public StringValue call(XPathContext object, Sequence[] object2) {
        object = (StringValue)object2[0].head();
        if (object == null) {
            return StringValue.EMPTY_STRING;
        }
        if (this.a != null) {
            return new StringValue(Translate.translateUsingMap((StringValue)object, this.a));
        }
        StringValue stringValue = (StringValue)object2[1].head();
        object2 = (StringValue)object2[2].head();
        return new StringValue(Translate.translate((StringValue)object, stringValue, (StringValue)object2));
    }

    @Override
    public String getCompilerName() {
        return "TranslateCompiler";
    }

    @Override
    public Translate copy() {
        Translate translate = (Translate)SystemFunction.makeFunction(this.getFunctionName().getLocalPart(), this.getRetainedStaticContext(), this.getArity());
        ((Translate)SystemFunction.makeFunction(this.getFunctionName().getLocalPart(), this.getRetainedStaticContext(), this.getArity())).a = this.a;
        return translate;
    }
}

