/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.AllElementsSpaceStrippingRule;
import net.sf.saxon.om.IgnorableSpaceStrippingRule;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.regex.ARegularExpression;
import net.sf.saxon.regex.JavaRegularExpression;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trans.Instantiator;
import net.sf.saxon.trans.Maker;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import org.xml.sax.XMLReader;

public class URIQueryParameters {
    private FilenameFilter a = null;
    private Boolean b = null;
    private Integer c = null;
    private SpaceStrippingRule d = null;
    private Integer e = null;
    private Maker<XMLReader> f = null;
    private Boolean g = null;
    private boolean h;
    private Boolean i = null;
    private Boolean j = null;
    public static final int ON_ERROR_FAIL = 1;
    public static final int ON_ERROR_WARNING = 2;
    public static final int ON_ERROR_IGNORE = 3;

    public URIQueryParameters(String object, Configuration configuration) {
        if (object != null) {
            object = new StringTokenizer((String)object, ";&");
            block20: while (((StringTokenizer)object).hasMoreTokens()) {
                Object object2 = ((StringTokenizer)object).nextToken();
                int n2 = ((String)object2).indexOf(61);
                if (n2 <= 0 || n2 >= ((String)object2).length() - 1) continue;
                String string = ((String)object2).substring(0, n2);
                object2 = ((String)object2).substring(n2 + 1);
                String string2 = object2;
                Object object3 = configuration;
                object2 = this;
                if (string.equals("select")) {
                    ((URIQueryParameters)object2).a = URIQueryParameters.makeGlobFilter(string2);
                    continue;
                }
                if (string.equals("match")) {
                    object3 = new ARegularExpression(string2, "", "XP", new ArrayList<String>(), (Configuration)object3);
                    ((URIQueryParameters)object2).a = new RegexFilter((RegularExpression)object3);
                    continue;
                }
                if (string.equals("recurse")) {
                    ((URIQueryParameters)object2).b = "yes".equals(string2);
                    continue;
                }
                if (string.equals("validation")) {
                    int n3 = Validation.getCode(string2);
                    if (n3 == -1) continue;
                    ((URIQueryParameters)object2).c = n3;
                    continue;
                }
                if (string.equals("strip-space")) {
                    switch (string2) {
                        case "yes": {
                            ((URIQueryParameters)object2).d = AllElementsSpaceStrippingRule.getInstance();
                            continue block20;
                        }
                        case "ignorable": {
                            ((URIQueryParameters)object2).d = IgnorableSpaceStrippingRule.getInstance();
                            continue block20;
                        }
                        case "no": {
                            ((URIQueryParameters)object2).d = NoElementsSpaceStrippingRule.getInstance();
                        }
                    }
                    continue;
                }
                if (string.equals("stable")) {
                    if (string2.equals("yes")) {
                        ((URIQueryParameters)object2).i = Boolean.TRUE;
                        continue;
                    }
                    if (!string2.equals("no")) continue;
                    ((URIQueryParameters)object2).i = Boolean.FALSE;
                    continue;
                }
                if (string.equals("metadata")) {
                    if (string2.equals("yes")) {
                        ((URIQueryParameters)object2).j = Boolean.TRUE;
                        continue;
                    }
                    if (!string2.equals("no")) continue;
                    ((URIQueryParameters)object2).j = Boolean.FALSE;
                    continue;
                }
                if (string.equals("xinclude")) {
                    if (string2.equals("yes")) {
                        ((URIQueryParameters)object2).g = Boolean.TRUE;
                        continue;
                    }
                    if (!string2.equals("no")) continue;
                    ((URIQueryParameters)object2).g = Boolean.FALSE;
                    continue;
                }
                if (string.equals("unparsed")) {
                    if (string2.equals("yes")) {
                        ((URIQueryParameters)object2).h = true;
                        continue;
                    }
                    if (!string2.equals("no")) continue;
                    ((URIQueryParameters)object2).h = false;
                    continue;
                }
                if (string.equals("on-error")) {
                    switch (string2) {
                        case "warning": {
                            ((URIQueryParameters)object2).e = 2;
                            continue block20;
                        }
                        case "ignore": {
                            ((URIQueryParameters)object2).e = 3;
                            continue block20;
                        }
                        case "fail": {
                            ((URIQueryParameters)object2).e = 1;
                        }
                    }
                    continue;
                }
                if (!string.equals("parser") || object3 == null) continue;
                ((URIQueryParameters)object2).f = new Instantiator<XMLReader>(string2, (Configuration)object3);
            }
        }
    }

    public static FilenameFilter makeGlobFilter(String string) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(string.length() + 6);
        fastStringBuffer.append('^');
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '.') {
                fastStringBuffer.append("\\.");
                continue;
            }
            if (c2 == '*') {
                fastStringBuffer.append(".*");
                continue;
            }
            if (c2 == '?') {
                fastStringBuffer.append(".?");
                continue;
            }
            fastStringBuffer.append(c2);
        }
        fastStringBuffer.append('$');
        try {
            return new RegexFilter(new JavaRegularExpression(fastStringBuffer, ""));
        }
        catch (XPathException xPathException) {
            throw new XPathException("Invalid glob " + string + " in collection URI", "FODC0004");
        }
    }

    public SpaceStrippingRule getSpaceStrippingRule() {
        return this.d;
    }

    public Integer getValidationMode() {
        return this.c;
    }

    public FilenameFilter getFilenameFilter() {
        return this.a;
    }

    public Boolean getRecurse() {
        return this.b;
    }

    public Integer getOnError() {
        return this.e;
    }

    public Boolean getXInclude() {
        return this.g;
    }

    public Boolean getMetaData() {
        return this.j;
    }

    public boolean isUnparsed() {
        return this.h;
    }

    public Boolean getStable() {
        return this.i;
    }

    public Maker<XMLReader> getXMLReaderMaker() {
        return this.f;
    }

    public static class RegexFilter
    implements FilenameFilter {
        private RegularExpression a;

        public RegexFilter(RegularExpression regularExpression) {
            this.a = regularExpression;
        }

        @Override
        public boolean accept(File file, String string) {
            return new File(file, string).isDirectory() || this.a.matches(string);
        }

        public boolean matches(String string) {
            return this.a.matches(string);
        }
    }
}

