/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.function.IntPredicate;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.EncodeForUri;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.regex.LatinString;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;

public abstract class UnparsedTextFunction
extends SystemFunction {
    @Override
    public int getSpecialProperties(Expression[] expressionArray) {
        int n2 = super.getSpecialProperties(expressionArray);
        if (this.getRetainedStaticContext().getConfiguration().getBooleanProperty(Feature.STABLE_UNPARSED_TEXT)) {
            return n2;
        }
        return n2 & 0xFF7FFFFF;
    }

    public static CharSequence readFile(URI serializable, String string, XPathContext xPathContext) {
        Object object = xPathContext.getConfiguration();
        IntPredicate intPredicate = ((Configuration)object).getValidCharacterChecker();
        try {
            object = xPathContext.getController().getUnparsedTextURIResolver().resolve((URI)serializable, string, (Configuration)object);
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.maybeSetErrorCode("FOUT1170");
            throw object;
        }
        try {
            return UnparsedTextFunction.readFile(intPredicate, (Reader)object);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            serializable = new XPathException("Unknown encoding " + Err.wrap(string), unsupportedEncodingException);
            ((XPathException)serializable).setErrorCode("FOUT1190");
            throw serializable;
        }
        catch (IOException iOException) {
            throw UnparsedTextFunction.handleIOError(serializable, iOException, xPathContext);
        }
    }

    public static URI getAbsoluteURI(String object, String string, XPathContext xPathContext) {
        try {
            object = ResolveURI.makeAbsolute((String)object, string);
        }
        catch (URISyntaxException uRISyntaxException) {
            XPathException xPathException = new XPathException(uRISyntaxException.getReason() + ": " + uRISyntaxException.getInput(), uRISyntaxException);
            xPathException.setErrorCode("FOUT1170");
            throw xPathException;
        }
        if (((URI)object).getFragment() != null) {
            object = new XPathException("URI for unparsed-text() must not contain a fragment identifier");
            ((XPathException)object).setErrorCode("FOUT1170");
            throw object;
        }
        EncodeForUri.checkPercentEncoding(((URI)object).toString());
        return object;
    }

    public static XPathException handleIOError(URI serializable, IOException object, XPathContext object2) {
        object2 = "Failed to read input file";
        if (serializable != null && !((Throwable)object).getMessage().equals(((URI)serializable).toString())) {
            object2 = (String)object2 + ' ' + ((URI)serializable).toString();
        }
        object2 = (String)object2 + " (" + object.getClass().getName() + ')';
        serializable = new XPathException((String)object2, (Throwable)object);
        object = object instanceof MalformedInputException ? "FOUT1200" : (object instanceof UnmappableCharacterException ? "FOUT1200" : (object instanceof CharacterCodingException ? "FOUT1200" : "FOUT1170"));
        ((XPathException)serializable).setErrorCode((String)object);
        return serializable;
    }

    public static CharSequence readFile(IntPredicate intPredicate, Reader reader) {
        int n2;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(2048);
        char[] cArray = new char[2048];
        boolean bl2 = true;
        int n3 = 1;
        int n4 = 1;
        boolean bl3 = true;
        while ((n2 = reader.read(cArray, 0, cArray.length)) >= 0) {
            int n5 = 0;
            while (n5 < n2) {
                int n6;
                if ((n6 = cArray[n5++]) == 10) {
                    ++n3;
                    n4 = 0;
                }
                ++n4;
                if (n6 > 255) {
                    bl3 = false;
                    if (UTF16CharacterSet.isHighSurrogate(n6)) {
                        if (n5 == n2) {
                            char[] cArray2 = new char[2048];
                            int n7 = reader.read(cArray2, 0, 2048);
                            char[] cArray3 = new char[n2 + n7];
                            System.arraycopy(cArray, 0, cArray3, 0, n2);
                            System.arraycopy(cArray2, 0, cArray3, n2, n7);
                            cArray = cArray3;
                            n2 += n7;
                        }
                        char c2 = cArray[n5++];
                        n6 = UTF16CharacterSet.combinePair((char)n6, c2);
                    }
                }
                if (intPredicate.test(n6)) continue;
                XPathException xPathException = new XPathException("The text file contains a character that is illegal in XML (line=" + n3 + " column=" + n4 + " value=hex " + Integer.toHexString(n6) + ')');
                xPathException.setErrorCode("FOUT1190");
                throw xPathException;
            }
            if (bl2) {
                bl2 = false;
                if (cArray[0] == '\ufeff') {
                    fastStringBuffer.append(cArray, 1, n2 - 1);
                    continue;
                }
                fastStringBuffer.append(cArray, 0, n2);
                continue;
            }
            fastStringBuffer.append(cArray, 0, n2);
        }
        reader.close();
        if (bl3) {
            return new LatinString(fastStringBuffer);
        }
        return fastStringBuffer.condense();
    }
}

