/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ResourceCollection;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;

public class UriCollection
extends SystemFunction {
    private SequenceIterator<AnyURIValue> a(String object, XPathContext xPathContext) {
        ResourceCollection resourceCollection = xPathContext.getConfiguration().getCollectionFinder().findCollection(xPathContext, (String)object);
        if (resourceCollection == null) {
            object = new XPathException("No collection has been defined for href: " + (String)(object == null ? "" : object));
            ((XPathException)object).setErrorCode("FODC0002");
            ((XPathException)object).setXPathContext(xPathContext);
            throw object;
        }
        object = resourceCollection.getResourceURIs(xPathContext);
        return new SequenceIterator<AnyURIValue>(this, (Iterator)object){
            private /* synthetic */ Iterator a;
            private /* synthetic */ UriCollection b;
            {
                this.b = uriCollection;
                this.a = iterator;
            }

            @Override
            public final void close() {
                if (this.a instanceof Closeable) {
                    try {
                        ((Closeable)((Object)this.a)).close();
                        return;
                    }
                    catch (IOException iOException) {
                        throw new UncheckedXPathException(new XPathException(iOException));
                    }
                }
            }

            @Override
            public final /* synthetic */ Item next() {
                1 var1_1 = this;
                if (var1_1.a.hasNext()) {
                    return new AnyURIValue((CharSequence)var1_1.a.next());
                }
                return null;
            }
        };
    }

    public Sequence<AnyURIValue> call(XPathContext xPathContext, Sequence[] object) {
        URI uRI;
        if (((Sequence[])object).length == 0) {
            return this.a(xPathContext);
        }
        if ((object = object[0].head()) == null) {
            return this.a(xPathContext);
        }
        object = object.getStringValue();
        try {
            uRI = new URI((String)object);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XPathException("Invalid URI passed to uri-collection: " + (String)object, "FODC0004");
        }
        if (!uRI.isAbsolute()) {
            object = this.getRetainedStaticContext().getStaticBaseUri();
            if (object == null) {
                throw new XPathException("No base URI available for uri-collection", "FODC0002");
            }
            uRI = ((URI)object).resolve(uRI);
        }
        return new LazySequence<AnyURIValue>(this.a(uRI.toString(), xPathContext));
    }

    private Sequence<AnyURIValue> a(XPathContext xPathContext) {
        String string = xPathContext.getConfiguration().getDefaultCollection();
        if (string == null) {
            throw new XPathException("No default collection has been defined", "FODC0002");
        }
        return new LazySequence<AnyURIValue>(this.a(string, xPathContext));
    }
}

