/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions.registry;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.OptionsParameter;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public abstract class BuiltInFunctionSet
implements FunctionLibrary {
    public static Sequence<?> EMPTY = EmptySequence.getInstance();
    public static final int CORE = 1;
    public static final int XSLT = 2;
    public static final int USE_WHEN = 4;
    public static final int XQUPDATE = 8;
    public static final int XPATH30 = 16;
    public static final int INTERNAL = 32;
    public static final int XSLT30 = 64;
    public static final int XPATH31 = 128;
    public static final int HOF = 256;
    public static final int ONE = 16384;
    public static final int OPT = 24576;
    public static final int STAR = 57344;
    public static final int PLUS = 49152;
    public static final int AS_ARG0 = 1;
    public static final int AS_PRIM_ARG0 = 2;
    public static final int CITEM = 4;
    public static final int BASE = 8;
    public static final int NS = 16;
    public static final int DCOLL = 32;
    public static final int DLANG = 64;
    public static final int FILTER = 256;
    public static final int LATE = 512;
    public static final int UO = 1024;
    public static final int POSN = 2048;
    public static final int LAST = 4096;
    public static final int SIDE = 8192;
    public static final int CDOC = 16384;
    public static final int CARD0 = 32768;
    public static final int NEW = 65536;
    public static final int DEPENDS_ON_STATIC_CONTEXT = 56;
    public static final int FOCUS = 22532;
    public static final int INS = 0x1000000;
    public static final int ABS = 0x2000000;
    public static final int TRA = 0x4000000;
    public static final int NAV = 0x8000000;
    private HashMap<String, Entry> a = new HashMap(200);

    public final void importFunctionSet(BuiltInFunctionSet builtInFunctionSet) {
        if (!builtInFunctionSet.getNamespace().equals(this.getNamespace())) {
            throw new IllegalArgumentException(builtInFunctionSet.getNamespace());
        }
        this.a.putAll(builtInFunctionSet.a);
    }

    public Entry getFunctionDetails(String string, int n2) {
        if (n2 == -1) {
            for (int i2 = 0; i2 < 20; ++i2) {
                Entry entry = this.getFunctionDetails(string, i2);
                if (entry == null) continue;
                return entry;
            }
            return null;
        }
        String string2 = string + "#" + n2;
        Entry entry = this.a.get(string2);
        if (entry != null) {
            return entry;
        }
        if (string.equals("concat") && n2 >= 2 && this.getNamespace().equals("http://www.w3.org/2005/xpath-functions") && (entry = this.a.get(string2 = "concat#-1")) != null) {
            return entry;
        }
        return null;
    }

    @Override
    public Expression bind(SymbolicName.F f2, Expression[] expressionArray, StaticContext object, List<String> list) {
        StructuredQName structuredQName = f2.getComponentName();
        int n2 = f2.getArity();
        String string = structuredQName.getLocalPart();
        if (structuredQName.hasURI(this.getNamespace()) && this.getFunctionDetails(string, n2) != null) {
            object = new RetainedStaticContext((StaticContext)object);
            try {
                Object object2 = this.makeFunction(string, n2);
                ((SystemFunction)object2).setRetainedStaticContext((RetainedStaticContext)object);
                object2 = ((SystemFunction)object2).makeFunctionCall(expressionArray);
                ((Expression)object2).setRetainedStaticContext((RetainedStaticContext)object);
                return object2;
            }
            catch (XPathException xPathException) {
                list.add(xPathException.getMessage());
                return null;
            }
        }
        return null;
    }

    public SystemFunction makeFunction(String string, int n2) {
        Entry entry = this.getFunctionDetails(string, n2);
        if (entry == null) {
            int n3;
            Object object;
            Object object2 = object = this.getNamespace().equals("http://www.w3.org/2005/xpath-functions") ? "System function " + string : "Function Q{" + this.getNamespace() + "}" + string;
            if (this.getFunctionDetails(string, -1) == null) {
                object = new XPathException((String)object + "() does not exist or is not available in this environment");
                ((XPathException)object).setErrorCode("XPST0017");
                ((XPathException)object).setIsStaticError(true);
                throw object;
            }
            object = new XPathException((String)object + "() cannot be called with " + ((n3 = n2) == 0 ? "zero arguments" : (n3 == 1 ? "one argument" : n3 + " arguments")));
            ((XPathException)object).setErrorCode("XPST0017");
            ((XPathException)object).setIsStaticError(true);
            throw object;
        }
        Object object = entry.implementationClass;
        try {
            object = (SystemFunction)((Class)object).newInstance();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            throw new AssertionError((Object)("Failed to instantiate system function " + string + " - " + exception2.getMessage()));
        }
        ((SystemFunction)object).setDetails(entry);
        ((SystemFunction)object).setArity(n2);
        return object;
    }

    @Override
    public boolean isAvailable(SymbolicName.F f2) {
        StructuredQName structuredQName = f2.getComponentName();
        return structuredQName.hasURI(this.getNamespace()) && this.getFunctionDetails(structuredQName.getLocalPart(), f2.getArity()) != null;
    }

    @Override
    public FunctionLibrary copy() {
        return this;
    }

    protected Entry register(String string, int n2, Class<? extends SystemFunction> clazz, ItemType itemType, int n3, int n4, int n5) {
        Entry entry = new Entry();
        new Entry().name = new StructuredQName(this.getConventionalPrefix(), this.getNamespace(), string);
        entry.arity = n2;
        entry.implementationClass = clazz;
        entry.itemType = itemType;
        entry.cardinality = n3;
        entry.applicability = n4;
        entry.properties = n5;
        if (entry.arity == -1) {
            entry.argumentTypes = new SequenceType[1];
            entry.resultIfEmpty = new AtomicValue[1];
            entry.usage = new OperandUsage[1];
        } else {
            entry.argumentTypes = new SequenceType[n2];
            entry.resultIfEmpty = new Sequence[n2];
            entry.usage = new OperandUsage[n2];
        }
        this.a.put(string + "#" + n2, entry);
        return entry;
    }

    protected void registerReducedArityVariants(String object, int n2, int n3) {
        object = this.a.get(object);
        while (n2 <= n3) {
            Entry entry = new Entry();
            new Entry().name = ((Entry)object).name;
            entry.arity = n2;
            entry.implementationClass = ((Entry)object).implementationClass;
            entry.itemType = ((Entry)object).itemType;
            entry.cardinality = ((Entry)object).cardinality;
            entry.applicability = ((Entry)object).applicability;
            entry.properties = ((Entry)object).properties;
            entry.argumentTypes = new SequenceType[n2];
            entry.resultIfEmpty = new Sequence[n2];
            entry.usage = new OperandUsage[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                entry.argumentTypes[i2] = ((Entry)object).argumentTypes[i2];
                entry.resultIfEmpty[i2] = ((Entry)object).resultIfEmpty[i2];
                entry.usage[i2] = ((Entry)object).usage[i2];
            }
            this.a.put(entry.name.getLocalPart() + "#" + n2, entry);
            ++n2;
        }
    }

    public String getNamespace() {
        return "http://www.w3.org/2005/xpath-functions";
    }

    public String getConventionalPrefix() {
        return "fn";
    }

    public static class Entry
    implements Serializable {
        public StructuredQName name;
        public Class implementationClass;
        public int arity;
        public ItemType itemType;
        public int cardinality;
        public int applicability;
        public OperandUsage[] usage;
        public SequenceType[] argumentTypes;
        public Sequence<?>[] resultIfEmpty;
        public int properties;
        public OptionsParameter optionDetails;
        public Class streamingAdjunct;

        public Entry arg(int n2, ItemType itemType, int n3, Sequence<?> sequence) {
            int n4 = n3 & 0xE000;
            OperandUsage operandUsage = OperandUsage.NAVIGATION;
            if ((n3 & 0x2000000) != 0) {
                operandUsage = OperandUsage.ABSORPTION;
            } else if ((n3 & 0x4000000) != 0) {
                operandUsage = OperandUsage.TRANSMISSION;
            } else if ((n3 & 0x1000000) != 0) {
                operandUsage = OperandUsage.INSPECTION;
            } else if (itemType instanceof PlainType) {
                operandUsage = OperandUsage.ABSORPTION;
            }
            try {
                this.argumentTypes[n2] = SequenceType.makeSequenceType(itemType, n4);
                this.resultIfEmpty[n2] = sequence;
                this.usage[n2] = operandUsage;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("Internal Saxon error: Can't set argument " + n2 + " of " + this.name);
            }
            return this;
        }

        public Entry optionDetails(OptionsParameter optionsParameter) {
            this.optionDetails = optionsParameter;
            return this;
        }

        public void setStreamingAdjunctClass(Class clazz) {
            this.streamingAdjunct = clazz;
        }
    }
}

