/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions.registry;

import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.CastingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ListConstructorFunction;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StaticFunctionCall;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.UnionConstructorFunction;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.UnionType;

public class ConstructorFunctionLibrary
implements FunctionLibrary {
    private Configuration a;

    public ConstructorFunctionLibrary(Configuration configuration) {
        this.a = configuration;
    }

    @Override
    public boolean isAvailable(SymbolicName.F object) {
        if (((SymbolicName.F)object).getArity() != 1) {
            return false;
        }
        String string = ((SymbolicName)object).getComponentName().getURI();
        object = ((SymbolicName)object).getComponentName().getLocalPart();
        if ((object = this.a.getSchemaType(new StructuredQName("", string, (String)object))) == null || object.isComplexType()) {
            return false;
        }
        if (object.isAtomicType() && ((AtomicType)object).isAbstract()) {
            return false;
        }
        return object != AnySimpleType.getInstance();
    }

    @Override
    public Expression bind(SymbolicName.F object, Expression[] expressionArray, StaticContext object2, List<String> list) {
        String string = ((SymbolicName)object).getComponentName().getURI();
        String string2 = ((SymbolicName)object).getComponentName().getLocalPart();
        boolean bl2 = string.equals("http://www.w3.org/2001/XMLSchema");
        if (bl2) {
            if (((SymbolicName.F)object).getArity() != 1) {
                list.add("A constructor function must have exactly one argument");
                return null;
            }
            object = Type.getBuiltInSimpleType(string, string2);
            if (object != null) {
                if (object.isAtomicType()) {
                    if (((AtomicType)object).isAbstract()) {
                        list.add("Abstract type used in constructor function: {" + string + '}' + string2);
                        return null;
                    }
                    object2 = new CastExpression(expressionArray[0], (AtomicType)object, true);
                    if (expressionArray[0] instanceof StringLiteral) {
                        ((CastingExpression)object2).setOperandIsStringLiteral(true);
                    }
                    return object2;
                }
                if (object.isUnionType()) {
                    object2 = object2.getNamespaceResolver();
                    object = new UnionConstructorFunction((UnionType)object, (NamespaceResolver)object2, true);
                    return new StaticFunctionCall((Function)object, expressionArray);
                }
                object2 = object2.getNamespaceResolver();
                try {
                    object = new ListConstructorFunction((ListType)object, (NamespaceResolver)object2, true);
                    return new StaticFunctionCall((Function)object, expressionArray);
                }
                catch (MissingComponentException missingComponentException) {
                    list.add("Missing schema component: " + missingComponentException.getMessage());
                    return null;
                }
            }
            list.add("Unknown constructor function: {" + string + '}' + string2);
            return null;
        }
        if (expressionArray.length == 1 && (object = this.a.getSchemaType(new StructuredQName("", string, string2))) instanceof SimpleType) {
            if (object instanceof AtomicType) {
                return new CastExpression(expressionArray[0], (AtomicType)object, true);
            }
            if (object instanceof ListType && object2.getXPathVersion() >= 30) {
                object2 = object2.getNamespaceResolver();
                try {
                    object = new ListConstructorFunction((ListType)object, (NamespaceResolver)object2, true);
                    return new StaticFunctionCall((Function)object, expressionArray);
                }
                catch (MissingComponentException missingComponentException) {
                    list.add("Missing schema component: " + missingComponentException.getMessage());
                    return null;
                }
            }
            if (((SimpleType)object).isUnionType() && object2.getXPathVersion() >= 30) {
                object2 = object2.getNamespaceResolver();
                object = new UnionConstructorFunction((UnionType)object, (NamespaceResolver)object2, true);
                return new StaticFunctionCall((Function)object, expressionArray);
            }
        }
        return null;
    }

    @Override
    public FunctionLibrary copy() {
        return this;
    }
}

