/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions.registry;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.StringValue;

public class ExsltCommonFunctionSet
extends BuiltInFunctionSet {
    private static ExsltCommonFunctionSet a = new ExsltCommonFunctionSet();

    public static ExsltCommonFunctionSet getInstance() {
        return a;
    }

    private ExsltCommonFunctionSet() {
        ExsltCommonFunctionSet exsltCommonFunctionSet = this;
        exsltCommonFunctionSet.register("node-set", 1, NodeSetFn.class, AnyItemType.getInstance(), 24576, 0, 0).arg(0, AnyItemType.getInstance(), 24576, EMPTY);
        exsltCommonFunctionSet.register("object-type", 1, ObjectTypeFn.class, BuiltInAtomicType.STRING, 16384, 0, 0).arg(0, AnyItemType.getInstance(), 16384, null);
    }

    @Override
    public String getNamespace() {
        return "http://exslt.org/common";
    }

    @Override
    public String getConventionalPrefix() {
        return "exsltCommon";
    }

    public static class ObjectTypeFn
    extends SystemFunction {
        @Override
        public Sequence<?> call(XPathContext object, Sequence[] object2) {
            object = object.getConfiguration().getTypeHierarchy();
            object2 = object2[0].head();
            if (((TypeHierarchy)object).isSubType((ItemType)(object2 = SequenceTool.getItemType(object2, (TypeHierarchy)object)), AnyNodeTest.getInstance())) {
                return new StringValue("node-set");
            }
            if (((TypeHierarchy)object).isSubType((ItemType)object2, BuiltInAtomicType.STRING)) {
                return new StringValue("string");
            }
            if (((TypeHierarchy)object).isSubType((ItemType)object2, NumericType.getInstance())) {
                return new StringValue("number");
            }
            if (((TypeHierarchy)object).isSubType((ItemType)object2, BuiltInAtomicType.BOOLEAN)) {
                return new StringValue("boolean");
            }
            return new StringValue(object2.toString());
        }
    }

    public static class NodeSetFn
    extends SystemFunction {
        @Override
        public Sequence<?> call(XPathContext xPathContext, Sequence[] sequenceArray) {
            return sequenceArray[0];
        }
    }
}

