/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions.registry;

import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.ApplyFn;
import net.sf.saxon.functions.Doc_2;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.map.MapCreate;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.ma.map.MapUntypedContains;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;

public class VendorFunctionSetHE
extends BuiltInFunctionSet {
    private static VendorFunctionSetHE a = new VendorFunctionSetHE();

    public static VendorFunctionSetHE getInstance() {
        return a;
    }

    private VendorFunctionSetHE() {
        VendorFunctionSetHE vendorFunctionSetHE = this;
        vendorFunctionSetHE.register("is-whole-number", 1, IsWholeNumberFn.class, BuiltInAtomicType.BOOLEAN, 16384, 0, 0).arg(0, NumericType.getInstance(), 24576, EMPTY);
        vendorFunctionSetHE.register("dynamic-error-info", 1, DynamicErrorInfoFn.class, AnyItemType.getInstance(), 57344, 0, 31236).arg(0, BuiltInAtomicType.STRING, 16384, null);
        vendorFunctionSetHE.register("apply", 2, ApplyFn.class, AnyItemType.getInstance(), 57344, 0, 512).arg(0, AnyFunctionType.getInstance(), 16384, null).arg(1, ArrayItemType.ANY_ARRAY_TYPE, 16384, null);
        vendorFunctionSetHE.register("create-map", 1, MapCreate.class, MapType.ANY_MAP_TYPE, 16384, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 57344, null);
        vendorFunctionSetHE.register("doc", 2, Doc_2.class, NodeKindTest.DOCUMENT, 16384, 0, 512).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, MapType.ANY_MAP_TYPE, 16384, EMPTY).optionDetails(Doc_2.makeOptionsParameter());
        vendorFunctionSetHE.register("has-local-namespaces", 1, HasLocalNamespaces.class, BuiltInAtomicType.BOOLEAN, 16384, 0, 0).arg(0, NodeKindTest.ELEMENT, 16384, null);
        vendorFunctionSetHE.register("has-uniform-namespaces", 1, HasUniformNamespaces.class, BuiltInAtomicType.BOOLEAN, 16384, 0, 0).arg(0, NodeKindTest.ELEMENT, 16384, null);
        vendorFunctionSetHE.register("map-untyped-contains", 2, MapUntypedContains.class, BuiltInAtomicType.BOOLEAN, 16384, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 57344, null).arg(1, BuiltInAtomicType.ANY_ATOMIC, 16384, null);
    }

    @Override
    public String getNamespace() {
        return "http://saxon.sf.net/";
    }

    @Override
    public String getConventionalPrefix() {
        return "saxon";
    }

    public static class DynamicErrorInfoFn
    extends SystemFunction {
        @Override
        public int getSpecialProperties(Expression[] expressionArray) {
            return 0;
        }

        @Override
        public Sequence<?> call(XPathContext object, Sequence[] object2) {
            object2 = object2[0].head().getStringValue();
            if ((object = object.getCurrentException()) == null) {
                return EmptySequence.getInstance();
            }
            Location location = ((XPathException)object).getLocator();
            int n2 = -1;
            switch (((String)object2).hashCode()) {
                case 3059181: {
                    if (!((String)object2).equals("code")) break;
                    n2 = 0;
                    break;
                }
                case -1724546052: {
                    if (!((String)object2).equals("description")) break;
                    n2 = 1;
                    break;
                }
                case 111972721: {
                    if (!((String)object2).equals("value")) break;
                    n2 = 2;
                    break;
                }
                case -1068784020: {
                    if (!((String)object2).equals("module")) break;
                    n2 = 3;
                    break;
                }
                case -1029014718: {
                    if (!((String)object2).equals("line-number")) break;
                    n2 = 4;
                    break;
                }
                case -613145184: {
                    if (!((String)object2).equals("column-number")) break;
                    n2 = 5;
                }
            }
            switch (n2) {
                case 0: {
                    object = ((XPathException)object).getErrorCodeQName();
                    if (object == null) {
                        object = new StructuredQName("saxon", "http://saxon.sf.net/", "XXXX9999");
                    }
                    return new QNameValue((StructuredQName)object, BuiltInAtomicType.QNAME);
                }
                case 1: {
                    object2 = ((Throwable)object).getMessage();
                    if (((TransformerException)object).getCause() != null) {
                        object2 = (String)object2 + "(" + ((TransformerException)object).getCause().getMessage() + ")";
                    }
                    return new StringValue((CharSequence)object2);
                }
                case 2: {
                    object = ((XPathException)object).getErrorObject();
                    if (object == null) {
                        return EmptySequence.getInstance();
                    }
                    return object;
                }
                case 3: {
                    object = location == null ? null : location.getSystemId();
                    if (object == null) {
                        return EmptySequence.getInstance();
                    }
                    return new StringValue((CharSequence)object);
                }
                case 4: {
                    int n3 = location == null ? -1 : location.getLineNumber();
                    if (n3 == -1) {
                        return EmptySequence.getInstance();
                    }
                    return new Int64Value(n3);
                }
                case 5: {
                    if (location == null) {
                        return EmptySequence.getInstance();
                    }
                    int n4 = location instanceof XPathParser.NestedLocation ? ((XPathParser.NestedLocation)location).getContainingLocation().getColumnNumber() : location.getColumnNumber();
                    if (n4 == -1) {
                        return EmptySequence.getInstance();
                    }
                    return new Int64Value(n4);
                }
            }
            return EmptySequence.getInstance();
        }
    }

    public static class HasUniformNamespaces
    extends SystemFunction {
        public BooleanValue call(XPathContext object, Sequence[] sequenceArray) {
            object = (NodeInfo)sequenceArray[0].head();
            if (object instanceof TinyElementImpl) {
                return BooleanValue.get(((TinyElementImpl)object).hasUniformNamespaces());
            }
            return BooleanValue.FALSE;
        }
    }

    public static class HasLocalNamespaces
    extends SystemFunction {
        public BooleanValue call(XPathContext object, Sequence[] object2) {
            object = (NodeInfo)object2[0].head();
            return BooleanValue.get((object2 = object.getParent()) == null || object2.getNodeKind() == 9 || object.getDeclaredNamespaces(NamespaceBinding.EMPTY_ARRAY).length > 0);
        }
    }

    public static class IsWholeNumberFn
    extends SystemFunction {
        @Override
        public Expression makeOptimizedFunctionCall(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo, Expression ... expressionArray) {
            if (expressionArray[0].getItemType().getPrimitiveItemType() == BuiltInAtomicType.INTEGER) {
                return Literal.makeLiteral(BooleanValue.TRUE);
            }
            return null;
        }

        @Override
        public Sequence<?> call(XPathContext object, Sequence[] sequenceArray) {
            object = (NumericValue)sequenceArray[0].head();
            return BooleanValue.get(object != null && ((NumericValue)object).isWholeNumber());
        }
    }
}

