/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.java;

import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.sort.AlphanumericCollator;
import net.sf.saxon.expr.sort.CaseFirstCollator;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.SimpleCollation;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.XPathException;

public abstract class JavaCollationFactory {
    private JavaCollationFactory() {
    }

    public static StringCollator makeCollation(Configuration object, String string, Properties properties) {
        String string2;
        Collator collator = null;
        StringCollator stringCollator = null;
        Object object2 = properties.getProperty("class");
        if (object2 != null) {
            if ((object = ((Configuration)object).getInstance((String)object2, null)) instanceof Collator) {
                collator = (Collator)object;
            } else if (object instanceof StringCollator) {
                stringCollator = (StringCollator)object;
            } else if (object instanceof Comparator) {
                stringCollator = new SimpleCollation(string, (Comparator)object);
            } else {
                throw new XPathException("Requested collation class " + (String)object2 + " is not a Comparator");
            }
        }
        if (collator == null && stringCollator == null) {
            object = properties.getProperty("rules");
            if (object != null) {
                try {
                    collator = new RuleBasedCollator((String)object);
                }
                catch (ParseException parseException) {
                    throw new XPathException("Invalid collation rules: " + parseException.getMessage());
                }
            }
            if (collator == null) {
                object2 = properties.getProperty("lang");
                if (object2 != null) {
                    object = object2;
                    int n2 = ((String)object).indexOf("-");
                    if (n2 <= 0) {
                        object2 = object;
                        object = "";
                    } else {
                        object2 = ((String)object).substring(0, n2);
                        object = ((String)object).substring(n2 + 1);
                    }
                    collator = Collator.getInstance(new Locale((String)object2, (String)object));
                } else {
                    collator = Collator.getInstance();
                }
            }
        }
        if (collator != null) {
            Object object3;
            object = properties.getProperty("strength");
            if (object != null) {
                switch (object) {
                    case "primary": {
                        collator.setStrength(0);
                        break;
                    }
                    case "secondary": {
                        collator.setStrength(1);
                        break;
                    }
                    case "tertiary": {
                        collator.setStrength(2);
                        break;
                    }
                    case "identical": {
                        collator.setStrength(3);
                        break;
                    }
                    default: {
                        throw new XPathException("strength must be primary, secondary, tertiary, or identical");
                    }
                }
            }
            if ((object2 = properties.getProperty("ignore-width")) != null) {
                if (((String)object2).equals("yes") && object == null) {
                    collator.setStrength(2);
                } else if (!((String)object2).equals("no")) {
                    throw new XPathException("ignore-width must be yes or no");
                }
            }
            if ((object2 = properties.getProperty("ignore-case")) != null && object == null) {
                switch (object2) {
                    case "yes": {
                        collator.setStrength(1);
                        break;
                    }
                    case "no": {
                        break;
                    }
                    default: {
                        throw new XPathException("ignore-case must be yes or no");
                    }
                }
            }
            if ((object2 = properties.getProperty("ignore-modifiers")) != null) {
                if (((String)object2).equals("yes") && object == null) {
                    collator.setStrength(0);
                } else if (!((String)object2).equals("no")) {
                    throw new XPathException("ignore-modifiers must be yes or no");
                }
            }
            if ((object3 = properties.getProperty("decomposition")) != null) {
                switch (object3) {
                    case "none": {
                        collator.setDecomposition(0);
                        break;
                    }
                    case "standard": {
                        collator.setDecomposition(1);
                        break;
                    }
                    case "full": {
                        collator.setDecomposition(2);
                        break;
                    }
                    default: {
                        throw new XPathException("decomposition must be none, standard, or full");
                    }
                }
            }
        }
        if (stringCollator == null) {
            stringCollator = new SimpleCollation(string, collator);
        }
        if ((string2 = properties.getProperty("case-order")) != null && !"#default".equals(string2)) {
            if (collator != null) {
                collator.setStrength(1);
            }
            stringCollator = CaseFirstCollator.makeCaseOrderedCollator(string, stringCollator, string2);
        }
        if ((object2 = properties.getProperty("alphanumeric")) != null && !"no".equals(object2)) {
            switch (object2) {
                case "yes": {
                    stringCollator = new AlphanumericCollator(stringCollator);
                    break;
                }
                case "codepoint": {
                    stringCollator = new AlphanumericCollator(CodepointCollator.getInstance());
                    break;
                }
                default: {
                    throw new XPathException("alphanumeric must be yes, no, or codepoint");
                }
            }
        }
        return stringCollator;
    }
}

