/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.jaxp;

import java.util.Enumeration;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.lib.DelegatingErrorListener;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.SAXParseException;

public class IdentityTransformer
extends Transformer {
    private Configuration a;
    private Properties b;
    private URIResolver c;
    private ErrorListener d;

    protected IdentityTransformer(Configuration configuration) {
        this.a = configuration;
        this.c = configuration.getURIResolver();
    }

    @Override
    public void reset() {
        this.b = null;
        this.c = this.getConfiguration().getURIResolver();
        this.d = null;
    }

    @Override
    public void setURIResolver(URIResolver uRIResolver) {
        this.c = uRIResolver;
    }

    @Override
    public URIResolver getURIResolver() {
        return this.c;
    }

    @Override
    public void setErrorListener(ErrorListener errorListener) {
        this.d = errorListener;
    }

    @Override
    public ErrorListener getErrorListener() {
        if (this.d instanceof DelegatingErrorListener) {
            return ((DelegatingErrorListener)this.d).getBaseErrorListener();
        }
        return this.d;
    }

    @Override
    public void setOutputProperties(Properties properties) {
        if (properties == null) {
            this.b = null;
            return;
        }
        for (String string : properties.stringPropertyNames()) {
            this.setOutputProperty(string, properties.getProperty(string));
        }
    }

    @Override
    public Properties getOutputProperties() {
        String string;
        Properties properties = new Properties();
        Properties properties2 = this.getStylesheetOutputProperties();
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            properties.setProperty(string, properties2.getProperty(string));
        }
        if (this.b != null) {
            enumeration = this.b.propertyNames();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                properties.setProperty(string, this.b.getProperty(string));
            }
        }
        return properties;
    }

    protected Properties getStylesheetOutputProperties() {
        return new Properties();
    }

    protected Properties getLocalOutputProperties() {
        if (this.b == null) {
            this.a();
        }
        return this.b;
    }

    private void a() {
        this.b = new Properties();
    }

    @Override
    public String getOutputProperty(String string) {
        try {
            this.getConfiguration().getSerializerFactory().checkOutputProperty(string, null);
        }
        catch (XPathException xPathException) {
            throw new IllegalArgumentException(xPathException.getMessage());
        }
        String string2 = null;
        if (this.b != null) {
            string2 = this.b.getProperty(string);
        }
        if (string2 == null) {
            string2 = this.getStylesheetOutputProperties().getProperty(string);
        }
        return string2;
    }

    @Override
    public void setOutputProperty(String string, String string2) {
        block3: {
            if (this.b == null) {
                this.a();
            }
            try {
                string2 = this.getConfiguration().getSerializerFactory().checkOutputProperty(string, string2);
            }
            catch (XPathException xPathException) {
                if (string.startsWith("{")) break block3;
                throw new IllegalArgumentException(xPathException.getMessage());
            }
        }
        this.b.setProperty(string, string2);
    }

    @Override
    public void setParameter(String string, Object object) {
    }

    @Override
    public Object getParameter(String string) {
        return null;
    }

    @Override
    public void clearParameters() {
    }

    @Override
    public void transform(Source source, Result object) {
        try {
            SerializerFactory serializerFactory = this.getConfiguration().getSerializerFactory();
            object = serializerFactory.getReceiver((Result)object, new SerializationProperties(this.getOutputProperties()));
            ParseOptions parseOptions = object.getPipelineConfiguration().getParseOptions();
            parseOptions.setContinueAfterValidationErrors(true);
            Sender.send(source, (Receiver)object, parseOptions);
            return;
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            object = xPathException.getException();
            if (object instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)object;
                if ((object = sAXParseException.getException()) instanceof RuntimeException) {
                    this.reportFatalError(xPathException2);
                }
            } else {
                this.reportFatalError(xPathException2);
            }
            throw xPathException2;
        }
    }

    public Configuration getConfiguration() {
        return this.a;
    }

    protected void reportFatalError(XPathException xPathException) {
        try {
            if (this.d == null) {
                this.getConfiguration().getErrorListener().error(xPathException);
                return;
            }
            this.d.error(xPathException);
        }
        catch (TransformerException transformerException) {}
    }
}

