/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.jaxp;

import java.io.File;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.jaxp.IdentityTransformer;
import net.sf.saxon.jaxp.IdentityTransformerHandler;
import net.sf.saxon.jaxp.TemplatesHandlerImpl;
import net.sf.saxon.jaxp.TemplatesImpl;
import net.sf.saxon.jaxp.TransformerImpl;
import net.sf.saxon.jaxp.a;
import net.sf.saxon.lib.DelegatingErrorListener;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.ConfigurationReader;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.XMLFilter;

public class SaxonTransformerFactory
extends SAXTransformerFactory
implements Configuration.ApiProvider {
    private Processor a;

    public SaxonTransformerFactory() {
        this.a = new Processor(true);
    }

    public SaxonTransformerFactory(Configuration configuration) {
        this.a = new Processor(configuration);
    }

    public void setConfiguration(Configuration configuration) {
        this.a.setConfigurationProperty(Feature.CONFIGURATION, configuration);
    }

    public Configuration getConfiguration() {
        return this.a.getUnderlyingConfiguration();
    }

    @Override
    public Transformer newTransformer(Source object) {
        object = this.newTemplates((Source)object);
        return object.newTransformer();
    }

    @Override
    public Transformer newTransformer() {
        return new IdentityTransformer(this.a.getUnderlyingConfiguration());
    }

    @Override
    public synchronized Templates newTemplates(Source object) {
        try {
            XsltCompiler xsltCompiler = this.a.newXsltCompiler();
            object = xsltCompiler.compile((Source)object);
            return new TemplatesImpl((XsltExecutable)object);
        }
        catch (SaxonApiException saxonApiException) {
            throw new TransformerConfigurationException(saxonApiException);
        }
    }

    public synchronized Templates newTemplates(Source source, CompilerInfo compilerInfo) {
        try {
            XsltCompiler xsltCompiler = this.a.newXsltCompiler();
            xsltCompiler.getUnderlyingCompilerInfo().copyFrom(compilerInfo);
            return new TemplatesImpl(xsltCompiler.compile(source));
        }
        catch (SaxonApiException saxonApiException) {
            throw new TransformerConfigurationException(saxonApiException);
        }
    }

    @Override
    public Source getAssociatedStylesheet(Source source, String string, String string2, String string3) {
        try {
            XsltCompiler xsltCompiler = this.a.newXsltCompiler();
            return xsltCompiler.getAssociatedStylesheet(source, string, string2, string3);
        }
        catch (SaxonApiException saxonApiException) {
            throw new TransformerConfigurationException(saxonApiException);
        }
    }

    @Override
    public void setURIResolver(URIResolver uRIResolver) {
        this.getConfiguration().setURIResolver(uRIResolver);
    }

    @Override
    public URIResolver getURIResolver() {
        return this.getConfiguration().getURIResolver();
    }

    @Override
    public boolean getFeature(String object) {
        switch (object) {
            case "http://javax.xml.transform.sax.SAXSource/feature": 
            case "http://javax.xml.transform.sax.SAXResult/feature": 
            case "http://javax.xml.transform.dom.DOMSource/feature": 
            case "http://javax.xml.transform.dom.DOMResult/feature": 
            case "http://javax.xml.transform.stream.StreamSource/feature": 
            case "http://javax.xml.transform.stream.StreamResult/feature": 
            case "http://javax.xml.transform.sax.SAXTransformerFactory/feature": 
            case "http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter": {
                return true;
            }
            case "http://javax.xml.XMLConstants/feature/secure-processing": {
                return !this.getConfiguration().getBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS);
            }
        }
        try {
            object = this.getConfiguration().getConfigurationProperty((String)object);
            return object instanceof Boolean && (Boolean)object != false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public void setAttribute(String object, Object object2) {
        switch (object) {
            case "http://saxon.sf.net/feature/configuration": {
                this.setConfiguration((Configuration)object2);
                return;
            }
            case "http://saxon.sf.net/feature/configuration-file": {
                object = new ConfigurationReader();
                try {
                    this.setConfiguration(((ConfigurationReader)object).makeConfiguration(new StreamSource(new File((String)object2))));
                    return;
                }
                catch (XPathException xPathException) {
                    throw new IllegalArgumentException(xPathException);
                }
            }
        }
        this.a.getUnderlyingConfiguration().setConfigurationProperty((String)object, object2);
    }

    @Override
    public Object getAttribute(String string) {
        return this.getConfiguration().getConfigurationProperty(string);
    }

    @Override
    public void setErrorListener(ErrorListener errorListener) {
        this.getConfiguration().setErrorListener(errorListener);
    }

    @Override
    public ErrorListener getErrorListener() {
        UnfailingErrorListener unfailingErrorListener = this.getConfiguration().getErrorListener();
        if (unfailingErrorListener instanceof DelegatingErrorListener) {
            return ((DelegatingErrorListener)unfailingErrorListener).getBaseErrorListener();
        }
        return unfailingErrorListener;
    }

    @Override
    public TransformerHandler newTransformerHandler(Source object) {
        object = this.newTemplates((Source)object);
        return this.newTransformerHandler((Templates)object);
    }

    @Override
    public TransformerHandler newTransformerHandler(Templates object) {
        if (!(object instanceof TemplatesImpl)) {
            throw new TransformerConfigurationException("Templates object was not created by Saxon");
        }
        object = (TransformerImpl)object.newTransformer();
        return ((TransformerImpl)object).newTransformerHandler();
    }

    @Override
    public TransformerHandler newTransformerHandler() {
        IdentityTransformer identityTransformer = new IdentityTransformer(this.getConfiguration());
        return new IdentityTransformerHandler(identityTransformer);
    }

    @Override
    public TemplatesHandler newTemplatesHandler() {
        return new TemplatesHandlerImpl(this.a);
    }

    @Override
    public XMLFilter newXMLFilter(Source object) {
        object = this.newTemplates((Source)object);
        return this.newXMLFilter((Templates)object);
    }

    @Override
    public XMLFilter newXMLFilter(Templates object) {
        if (!(object instanceof TemplatesImpl)) {
            throw new TransformerConfigurationException("Supplied Templates object was not created using Saxon");
        }
        object = (a)object.newTransformer();
        return ((a)object).newXMLFilter();
    }

    @Override
    public void setFeature(String string, boolean bl2) {
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            this.getConfiguration().setBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS, !bl2);
            return;
        }
        try {
            this.getConfiguration().setBooleanProperty(string, bl2);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TransformerConfigurationException("Unsupported TransformerFactory feature: " + string);
        }
    }

    public Processor getProcessor() {
        return this.a;
    }
}

