/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.jaxp;

import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.TransformerHandler;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.jaxp.IdentityTransformer;
import net.sf.saxon.jaxp.TransformerImpl;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.tree.tiny.TinyBuilder;
import org.xml.sax.SAXException;

public class TransformerHandlerImpl
extends ReceivingContentHandler
implements TransformerHandler {
    private TransformerImpl a;
    private Builder b;
    private Receiver c;
    private Result d;
    private String e;
    private boolean f = false;

    protected TransformerHandlerImpl(TransformerImpl object) {
        this.a = object;
        XsltController xsltController = ((TransformerImpl)object).getUnderlyingXsltTransformer().getUnderlyingController();
        object = ((IdentityTransformer)object).getConfiguration();
        int n2 = xsltController.getSchemaValidationMode();
        this.b = xsltController.makeBuilder();
        if (this.b instanceof TinyBuilder) {
            ((TinyBuilder)this.b).setStatistics(((Configuration)object).getTreeStatistics().SOURCE_DOCUMENT_STATISTICS);
        }
        PipelineConfiguration pipelineConfiguration = this.b.getPipelineConfiguration();
        ParseOptions parseOptions = pipelineConfiguration.getParseOptions();
        parseOptions.setCheckEntityReferences(true);
        this.setPipelineConfiguration(pipelineConfiguration);
        this.c = xsltController.makeStripper(this.b);
        if (xsltController.isStylesheetStrippingTypeAnnotations()) {
            this.c = ((Configuration)object).getAnnotationStripper(this.c);
        }
        if (n2 != 3) {
            parseOptions.setSchemaValidationMode(n2);
            parseOptions.setSpaceStrippingRule(NoElementsSpaceStrippingRule.getInstance());
            this.c = ((Configuration)object).getDocumentValidator(this.c, this.getSystemId(), parseOptions, null);
        }
        TransformerHandlerImpl transformerHandlerImpl = this;
        transformerHandlerImpl.setReceiver(transformerHandlerImpl.c);
    }

    @Override
    public void startDocument() {
        if (this.f) {
            throw new UnsupportedOperationException("The TransformerHandler is not serially reusable. The startDocument() method must be called once only.");
        }
        this.f = true;
        super.startDocument();
    }

    @Override
    public Transformer getTransformer() {
        return this.a;
    }

    @Override
    public void setSystemId(String string) {
        this.e = string;
        this.c.setSystemId(string);
    }

    @Override
    public String getSystemId() {
        return this.e;
    }

    @Override
    public void setResult(Result result) {
        if (result == null) {
            throw new IllegalArgumentException("Result must not be null");
        }
        this.d = result;
    }

    public Result getResult() {
        return this.d;
    }

    @Override
    public void endDocument() {
        super.endDocument();
        NodeInfo nodeInfo = this.b.getCurrentRoot();
        nodeInfo.getTreeInfo().setSpaceStrippingRule(this.a.getUnderlyingXsltTransformer().getUnderlyingController().getSpaceStrippingRule());
        this.b.reset();
        if (nodeInfo == null) {
            throw new SAXException("No source document has been built");
        }
        try {
            ((IdentityTransformer)this.a).transform(nodeInfo, this.d);
            return;
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }
}

