/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.jaxp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.jaxp.IdentityTransformer;
import net.sf.saxon.jaxp.ReceivingDestination;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.DOMDestination;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SAXDestination;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.UntypedAtomicValue;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.XMLFilter;

abstract class a
extends IdentityTransformer {
    private XsltExecutable a;
    private Map<String, Object> b = new HashMap<String, Object>(8);

    protected a(XsltExecutable xsltExecutable) {
        super(xsltExecutable.getProcessor().getUnderlyingConfiguration());
        this.a = xsltExecutable;
    }

    /*
     * WARNING - void declaration
     */
    protected Destination makeDestination(Result object) {
        if (object instanceof StreamResult) {
            Serializable serializable;
            StreamResult object22 = (StreamResult)object;
            if (object22.getOutputStream() != null) {
                object = this.a.getProcessor().newSerializer(object22.getOutputStream());
            } else if (object22.getWriter() != null) {
                object = this.a.getProcessor().newSerializer(object22.getWriter());
            } else if (object22.getSystemId() != null) {
                FileOutputStream fileOutputStream;
                try {
                    serializable = new URI(object22.getSystemId());
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new XPathException("System ID in Result object is not a valid URI: " + object22.getSystemId(), uRISyntaxException);
                }
                if (!((URI)serializable).isAbsolute()) {
                    try {
                        serializable = new File(object22.getSystemId()).getAbsoluteFile().toURI();
                    }
                    catch (Exception exception) {}
                }
                File file = new File((URI)serializable);
                try {
                    if ("file".equals(((URI)serializable).getScheme()) && !file.exists()) {
                        File iOException = file.getParentFile();
                        if (iOException != null && !iOException.exists()) {
                            iOException.mkdirs();
                        }
                        file.createNewFile();
                    }
                }
                catch (IOException iOException) {
                    throw new XPathException("Failed to create output file " + serializable, iOException);
                }
                try {
                    fileOutputStream = new FileOutputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new XPathException("Failed to create output file", fileNotFoundException);
                }
                object = this.a.getProcessor().newSerializer(fileOutputStream);
                ((Serializer)object).setCloseOnCompletion(true);
            } else {
                throw new IllegalArgumentException("StreamResult supplies neither an OutputStream nor a Writer");
            }
            serializable = this.getLocalOutputProperties();
            for (String string : ((Properties)serializable).stringPropertyNames()) {
                QName qName = QName.fromClarkName(string);
                if (qName.getNamespaceURI().equals("http://saxon.sf.net/") && qName.getLocalName().equals("next-in-chain")) continue;
                ((Serializer)object).setOutputProperty(QName.fromClarkName(string), ((Properties)serializable).getProperty(string));
            }
        } else if (object instanceof SAXResult) {
            object = new SAXDestination(((SAXResult)object).getHandler());
        } else if (object instanceof DOMResult) {
            void var2_12;
            Node node = ((DOMResult)object).getNode();
            if (node == null) {
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setNamespaceAware(true);
                    Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
                    ((DOMResult)object).setNode(document);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new XPathException(parserConfigurationException);
                }
            }
            object = new DOMDestination((Node)var2_12);
        } else if (object instanceof Receiver) {
            object = new ReceivingDestination((Receiver)object);
        } else {
            return null;
        }
        return object;
    }

    @Override
    public void setParameter(String object, Object sequence) {
        if (object == null) {
            throw new NullPointerException("Transformer.setParameter() - name is null");
        }
        if (sequence == null) {
            throw new NullPointerException("Transformer.setParameter() - value is null");
        }
        this.b.put((String)object, sequence);
        object = QName.fromClarkName((String)object);
        Object object2 = this.a.getGlobalParameters().get(object);
        if (object2 == null) {
            return;
        }
        Configuration configuration = this.getConfiguration();
        object2 = ((XsltExecutable.ParameterDetails)object2).getUnderlyingDeclaredType();
        try {
            Object object3;
            if (sequence instanceof Sequence) {
                sequence = sequence;
            } else if (sequence instanceof String) {
                sequence = new UntypedAtomicValue((String)((Object)sequence));
            } else if (((SequenceType)object2).getPrimaryType() instanceof JavaExternalObjectType) {
                sequence = new ObjectValue(sequence);
            } else {
                object3 = JPConverter.allocate(sequence.getClass(), null, configuration);
                XPathContextMajor xPathContextMajor = this.getUnderlyingController().newXPathContext();
                sequence = ((JPConverter)object3).convert(sequence, xPathContextMajor);
            }
            if (sequence == null) {
                sequence = EmptySequence.getInstance();
            }
            if (object2 != null && !((SequenceType)object2).matches(sequence, configuration.getTypeHierarchy())) {
                object3 = new RoleDiagnostic(3, ((QName)object).toString(), -1);
                sequence = configuration.getTypeHierarchy().applyFunctionConversionRules(sequence, (SequenceType)object2, (RoleDiagnostic)object3, ExplicitLocation.UNKNOWN_LOCATION);
            }
        }
        catch (XPathException xPathException) {
            throw new IllegalArgumentException(xPathException);
        }
        this.setConvertedParameter((QName)object, XdmValue.wrap(sequence));
    }

    protected abstract void setConvertedParameter(QName var1, XdmValue var2);

    @Override
    public Object getParameter(String string) {
        return this.b.get(string);
    }

    @Override
    public void clearParameters() {
        this.b.clear();
    }

    @Override
    protected Properties getStylesheetOutputProperties() {
        return this.a.getUnderlyingCompiledStylesheet().getPrimarySerializationProperties().getProperties();
    }

    public XsltExecutable getUnderlyingXsltExecutable() {
        return this.a;
    }

    public abstract Controller getUnderlyingController();

    public abstract XMLFilter newXMLFilter();
}

