/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import net.sf.saxon.expr.sort.LRUCache;
import net.sf.saxon.lib.URIChecker;
import net.sf.saxon.om.NotationSet;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.StringToDouble11;

public class ConversionRules {
    private StringToDouble a = StringToDouble11.getInstance();
    private NotationSet b;
    private URIChecker c;
    private boolean d = true;
    private TypeHierarchy e;
    private LRUCache<Integer, Converter> f = new LRUCache(100, true);
    public static final ConversionRules DEFAULT = new ConversionRules();

    public ConversionRules copy() {
        ConversionRules conversionRules = new ConversionRules();
        this.copyTo(conversionRules);
        return conversionRules;
    }

    public void copyTo(ConversionRules conversionRules) {
        conversionRules.a = this.a;
        conversionRules.b = this.b;
        conversionRules.c = this.c;
        conversionRules.d = this.d;
        conversionRules.e = this.e;
        conversionRules.f.clear();
    }

    public void setTypeHierarchy(TypeHierarchy typeHierarchy) {
        this.e = typeHierarchy;
    }

    public void setStringToDoubleConverter(StringToDouble stringToDouble) {
        this.a = stringToDouble;
    }

    public StringToDouble getStringToDoubleConverter() {
        return this.a;
    }

    public void setNotationSet(NotationSet notationSet) {
        this.b = notationSet;
    }

    public boolean isDeclaredNotation(String string, String string2) {
        if (this.b == null) {
            return true;
        }
        return this.b.isDeclaredNotation(string, string2);
    }

    public void setURIChecker(URIChecker uRIChecker) {
        this.c = uRIChecker;
    }

    public boolean isValidURI(CharSequence charSequence) {
        return this.c == null || this.c.isValidURI(charSequence);
    }

    public void setAllowYearZero(boolean bl2) {
        this.d = bl2;
    }

    public boolean isAllowYearZero() {
        return this.d;
    }

    public Converter getConverter(AtomicType atomicType, AtomicType atomicType2) {
        if (atomicType == atomicType2) {
            return Converter.IdentityConverter.INSTANCE;
        }
        if (atomicType == BuiltInAtomicType.STRING || atomicType == BuiltInAtomicType.UNTYPED_ATOMIC) {
            return atomicType2.getStringConverter(this);
        }
        if (atomicType2 == BuiltInAtomicType.STRING) {
            return Converter.ToStringConverter.INSTANCE;
        }
        if (atomicType2 == BuiltInAtomicType.UNTYPED_ATOMIC) {
            return Converter.ToUntypedAtomicConverter.INSTANCE;
        }
        int n2 = atomicType.getPrimitiveType() << 20 | atomicType2.getFingerprint();
        Converter converter = this.f.get(n2);
        if (converter == null) {
            converter = this.a(atomicType, atomicType2);
            if (converter != null) {
                this.f.put(n2, converter);
            } else {
                return null;
            }
        }
        return converter;
    }

    private Converter a(AtomicType object, AtomicType object2) {
        if (object == object2) {
            return Converter.IdentityConverter.INSTANCE;
        }
        int n2 = object2.getFingerprint();
        int n3 = object2.getPrimitiveType();
        int n4 = object.getPrimitiveType();
        if (!(n4 != 513 && n4 != 631 || n3 != 513 && n3 != 631)) {
            return this.a((AtomicType)object2);
        }
        if (!object2.isPrimitiveType()) {
            AtomicType atomicType = object2.getPrimitiveItemType();
            if (object == atomicType) {
                return new Converter.DownCastingConverter((AtomicType)object2, this);
            }
            if (n4 == 513 || n4 == 631) {
                return this.a((AtomicType)object2);
            }
            if ((object = this.a((AtomicType)object, atomicType)) == null) {
                return null;
            }
            object2 = new Converter.DownCastingConverter((AtomicType)object2, this);
            return new Converter.TwoPhaseConverter((Converter)object, (Converter)object2);
        }
        if (n4 == n2) {
            if (this.e != null && this.e.isSubType((ItemType)object, (ItemType)object2)) {
                return new Converter.UpCastingConverter((AtomicType)object2);
            }
            Converter.UpCastingConverter upCastingConverter = new Converter.UpCastingConverter(object.getPrimitiveItemType());
            object = new Converter.DownCastingConverter((AtomicType)object2, this);
            return new Converter.TwoPhaseConverter(upCastingConverter, (Converter)object);
        }
        switch (n2) {
            case 631: {
                return Converter.ToUntypedAtomicConverter.INSTANCE;
            }
            case 513: {
                return Converter.ToStringConverter.INSTANCE;
            }
            case 516: {
                switch (n4) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToFloat(this);
                    }
                    case 515: 
                    case 517: 
                    case 533: 
                    case 635: {
                        return Converter.NumericToFloat.INSTANCE;
                    }
                    case 514: {
                        return Converter.BooleanToFloat.INSTANCE;
                    }
                }
                return null;
            }
            case 517: 
            case 635: {
                switch (n4) {
                    case 513: 
                    case 631: {
                        return this.a;
                    }
                    case 515: 
                    case 516: 
                    case 533: 
                    case 635: {
                        return Converter.NumericToDouble.INSTANCE;
                    }
                    case 514: {
                        return Converter.BooleanToDouble.INSTANCE;
                    }
                }
                return null;
            }
            case 515: {
                switch (n4) {
                    case 513: 
                    case 631: {
                        return StringConverter.StringToDecimal.INSTANCE;
                    }
                    case 516: {
                        return Converter.FloatToDecimal.INSTANCE;
                    }
                    case 517: {
                        return Converter.DoubleToDecimal.INSTANCE;
                    }
                    case 533: {
                        return Converter.IntegerToDecimal.INSTANCE;
                    }
                    case 635: {
                        return Converter.NumericToDecimal.INSTANCE;
                    }
                    case 514: {
                        return Converter.BooleanToDecimal.INSTANCE;
                    }
                }
                return null;
            }
            case 533: {
                switch (n4) {
                    case 513: 
                    case 631: {
                        return StringConverter.StringToInteger.INSTANCE;
                    }
                    case 516: {
                        return Converter.FloatToInteger.INSTANCE;
                    }
                    case 517: {
                        return Converter.DoubleToInteger.INSTANCE;
                    }
                    case 515: {
                        return Converter.DecimalToInteger.INSTANCE;
                    }
                    case 635: {
                        return Converter.NumericToInteger.INSTANCE;
                    }
                    case 514: {
                        return Converter.BooleanToInteger.INSTANCE;
                    }
                }
                return null;
            }
            case 518: {
                switch (n4) {
                    case 513: 
                    case 631: {
                        return StringConverter.StringToDuration.INSTANCE;
                    }
                    case 633: 
                    case 634: {
                        return new Converter.UpCastingConverter(BuiltInAtomicType.DURATION);
                    }
                }
                return null;
            }
            case 633: {
                switch (n4) {
                    case 513: 
                    case 631: {
                        return StringConverter.StringToYearMonthDuration.INSTANCE;
                    }
                    case 518: 
                    case 634: {
                        return Converter.DurationToYearMonthDuration.INSTANCE;
                    }
                }
                return null;
            }
            case 634: {
                switch (n4) {
                    case 513: 
                    case 631: {
                        return StringConverter.StringToDayTimeDuration.INSTANCE;
                    }
                    case 518: 
                    case 633: {
                        return Converter.DurationToDayTimeDuration.INSTANCE;
                    }
                }
                return null;
            }
            case 519: {
                switch (n4) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToDateTime(this);
                    }
                    case 521: {
                        return Converter.DateToDateTime.INSTANCE;
                    }
                }
                return null;
            }
            case 520: {
                switch (n4) {
                    case 513: 
                    case 631: {
                        return StringConverter.StringToTime.INSTANCE;
                    }
                    case 519: {
                        return Converter.DateTimeToTime.INSTANCE;
                    }
                }
                return null;
            }
            case 521: {
                switch (n4) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToDate(this);
                    }
                    case 519: {
                        return Converter.DateTimeToDate.INSTANCE;
                    }
                }
                return null;
            }
            case 522: {
                switch (n4) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToGYearMonth(this);
                    }
                    case 521: {
                        return Converter.TwoPhaseConverter.makeTwoPhaseConverter(BuiltInAtomicType.DATE, BuiltInAtomicType.DATE_TIME, BuiltInAtomicType.G_YEAR_MONTH, this);
                    }
                    case 519: {
                        return Converter.DateTimeToGYearMonth.INSTANCE;
                    }
                }
                return null;
            }
            case 523: {
                switch (n4) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToGYear(this);
                    }
                    case 521: {
                        return Converter.TwoPhaseConverter.makeTwoPhaseConverter(BuiltInAtomicType.DATE, BuiltInAtomicType.DATE_TIME, BuiltInAtomicType.G_YEAR, this);
                    }
                    case 519: {
                        return Converter.DateTimeToGYear.INSTANCE;
                    }
                }
                return null;
            }
            case 524: {
                switch (n4) {
                    case 513: 
                    case 631: {
                        return StringConverter.StringToGMonthDay.INSTANCE;
                    }
                    case 521: {
                        return Converter.TwoPhaseConverter.makeTwoPhaseConverter(BuiltInAtomicType.DATE, BuiltInAtomicType.DATE_TIME, BuiltInAtomicType.G_MONTH_DAY, this);
                    }
                    case 519: {
                        return Converter.DateTimeToGMonthDay.INSTANCE;
                    }
                }
                return null;
            }
            case 525: {
                switch (n4) {
                    case 513: 
                    case 631: {
                        return StringConverter.StringToGDay.INSTANCE;
                    }
                    case 521: {
                        return Converter.TwoPhaseConverter.makeTwoPhaseConverter(BuiltInAtomicType.DATE, BuiltInAtomicType.DATE_TIME, BuiltInAtomicType.G_DAY, this);
                    }
                    case 519: {
                        return Converter.DateTimeToGDay.INSTANCE;
                    }
                }
                return null;
            }
            case 526: {
                switch (n4) {
                    case 513: 
                    case 631: {
                        return StringConverter.StringToGMonth.INSTANCE;
                    }
                    case 521: {
                        return Converter.TwoPhaseConverter.makeTwoPhaseConverter(BuiltInAtomicType.DATE, BuiltInAtomicType.DATE_TIME, BuiltInAtomicType.G_MONTH, this);
                    }
                    case 519: {
                        return Converter.DateTimeToGMonth.INSTANCE;
                    }
                }
                return null;
            }
            case 514: {
                switch (n4) {
                    case 513: 
                    case 631: {
                        return StringConverter.StringToBoolean.INSTANCE;
                    }
                    case 515: 
                    case 516: 
                    case 517: 
                    case 533: 
                    case 635: {
                        return Converter.NumericToBoolean.INSTANCE;
                    }
                }
                return null;
            }
            case 528: {
                switch (n4) {
                    case 513: 
                    case 631: {
                        return StringConverter.StringToBase64Binary.INSTANCE;
                    }
                    case 527: {
                        return Converter.HexBinaryToBase64Binary.INSTANCE;
                    }
                }
                return null;
            }
            case 527: {
                switch (n4) {
                    case 513: 
                    case 631: {
                        return StringConverter.StringToHexBinary.INSTANCE;
                    }
                    case 528: {
                        return Converter.Base64BinaryToHexBinary.INSTANCE;
                    }
                }
                return null;
            }
            case 529: {
                switch (n4) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToAnyURI(this);
                    }
                }
                return null;
            }
            case 530: {
                switch (n4) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToQName(this);
                    }
                    case 531: {
                        return Converter.NotationToQName.INSTANCE;
                    }
                }
                return null;
            }
            case 531: {
                switch (n4) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToNotation(this);
                    }
                    case 530: {
                        return Converter.QNameToNotation.INSTANCE;
                    }
                }
                return null;
            }
            case 632: {
                return Converter.IdentityConverter.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Unknown primitive type " + n2);
    }

    private StringConverter a(AtomicType object) {
        int n2 = object.getPrimitiveType();
        if (object.isBuiltInType()) {
            if (n2 == 513) {
                switch (object.getFingerprint()) {
                    case 513: {
                        return StringConverter.StringToString.INSTANCE;
                    }
                    case 553: {
                        return StringConverter.StringToNormalizedString.INSTANCE;
                    }
                    case 554: {
                        return StringConverter.StringToToken.INSTANCE;
                    }
                    case 555: {
                        return StringConverter.StringToLanguage.INSTANCE;
                    }
                    case 558: {
                        return StringConverter.StringToName.INSTANCE;
                    }
                    case 559: {
                        return StringConverter.StringToNCName.TO_NCNAME;
                    }
                    case 560: {
                        return StringConverter.StringToNCName.TO_ID;
                    }
                    case 561: {
                        return StringConverter.StringToNCName.TO_IDREF;
                    }
                    case 563: {
                        return StringConverter.StringToNCName.TO_ENTITY;
                    }
                    case 556: {
                        return StringConverter.StringToNMTOKEN.INSTANCE;
                    }
                }
                throw new AssertionError((Object)"Unknown built-in subtype of xs:string");
            }
            if (n2 == 631) {
                return StringConverter.StringToUntypedAtomic.INSTANCE;
            }
            if (object.isPrimitiveType()) {
                Converter converter = this.getConverter(BuiltInAtomicType.STRING, (AtomicType)object);
                assert (converter != null);
                return (StringConverter)converter;
            }
            if (n2 == 533) {
                return new StringConverter.StringToIntegerSubtype((BuiltInAtomicType)object);
            }
            switch (object.getFingerprint()) {
                case 634: {
                    return StringConverter.StringToDayTimeDuration.INSTANCE;
                }
                case 633: {
                    return StringConverter.StringToYearMonthDuration.INSTANCE;
                }
                case 565: {
                    StringConverter.StringToDateTime stringToDateTime = new StringConverter.StringToDateTime(this);
                    object = new Converter.DownCastingConverter((AtomicType)object, this);
                    return new StringConverter.StringToNonStringDerivedType(stringToDateTime, (Converter.DownCastingConverter)object);
                }
            }
            throw new AssertionError((Object)("Unknown built in type " + object));
        }
        if (n2 == 513) {
            if (object.getBuiltInBaseType() == BuiltInAtomicType.STRING) {
                return new StringConverter.StringToStringSubtype(this, (AtomicType)object);
            }
            return new StringConverter.StringToDerivedStringSubtype(this, (AtomicType)object);
        }
        StringConverter stringConverter = object.getPrimitiveItemType().getStringConverter(this);
        object = new Converter.DownCastingConverter((AtomicType)object, this);
        return new StringConverter.StringToNonStringDerivedType(stringConverter, (Converter.DownCastingConverter)object);
    }
}

