/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.math.BigDecimal;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.NumericValue;

public class SaxonOutputKeys {
    public static final String SAXON_XQUERY_METHOD = "{http://saxon.sf.net/}xquery";
    public static final String SAXON_BASE64_BINARY_METHOD = "{http://saxon.sf.net/}base64Binary";
    public static final String SAXON_HEX_BINARY_METHOD = "{http://saxon.sf.net/}hexBinary";
    public static final String SAXON_PTREE_METHOD = "{http://saxon.sf.net/}ptree";
    public static final String ALLOW_DUPLICATE_NAMES = "allow-duplicate-names";
    public static final String BUILD_TREE = "build-tree";
    public static final String INDENT_SPACES = "{http://saxon.sf.net/}indent-spaces";
    public static final String LINE_LENGTH = "{http://saxon.sf.net/}line-length";
    public static final String SINGLE_QUOTES = "{http://saxon.sf.net/}single-quotes";
    public static final String SUPPRESS_INDENTATION = "suppress-indentation";
    public static final String HTML_VERSION = "html-version";
    public static final String ITEM_SEPARATOR = "item-separator";
    public static final String JSON_NODE_OUTPUT_METHOD = "json-node-output-method";
    public static final String ATTRIBUTE_ORDER = "{http://saxon.sf.net/}attribute-order";
    public static final String CANONICAL = "{http://saxon.sf.net/}canonical";
    public static final String PROPERTY_ORDER = "{http://saxon.sf.net/}property-order";
    public static final String DOUBLE_SPACE = "{http://saxon.sf.net/}double-space";
    public static final String NEWLINE = "{http://saxon.sf.net/}newline";
    public static final String STYLESHEET_VERSION = "{http://saxon.sf.net/}stylesheet-version";
    public static final String USE_CHARACTER_MAPS = "use-character-maps";
    public static final String INCLUDE_CONTENT_TYPE = "include-content-type";
    public static final String UNDECLARE_PREFIXES = "undeclare-prefixes";
    public static final String ESCAPE_URI_ATTRIBUTES = "escape-uri-attributes";
    public static final String CHARACTER_REPRESENTATION = "{http://saxon.sf.net/}character-representation";
    public static final String NEXT_IN_CHAIN = "{http://saxon.sf.net/}next-in-chain";
    public static final String NEXT_IN_CHAIN_BASE_URI = "{http://saxon.sf.net/}next-in-chain-base-uri";
    public static final String PARAMETER_DOCUMENT = "parameter-document";
    public static final String PARAMETER_DOCUMENT_BASE_URI = "{http://saxon.sf.net/}parameter-document-base-uri";
    public static final String BYTE_ORDER_MARK = "byte-order-mark";
    public static final String NORMALIZATION_FORM = "normalization-form";
    public static final String RECOGNIZE_BINARY = "{http://saxon.sf.net/}recognize-binary";
    public static final String REQUIRE_WELL_FORMED = "{http://saxon.sf.net/}require-well-formed";
    public static final String SUPPLY_SOURCE_LOCATOR = "{http://saxon.sf.net/}supply-source-locator";
    public static final String WRAP = "{http://saxon.sf.net/}wrap-result-sequence";
    public static final String IMPLICIT_RESULT_DOCUMENT = "{http://saxon.sf.net/}implicit-result-document";
    public static final String UNFAILING = "{http://saxon.sf.net/}unfailing";

    private SaxonOutputKeys() {
    }

    public static String parseListOfNodeNames(String object, NamespaceResolver namespaceResolver, boolean bl2, boolean bl3, boolean bl4, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        object = new StringTokenizer((String)object, " \t\n\r", false);
        while (((StringTokenizer)object).hasMoreTokens()) {
            String[] stringArray = ((StringTokenizer)object).nextToken();
            if (bl4 && "*".equals(stringArray)) {
                stringBuilder.append(' ').append((String)stringArray);
                continue;
            }
            if (bl3 || namespaceResolver == null) {
                stringBuilder.append(' ').append((String)stringArray);
                continue;
            }
            if (stringArray.startsWith("Q{")) {
                stringBuilder.append(' ').append(stringArray.substring(1));
                continue;
            }
            try {
                stringArray = NameChecker.getQNameParts((CharSequence)stringArray);
                String string2 = namespaceResolver.getURIForPrefix(stringArray[0], bl2);
                if (string2 == null) {
                    throw new XPathException("Namespace prefix '" + stringArray[0] + "' has not been declared", string);
                }
                stringBuilder.append(" {").append(string2).append('}').append(stringArray[1]);
            }
            catch (QNameException qNameException) {
                throw new XPathException("Invalid QName. " + qNameException.getMessage(), string);
            }
        }
        return stringBuilder.toString();
    }

    public static boolean isUnstrippedProperty(String string) {
        return ITEM_SEPARATOR.equals(string) || NEWLINE.equals(string);
    }

    public static boolean isXhtmlHtmlVersion5(Properties object) {
        object = ((Properties)object).getProperty(HTML_VERSION);
        try {
            return object != null && ((NumericValue)((BigDecimalValue)BigDecimalValue.makeDecimalValue((CharSequence)object, false).asAtomic())).getDecimalValue().equals(BigDecimal.valueOf(5L));
        }
        catch (ValidationException validationException) {
            return false;
        }
    }

    public static boolean isHtmlVersion5(Properties properties) {
        String string = properties.getProperty(HTML_VERSION);
        if (string == null) {
            string = properties.getProperty("version");
        }
        if (string != null) {
            try {
                return ((NumericValue)((BigDecimalValue)BigDecimalValue.makeDecimalValue(string, false).asAtomic())).getDecimalValue().equals(BigDecimal.valueOf(5L));
            }
            catch (ValidationException validationException) {
                return false;
            }
        }
        return false;
    }

    public static boolean isBuildTree(Properties object) {
        String string = ((Properties)object).getProperty(BUILD_TREE);
        if (string != null) {
            return "yes".equals(string);
        }
        return !"json".equals(object = ((Properties)object).getProperty("method")) && !"adaptive".equals(object);
    }

    static {
        Pattern.compile("^[\\s\\r\\na-zA-Z0-9\\-'()+,./:=?;!*#@$_%]*$");
    }
}

