/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.Writer;
import java.util.Comparator;
import java.util.Objects;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceNormalizerWithItemSeparator;
import net.sf.saxon.event.SequenceNormalizerWithSpaceSeparator;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.Sink;
import net.sf.saxon.event.StreamWriterToReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SaxonOutputKeys;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.query.SequenceWrapper;
import net.sf.saxon.serialize.AdaptiveEmitter;
import net.sf.saxon.serialize.CDATAFilter;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.CharacterMapExpander;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.serialize.Emitter;
import net.sf.saxon.serialize.ExpandedStreamResult;
import net.sf.saxon.serialize.HTML40Emitter;
import net.sf.saxon.serialize.HTML50Emitter;
import net.sf.saxon.serialize.HTMLIndenter;
import net.sf.saxon.serialize.HTMLURIEscaper;
import net.sf.saxon.serialize.JSONEmitter;
import net.sf.saxon.serialize.JSONSerializer;
import net.sf.saxon.serialize.MetaTagAdjuster;
import net.sf.saxon.serialize.SerializationParamsHandler;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.serialize.TEXTEmitter;
import net.sf.saxon.serialize.UncommittedSerializer;
import net.sf.saxon.serialize.UnicodeNormalizer;
import net.sf.saxon.serialize.XHTML1Emitter;
import net.sf.saxon.serialize.XHTML5Emitter;
import net.sf.saxon.serialize.XHTMLPrefixRemover;
import net.sf.saxon.serialize.XHTMLURIEscaper;
import net.sf.saxon.serialize.XML10ContentChecker;
import net.sf.saxon.serialize.XMLEmitter;
import net.sf.saxon.serialize.XMLIndenter;
import net.sf.saxon.stax.StAXResultHandlerImpl;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;

public class SerializerFactory {
    private Configuration a;
    private PipelineConfiguration b;
    private static Pattern c = Pattern.compile("^[\\s\\r\\na-zA-Z0-9\\-'()+,./:=?;!*#@$_%]*$");

    public SerializerFactory(Configuration configuration) {
        this.a = configuration;
    }

    public SerializerFactory(PipelineConfiguration pipelineConfiguration) {
        this.b = pipelineConfiguration;
        this.a = pipelineConfiguration.getConfiguration();
    }

    public Configuration getConfiguration() {
        return this.a;
    }

    public StreamWriterToReceiver getXMLStreamWriter(StreamResult result, Properties properties) {
        result = this.getReceiver(result, new SerializationProperties(properties));
        result = new NamespaceReducer((Receiver)result);
        return new StreamWriterToReceiver((Receiver)result);
    }

    public Receiver getReceiver(Result result, PipelineConfiguration pipelineConfiguration, Properties properties) {
        return this.getReceiver(result, new SerializationProperties(properties), pipelineConfiguration);
    }

    public Receiver getReceiver(Result result) {
        return this.getReceiver(result, new SerializationProperties(), this.a.makePipelineConfiguration());
    }

    public Receiver getReceiver(Result result, SerializationProperties serializationProperties) {
        return this.getReceiver(result, serializationProperties, this.a.makePipelineConfiguration());
    }

    public Receiver getReceiver(Result object, SerializationProperties object2, PipelineConfiguration object3) {
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Objects.requireNonNull(object);
        Objects.requireNonNull(object2);
        Objects.requireNonNull(object3);
        Object object8 = ((SerializationProperties)object2).getProperties();
        Object object9 = ((SerializationProperties)object2).getCharacterMapIndex();
        if (object9 == null) {
            object9 = new CharacterMapIndex();
        }
        if ((object7 = ((Properties)object8).getProperty("{http://saxon.sf.net/}next-in-chain")) != null && !((String)object7).isEmpty()) {
            object7 = ((Properties)object8).getProperty("{http://saxon.sf.net/}next-in-chain");
            object2 = ((Properties)object8).getProperty("{http://saxon.sf.net/}next-in-chain-base-uri");
            if (object2 == null) {
                object2 = "";
            }
            Properties properties = new Properties((Properties)object8);
            properties.setProperty("{http://saxon.sf.net/}next-in-chain", "");
            return this.prepareNextStylesheet((PipelineConfiguration)object3, (String)object7, (String)object2, (Result)object);
        }
        object7 = ((Properties)object8).getProperty("parameter-document");
        if (object7 != null && !((String)object7).isEmpty()) {
            object2 = ((Properties)object8).getProperty("{http://saxon.sf.net/}parameter-document-base-uri");
            if (object2 == null) {
                object2 = object.getSystemId();
            }
            object6 = new Properties((Properties)object8);
            ((Properties)object6).setProperty("parameter-document", "");
            try {
                object7 = this.a.getURIResolver().resolve((String)object7, (String)object2);
            }
            catch (TransformerException transformerException) {
                TransformerException transformerException2 = transformerException;
                throw XPathException.makeXPathException(transformerException);
            }
            object5 = new ParseOptions();
            ((ParseOptions)object5).setSchemaValidationMode(2);
            Object object10 = this.a.buildDocumentTree((Source)object7);
            object5 = new SerializationParamsHandler();
            ((SerializationParamsHandler)object5).setSerializationParams(object10.getRootNode());
            object10 = ((SerializationParamsHandler)object5).getSerializationProperties().getProperties();
            object2 = ((Properties)object10).propertyNames();
            while (object2.hasMoreElements()) {
                object7 = (String)object2.nextElement();
                object4 = ((Properties)object10).getProperty((String)object7);
                ((Properties)object6).setProperty((String)object7, (String)object4);
            }
            object7 = ((SerializationParamsHandler)object5).getCharacterMap();
            if (object7 != null) {
                ((Properties)object6).setProperty("use-character-maps", ((CharacterMap)object7).getName().getClarkName());
                ((CharacterMapIndex)object9).putCharacterMap(((CharacterMap)object7).getName(), (CharacterMap)object7);
            }
            object8 = object6;
            object2 = new SerializationProperties((Properties)object6, (CharacterMapIndex)object9);
        }
        if (object instanceof StreamResult) {
            object6 = ((Properties)object8).getProperty("method");
            if (object6 == null) {
                return this.newUncommittedSerializer((Result)object, new Sink((PipelineConfiguration)object3), (SerializationProperties)object2);
            }
            object7 = null;
            switch (object6) {
                case "html": {
                    object7 = this.newHTMLEmitter((Properties)object8);
                    ((SequenceReceiver)object7).setPipelineConfiguration((PipelineConfiguration)object3);
                    object2 = this.createHTMLSerializer((Emitter)object7, (SerializationProperties)object2, (PipelineConfiguration)object3);
                    break;
                }
                case "xml": {
                    object7 = this.newXMLEmitter((Properties)object8);
                    ((SequenceReceiver)object7).setPipelineConfiguration((PipelineConfiguration)object3);
                    object2 = this.createXMLSerializer((XMLEmitter)object7, (SerializationProperties)object2);
                    break;
                }
                case "xhtml": {
                    object7 = this.newXHTMLEmitter((Properties)object8);
                    ((SequenceReceiver)object7).setPipelineConfiguration((PipelineConfiguration)object3);
                    object2 = this.createXHTMLSerializer((Emitter)object7, (SerializationProperties)object2, (PipelineConfiguration)object3);
                    break;
                }
                case "text": {
                    object7 = this.newTEXTEmitter();
                    ((SequenceReceiver)object7).setPipelineConfiguration((PipelineConfiguration)object3);
                    object2 = this.createTextSerializer((Emitter)object7, (SerializationProperties)object2);
                    break;
                }
                case "json": {
                    object5 = (StreamResult)object;
                    ((Properties)object8).setProperty("omit-xml-declaration", "yes");
                    JSONEmitter jSONEmitter = new JSONEmitter((PipelineConfiguration)object3, (StreamResult)object5, (Properties)object8);
                    object2 = new JSONSerializer((PipelineConfiguration)object3, jSONEmitter, (Properties)object8);
                    object7 = ((Properties)object8).getProperty("{http://saxon.sf.net/}property-order");
                    if (object7 != null) {
                        ((JSONSerializer)object2).setPropertySorter(this.getPropertySorter((String)object7));
                    }
                    object4 = this.a((PipelineConfiguration)object3, (Properties)object8, (CharacterMapIndex)object9);
                    object = this.a((PipelineConfiguration)object3, (Properties)object8);
                    return this.customizeJSONSerializer((JSONSerializer)object2, (Properties)object8, (CharacterMapExpander)object4, (ProxyReceiver)object);
                }
                case "adaptive": {
                    object5 = new ExpandedStreamResult(((PipelineConfiguration)object3).getConfiguration(), (StreamResult)object, (Properties)object8);
                    Writer writer = ((ExpandedStreamResult)object5).obtainWriter();
                    object2 = new AdaptiveEmitter((PipelineConfiguration)object3, writer);
                    ((AdaptiveEmitter)object2).setOutputProperties((Properties)object8);
                    object7 = this.a((PipelineConfiguration)object3, (Properties)object8, (CharacterMapIndex)object9);
                    object4 = this.a((PipelineConfiguration)object3, (Properties)object8);
                    return this.customizeAdaptiveSerializer((AdaptiveEmitter)object2, (Properties)object8, (CharacterMapExpander)object7, (ProxyReceiver)object4);
                }
                default: {
                    if (((String)object6).startsWith("{http://saxon.sf.net/}")) {
                        ProxyReceiver proxyReceiver;
                        object5 = this.a((PipelineConfiguration)object3, (Properties)object8, (CharacterMapIndex)object9);
                        if (!((object2 = this.createSaxonSerializationMethod((String)object6, (SerializationProperties)object2, (PipelineConfiguration)object3, (CharacterMapExpander)object5, proxyReceiver = this.a((PipelineConfiguration)object3, (Properties)object8), (StreamResult)object)) instanceof Emitter)) break;
                        object7 = (Emitter)object2;
                        break;
                    }
                    if (object3 == null) {
                        throw new XPathException("Unsupported serialization method " + (String)object6);
                    }
                    object5 = this.createUserDefinedOutputMethod((String)object6, (Properties)object8, (PipelineConfiguration)object3);
                    if (object5 instanceof Emitter) {
                        object7 = (Emitter)object5;
                        object2 = ((SerializationProperties)object2).makeSequenceNormalizer((Receiver)object7);
                        break;
                    }
                    return ((SerializationProperties)object2).makeSequenceNormalizer((Receiver)object5);
                }
            }
            if (object7 != null) {
                ((Emitter)object7).setOutputProperties((Properties)object8);
                object5 = (StreamResult)object;
                ((Emitter)object7).setStreamResult((StreamResult)object5);
            }
            ((SequenceReceiver)object2).setSystemId(object.getSystemId());
            return object2;
        }
        Properties properties = object8;
        object8 = object3;
        object3 = properties;
        object2 = object;
        object = this;
        if (object2 instanceof Emitter) {
            if (((Emitter)object2).getOutputProperties() == null) {
                ((Emitter)object2).setOutputProperties((Properties)object3);
            }
            return (Emitter)object2;
        }
        if (object2 instanceof JSONSerializer) {
            if (((JSONSerializer)object2).getOutputProperties() == null) {
                ((JSONSerializer)object2).setOutputProperties((Properties)object3);
            }
            return (JSONSerializer)object2;
        }
        if (object2 instanceof AdaptiveEmitter) {
            if (((AdaptiveEmitter)object2).getOutputProperties() == null) {
                ((AdaptiveEmitter)object2).setOutputProperties((Properties)object3);
            }
            return (AdaptiveEmitter)object2;
        }
        if (object2 instanceof ComplexContentOutputter) {
            return (ComplexContentOutputter)object2;
        }
        if (object2 instanceof Receiver) {
            object9 = (Receiver)object2;
            object9.setSystemId(object2.getSystemId());
            object9.setPipelineConfiguration((PipelineConfiguration)object8);
            if (((Receiver)object2).handlesAppend() && "no".equals(((Properties)object3).getProperty("build-tree"))) {
                return object9;
            }
            return new ComplexContentOutputter((Receiver)object9);
        }
        if (object2 instanceof SAXResult) {
            object9 = ((SerializerFactory)object).newContentHandlerProxy();
            ((ContentHandlerProxy)object9).setUnderlyingContentHandler(((SAXResult)object2).getHandler());
            ((ContentHandlerProxy)object9).setPipelineConfiguration((PipelineConfiguration)object8);
            ((ContentHandlerProxy)object9).setOutputProperties((Properties)object3);
            if ("yes".equals(((Properties)object3).getProperty("{http://saxon.sf.net/}supply-source-locator"))) {
                if (((SerializerFactory)object).a.isCompileWithTracing() && ((PipelineConfiguration)object8).getController() != null) {
                    ((PipelineConfiguration)object8).getController().addTraceListener(((ContentHandlerProxy)object9).getTraceListener());
                } else {
                    throw new XPathException("Cannot use saxon:supply-source-locator unless tracing was enabled at compile time", "SXSE0002");
                }
            }
            return ((SerializerFactory)object).makeSequenceNormalizer((Receiver)object9, (Properties)object3);
        }
        if (object2 instanceof StAXResult) {
            object9 = new StAXResultHandlerImpl();
            object9 = object9.getReceiver((Result)object2, (Properties)object3);
            object9.setPipelineConfiguration((PipelineConfiguration)object8);
            return ((SerializerFactory)object).makeSequenceNormalizer((Receiver)object9, (Properties)object3);
        }
        if (object8 != null) {
            object9 = ((PipelineConfiguration)object8).getConfiguration().getExternalObjectModels();
            object9 = object9.iterator();
            while (object9.hasNext()) {
                object = object9.next();
                object = (ExternalObjectModel)object;
                if ((object = object.getDocumentBuilder((Result)object2)) == null) continue;
                object.setSystemId(object2.getSystemId());
                object.setPipelineConfiguration((PipelineConfiguration)object8);
                return new TreeReceiver((Receiver)object);
            }
        }
        throw new IllegalArgumentException("Unknown type of result: " + object2.getClass());
    }

    private ProxyReceiver a(PipelineConfiguration pipelineConfiguration, Properties properties) {
        String string = properties.getProperty("normalization-form");
        if (string != null && !string.equals("none")) {
            return this.newUnicodeNormalizer(new Sink(pipelineConfiguration), properties);
        }
        return null;
    }

    private CharacterMapExpander a(PipelineConfiguration pipelineConfiguration, Properties object, CharacterMapIndex characterMapIndex) {
        if ((object = ((Properties)object).getProperty("use-character-maps")) != null) {
            return characterMapIndex.makeCharacterMapExpander((String)object, new Sink(pipelineConfiguration), this);
        }
        return null;
    }

    public SequenceReceiver makeSequenceNormalizer(Receiver receiver, Properties object) {
        Object object2 = ((Properties)object).getProperty("method");
        if ("json".equals(object2) || "adaptive".equals(object2)) {
            if (receiver instanceof SequenceReceiver) {
                return (SequenceReceiver)receiver;
            }
            return new TreeReceiver(receiver);
        }
        object2 = receiver.getPipelineConfiguration();
        receiver = (object = ((Properties)object).getProperty("item-separator")) == null || "#absent".equals(object) ? new SequenceNormalizerWithSpaceSeparator(receiver) : new SequenceNormalizerWithItemSeparator(receiver, (String)object);
        ((SequenceReceiver)receiver).setPipelineConfiguration((PipelineConfiguration)object2);
        return receiver;
    }

    protected SequenceReceiver createHTMLSerializer(Emitter receiver, SerializationProperties serializationProperties, PipelineConfiguration object) {
        object = serializationProperties.getProperties();
        if (!"no".equals(((Properties)object).getProperty("indent"))) {
            receiver = this.newHTMLIndenter(receiver, (Properties)object);
        }
        receiver = this.injectUnicodeNormalizer(serializationProperties, receiver);
        receiver = this.injectCharacterMapExpander(serializationProperties, receiver, true);
        String string = ((Properties)object).getProperty("cdata-section-elements");
        if (string != null && !string.isEmpty()) {
            receiver = this.newCDATAFilter(receiver, (Properties)object);
        }
        if (SaxonOutputKeys.isHtmlVersion5((Properties)object)) {
            receiver = this.addHtml5Component(receiver, (Properties)object);
        }
        if (!"no".equals(((Properties)object).getProperty("escape-uri-attributes"))) {
            receiver = this.newHTMLURIEscaper(receiver, (Properties)object);
        }
        if (!"no".equals(((Properties)object).getProperty("include-content-type"))) {
            receiver = this.newHTMLMetaTagAdjuster(receiver, (Properties)object);
        }
        if ((string = ((Properties)object).getProperty("{http://saxon.sf.net/}attribute-order")) != null && !string.isEmpty()) {
            receiver = this.newAttributeSorter(receiver, (Properties)object);
        }
        if (serializationProperties.getValidationFactory() != null) {
            receiver = serializationProperties.getValidationFactory().makeFilter(receiver);
        }
        return this.makeSequenceNormalizer(receiver, (Properties)object);
    }

    protected SequenceReceiver createTextSerializer(Emitter receiver, SerializationProperties serializationProperties) {
        Properties properties = serializationProperties.getProperties();
        receiver = this.injectUnicodeNormalizer(serializationProperties, receiver);
        receiver = this.injectCharacterMapExpander(serializationProperties, receiver, false);
        receiver = this.addTextOutputFilter(receiver, properties);
        if (serializationProperties.getValidationFactory() != null) {
            receiver = serializationProperties.getValidationFactory().makeFilter(receiver);
        }
        return this.makeSequenceNormalizer(receiver, properties);
    }

    protected SequenceReceiver customizeJSONSerializer(JSONSerializer jSONSerializer, Properties properties, CharacterMapExpander characterMapExpander, ProxyReceiver proxyReceiver) {
        if (proxyReceiver instanceof UnicodeNormalizer) {
            jSONSerializer.setNormalizer(((UnicodeNormalizer)proxyReceiver).getNormalizer());
        }
        if (characterMapExpander != null) {
            jSONSerializer.setCharacterMap(characterMapExpander.getCharacterMap());
        }
        return jSONSerializer;
    }

    protected SequenceReceiver customizeAdaptiveSerializer(AdaptiveEmitter adaptiveEmitter, Properties properties, CharacterMapExpander characterMapExpander, ProxyReceiver proxyReceiver) {
        if (proxyReceiver instanceof UnicodeNormalizer) {
            adaptiveEmitter.setNormalizer(((UnicodeNormalizer)proxyReceiver).getNormalizer());
        }
        if (characterMapExpander != null) {
            adaptiveEmitter.setCharacterMap(characterMapExpander.getCharacterMap());
        }
        return adaptiveEmitter;
    }

    protected SequenceReceiver createXHTMLSerializer(Emitter receiver, SerializationProperties serializationProperties, PipelineConfiguration object) {
        object = serializationProperties.getProperties();
        if (!"no".equals(((Properties)object).getProperty("indent"))) {
            receiver = this.newXHTMLIndenter(receiver, (Properties)object);
        }
        receiver = this.injectUnicodeNormalizer(serializationProperties, receiver);
        receiver = this.injectCharacterMapExpander(serializationProperties, receiver, true);
        String string = ((Properties)object).getProperty("cdata-section-elements");
        if (string != null && !string.isEmpty()) {
            receiver = this.newCDATAFilter(receiver, (Properties)object);
        }
        if (SaxonOutputKeys.isXhtmlHtmlVersion5((Properties)object)) {
            receiver = this.addHtml5Component(receiver, (Properties)object);
        }
        if (!"no".equals(((Properties)object).getProperty("escape-uri-attributes"))) {
            receiver = this.newXHTMLURIEscaper(receiver, (Properties)object);
        }
        if (!"no".equals(((Properties)object).getProperty("include-content-type"))) {
            receiver = this.newXHTMLMetaTagAdjuster(receiver, (Properties)object);
        }
        if ((string = ((Properties)object).getProperty("{http://saxon.sf.net/}attribute-order")) != null && !string.isEmpty()) {
            receiver = this.newAttributeSorter(receiver, (Properties)object);
        }
        if (serializationProperties.getValidationFactory() != null) {
            receiver = serializationProperties.getValidationFactory().makeFilter(receiver);
        }
        return this.makeSequenceNormalizer(receiver, (Properties)object);
    }

    public Receiver addHtml5Component(Receiver receiver, Properties properties) {
        receiver = new NamespaceReducer(receiver);
        receiver = new XHTMLPrefixRemover(receiver);
        return receiver;
    }

    protected SequenceReceiver createXMLSerializer(XMLEmitter receiver, SerializationProperties serializationProperties) {
        String string;
        Properties properties = serializationProperties.getProperties();
        boolean bl2 = "yes".equals(properties.getProperty("{http://saxon.sf.net/}canonical"));
        if ("yes".equals(properties.getProperty("indent")) || bl2) {
            receiver = this.newXMLIndenter((XMLEmitter)receiver, properties);
        }
        if ("1.0".equals(properties.getProperty("version")) && this.a.getXMLVersion() == 11) {
            receiver = this.newXML10ContentChecker(receiver, properties);
        }
        receiver = this.injectUnicodeNormalizer(serializationProperties, receiver);
        if (!bl2) {
            receiver = this.injectCharacterMapExpander(serializationProperties, receiver, true);
        }
        if ((string = properties.getProperty("cdata-section-elements")) != null && !string.isEmpty() && !bl2) {
            receiver = this.newCDATAFilter(receiver, properties);
        }
        if (bl2) {
            receiver = this.newAttributeSorter(receiver, properties);
            receiver = this.newNamespaceSorter(receiver, properties);
        } else {
            String string2 = properties.getProperty("{http://saxon.sf.net/}attribute-order");
            if (string2 != null && !string2.isEmpty()) {
                receiver = this.newAttributeSorter(receiver, properties);
            }
        }
        if (serializationProperties.getValidationFactory() != null) {
            receiver = serializationProperties.getValidationFactory().makeFilter(receiver);
        }
        return this.makeSequenceNormalizer(receiver, properties);
    }

    protected SequenceReceiver createSaxonSerializationMethod(String string, SerializationProperties serializationProperties, PipelineConfiguration pipelineConfiguration, CharacterMapExpander characterMapExpander, ProxyReceiver proxyReceiver, StreamResult streamResult) {
        throw new XPathException("Saxon serialization methods require Saxon-PE to be enabled");
    }

    protected SequenceReceiver createUserDefinedOutputMethod(String object, Properties properties, PipelineConfiguration pipelineConfiguration) {
        object = pipelineConfiguration.getConfiguration().makeEmitter((String)object, properties);
        object.setPipelineConfiguration(pipelineConfiguration);
        if (object instanceof ContentHandlerProxy && "yes".equals(properties.getProperty("{http://saxon.sf.net/}supply-source-locator"))) {
            if (pipelineConfiguration.getConfiguration().isCompileWithTracing() && pipelineConfiguration.getController() != null) {
                pipelineConfiguration.getController().addTraceListener(((ContentHandlerProxy)object).getTraceListener());
            } else {
                throw new XPathException("Cannot use saxon:supply-source-locator unless tracing was enabled at compile time", "SXSE0002");
            }
        }
        if (object instanceof SequenceReceiver) {
            return (SequenceReceiver)object;
        }
        return new TreeReceiver((Receiver)object);
    }

    protected Receiver injectCharacterMapExpander(SerializationProperties object, Receiver receiver, boolean bl2) {
        CharacterMapIndex characterMapIndex = ((SerializationProperties)object).getCharacterMapIndex();
        if (characterMapIndex != null && (object = ((SerializationProperties)object).getProperties().getProperty("use-character-maps")) != null) {
            object = characterMapIndex.makeCharacterMapExpander((String)object, receiver, this);
            ((CharacterMapExpander)object).setUseNullMarkers(bl2);
            return object;
        }
        return receiver;
    }

    protected Receiver injectUnicodeNormalizer(SerializationProperties object, Receiver receiver) {
        String string = ((Properties)(object = ((SerializationProperties)object).getProperties())).getProperty("normalization-form");
        if (string != null && !string.equals("none")) {
            return this.newUnicodeNormalizer(receiver, (Properties)object);
        }
        return receiver;
    }

    protected ContentHandlerProxy newContentHandlerProxy() {
        return new ContentHandlerProxy();
    }

    protected UncommittedSerializer newUncommittedSerializer(Result result, Receiver receiver, SerializationProperties serializationProperties) {
        return new UncommittedSerializer(result, receiver, serializationProperties);
    }

    protected Emitter newXMLEmitter(Properties properties) {
        return new XMLEmitter();
    }

    protected Emitter newHTMLEmitter(Properties object) {
        object = SaxonOutputKeys.isHtmlVersion5((Properties)object) ? new HTML50Emitter() : new HTML40Emitter();
        return object;
    }

    protected Emitter newXHTMLEmitter(Properties properties) {
        boolean bl2 = SaxonOutputKeys.isXhtmlHtmlVersion5(properties);
        if (bl2) {
            return new XHTML5Emitter();
        }
        return new XHTML1Emitter();
    }

    public Receiver addTextOutputFilter(Receiver receiver, Properties properties) {
        return receiver;
    }

    protected Emitter newTEXTEmitter() {
        return new TEXTEmitter();
    }

    protected ProxyReceiver newXMLIndenter(XMLEmitter sequenceReceiver, Properties properties) {
        sequenceReceiver = new XMLIndenter((XMLEmitter)sequenceReceiver);
        ((XMLIndenter)sequenceReceiver).setOutputProperties(properties);
        return sequenceReceiver;
    }

    protected ProxyReceiver newHTMLIndenter(Receiver receiver, Properties properties) {
        receiver = new HTMLIndenter(receiver, "html");
        ((HTMLIndenter)receiver).setOutputProperties(properties);
        return receiver;
    }

    protected ProxyReceiver newXHTMLIndenter(Receiver receiver, Properties properties) {
        String string = "xhtml";
        String string2 = properties.getProperty("html-version");
        if (string2 != null && string2.startsWith("5")) {
            string = "xhtml5";
        }
        receiver = new HTMLIndenter(receiver, string);
        ((HTMLIndenter)receiver).setOutputProperties(properties);
        return receiver;
    }

    protected MetaTagAdjuster newXHTMLMetaTagAdjuster(Receiver receiver, Properties properties) {
        receiver = new MetaTagAdjuster(receiver);
        ((MetaTagAdjuster)receiver).setIsXHTML(true);
        ((MetaTagAdjuster)receiver).setOutputProperties(properties);
        return receiver;
    }

    protected MetaTagAdjuster newHTMLMetaTagAdjuster(Receiver receiver, Properties properties) {
        receiver = new MetaTagAdjuster(receiver);
        ((MetaTagAdjuster)receiver).setIsXHTML(false);
        ((MetaTagAdjuster)receiver).setOutputProperties(properties);
        return receiver;
    }

    protected ProxyReceiver newHTMLURIEscaper(Receiver receiver, Properties properties) {
        return new HTMLURIEscaper(receiver);
    }

    protected ProxyReceiver newXHTMLURIEscaper(Receiver receiver, Properties properties) {
        return new XHTMLURIEscaper(receiver);
    }

    protected ProxyReceiver newCDATAFilter(Receiver receiver, Properties properties) {
        receiver = new CDATAFilter(receiver);
        ((CDATAFilter)receiver).setOutputProperties(properties);
        return receiver;
    }

    protected Receiver newAttributeSorter(Receiver receiver, Properties properties) {
        return receiver;
    }

    protected Receiver newNamespaceSorter(Receiver receiver, Properties properties) {
        return receiver;
    }

    protected ProxyReceiver newXML10ContentChecker(Receiver receiver, Properties properties) {
        return new XML10ContentChecker(receiver);
    }

    protected ProxyReceiver newUnicodeNormalizer(Receiver receiver, Properties object) {
        object = ((Properties)object).getProperty("normalization-form");
        return new UnicodeNormalizer((String)object, receiver);
    }

    public CharacterMapExpander newCharacterMapExpander(Receiver receiver) {
        return new CharacterMapExpander(receiver);
    }

    public SequenceReceiver prepareNextStylesheet(PipelineConfiguration pipelineConfiguration, String string, String string2, Result result) {
        pipelineConfiguration.getConfiguration().checkLicensedFeature(8, "saxon:next-in-chain", -1);
        return null;
    }

    public SequenceWrapper newSequenceWrapper(Receiver receiver) {
        return new SequenceWrapper(receiver);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String checkOutputProperty(String object, String string) {
        if (!((String)object).startsWith("{")) {
            switch (object) {
                case "allow-duplicate-names": {
                    if (string == null) return string;
                    return SerializerFactory.checkYesOrNo((String)object, string);
                }
                case "build-tree": {
                    if (string == null) return string;
                    return SerializerFactory.checkYesOrNo((String)object, string);
                }
                case "byte-order-mark": {
                    if (string == null) return string;
                    return SerializerFactory.checkYesOrNo((String)object, string);
                }
                case "cdata-section-elements": {
                    if (string == null) return string;
                    SerializerFactory.checkListOfClarkNames((String)object, string);
                    return string;
                }
                case "doctype-public": {
                    if (string == null) return string;
                    object = string;
                    if (c.matcher((CharSequence)object).matches()) return string;
                    throw new XPathException("Invalid character in doctype-public parameter", "SEPM0016");
                }
                case "doctype-system": {
                    if (string == null) return string;
                    object = string;
                    if (!((String)object).contains("'")) return string;
                    if (!((String)object).contains("\"")) return string;
                    throw new XPathException("The doctype-system parameter must not contain both an apostrophe and a quotation mark", "SEPM0016");
                }
                case "encoding": {
                    return string;
                }
                case "escape-uri-attributes": {
                    if (string == null) return string;
                    return SerializerFactory.checkYesOrNo((String)object, string);
                }
                case "html-version": {
                    if (string == null) return string;
                    Object object2 = string;
                    if (BigDecimalValue.castableAsDecimal((CharSequence)object2)) return string;
                    throw new XPathException("Value of " + Err.wrap((CharSequence)object) + " must be a decimal number", "SEPM0016");
                }
                case "include-content-type": {
                    if (string == null) return string;
                    return SerializerFactory.checkYesOrNo((String)object, string);
                }
                case "indent": {
                    if (string == null) return string;
                    return SerializerFactory.checkYesOrNo((String)object, string);
                }
                case "item-separator": {
                    return string;
                }
                case "method": 
                case "json-node-output-method": {
                    if (string == null) return string;
                    String string2 = string;
                    Object object2 = object;
                    object = this;
                    if ("xml".equals(string2)) return string;
                    if ("html".equals(string2)) return string;
                    if ("xhtml".equals(string2)) return string;
                    if ("text".equals(string2)) return string;
                    if (!"json-node-output-method".equals(object2)) {
                        if ("json".equals(string2)) return string;
                        if ("adaptive".equals(string2)) return string;
                    }
                    if (!SerializerFactory.a(string2)) throw new XPathException("Invalid value (" + string2 + ") for serialization method: must be xml|html|xhtml|text|json|adaptive, or a QName in '{uri}local' form", "SEPM0016");
                    ((SerializerFactory)object).checkExtensions(string2);
                    return string;
                }
                case "media-type": {
                    return string;
                }
                case "normalization-form": {
                    if (string == null) return string;
                    object = string;
                    if (NameChecker.isValidNmtoken((CharSequence)object)) return string;
                    throw new XPathException("Invalid value for normalization-form: must be NFC, NFD, NFKC, NFKD, fully-normalized, or none", "SEPM0016");
                }
                case "omit-xml-declaration": {
                    if (string == null) return string;
                    return SerializerFactory.checkYesOrNo((String)object, string);
                }
                case "standalone": {
                    if (string == null) return string;
                    if (string.equals("omit")) return string;
                    return SerializerFactory.checkYesOrNo((String)object, string);
                }
                case "suppress-indentation": {
                    if (string == null) return string;
                    SerializerFactory.checkListOfClarkNames((String)object, string);
                    return string;
                }
                case "undeclare-prefixes": {
                    if (string == null) return string;
                    return SerializerFactory.checkYesOrNo((String)object, string);
                }
                case "use-character-maps": {
                    if (string == null) return string;
                    SerializerFactory.checkListOfClarkNames((String)object, string);
                    return string;
                }
                case "version": {
                    return string;
                }
                case "parameter-document": {
                    return string;
                }
                default: {
                    throw new XPathException("Unknown serialization parameter " + Err.wrap((CharSequence)object), "XQST0109");
                }
            }
        }
        if (!((String)object).startsWith("{http://saxon.sf.net/}")) return string;
        switch (object) {
            case "{http://saxon.sf.net/}stylesheet-version": {
                return string;
            }
            case "{http://saxon.sf.net/}parameter-document-base-uri": {
                return string;
            }
            case "{http://saxon.sf.net/}supply-source-locator": {
                if (string == null) return string;
                return SerializerFactory.checkYesOrNo((String)object, string);
            }
            case "{http://saxon.sf.net/}unfailing": {
                if (string == null) return string;
                return SerializerFactory.checkYesOrNo((String)object, string);
            }
            default: {
                throw new XPathException("Serialization parameter " + Err.wrap((CharSequence)object) + " not available in Saxon-HE", "XQST0109");
            }
        }
    }

    protected static String checkYesOrNo(String string, String string2) {
        if ("yes".equals(string2) || "true".equals(string2) || "1".equals(string2)) {
            return "yes";
        }
        if ("no".equals(string2) || "false".equals(string2) || "0".equals(string2)) {
            return "no";
        }
        throw new XPathException("Serialization parameter " + Err.wrap(string) + " must have the value yes|no, true|false, or 1|0", "SEPM0016");
    }

    private static boolean a(String string) {
        if (string.isEmpty() || string.charAt(0) != '{') {
            return false;
        }
        int n2 = string.indexOf(125);
        return n2 > 0 && n2 != string.length() - 1 && NameChecker.isValidNCName(string.substring(n2 + 1));
    }

    protected static void checkNonNegativeInteger(String string, String string2) {
        try {
            int n2 = Integer.parseInt(string2);
            if (n2 < 0) {
                throw new XPathException("Value of " + Err.wrap(string) + " must be a non-negative integer", "SEPM0016");
            }
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new XPathException("Value of " + Err.wrap(string) + " must be a non-negative integer", "SEPM0016");
        }
    }

    protected static void checkListOfClarkNames(String string, String object) {
        object = new StringTokenizer((String)object, " \t\n\r", false);
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string2 = ((StringTokenizer)object).nextToken();
            if (SerializerFactory.a(string2) || NameChecker.isValidNCName(string2)) continue;
            throw new XPathException("Value of " + Err.wrap(string) + " must be a list of QNames in '{uri}local' notation", "SEPM0016");
        }
    }

    protected static void checkListOfClarkNamesAllowingStar(String string, String object) {
        object = new StringTokenizer((String)object, " \t\n\r", false);
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string2 = ((StringTokenizer)object).nextToken();
            if ("*".equals(string2) || SerializerFactory.a(string2) || NameChecker.isValidNCName(string2)) continue;
            throw new XPathException("Value of " + Err.wrap(string) + " must be a list of QNames in '{uri}local' notation", "SEPM0016");
        }
    }

    public static String parseListOfNodeNames(String object, NamespaceResolver namespaceResolver, boolean bl2, boolean bl3, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        object = new StringTokenizer((String)object, " \t\n\r", false);
        while (((StringTokenizer)object).hasMoreTokens()) {
            String[] stringArray = ((StringTokenizer)object).nextToken();
            if (bl3 || namespaceResolver == null) {
                stringBuilder.append(' ').append((String)stringArray);
                continue;
            }
            if (stringArray.startsWith("Q{")) {
                stringBuilder.append(' ').append(stringArray.substring(1));
                continue;
            }
            try {
                stringArray = NameChecker.getQNameParts((CharSequence)stringArray);
                String string2 = namespaceResolver.getURIForPrefix(stringArray[0], bl2);
                if (string2 == null) {
                    throw new XPathException("Namespace prefix '" + stringArray[0] + "' has not been declared", string);
                }
                stringBuilder.append(" {").append(string2).append('}').append(stringArray[1]);
            }
            catch (QNameException qNameException) {
                throw new XPathException("Invalid element name. " + qNameException.getMessage(), string);
            }
        }
        return stringBuilder.toString();
    }

    protected void checkExtensions(String string) {
        throw new XPathException("Serialization property " + Err.wrap(string) + " is not available in Saxon-HE");
    }

    protected Comparator<AtomicValue> getPropertySorter(String string) {
        throw new XPathException("Serialization property saxon:property-order is not available in Saxon-HE");
    }
}

