/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.lib.CollationURIResolver;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;

public class StandardCollationURIResolver
implements CollationURIResolver {
    private static final StandardCollationURIResolver a = new StandardCollationURIResolver();

    public static StandardCollationURIResolver getInstance() {
        return a;
    }

    @Override
    public StringCollator resolve(String string, Configuration configuration) {
        if (string.equals("http://saxon.sf.net/collation")) {
            return Version.platform.makeCollation(configuration, new Properties(), string);
        }
        if (string.startsWith("http://saxon.sf.net/collation?")) {
            Object object;
            try {
                object = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new XPathException(uRISyntaxException);
            }
            Properties properties = new Properties();
            object = ((URI)object).getRawQuery();
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ";&");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken();
                int n2 = string2.indexOf(61);
                if (n2 <= 0 || n2 >= string2.length() - 1) continue;
                String string3 = string2.substring(0, n2);
                String string4 = AnyURIValue.decode(string2.substring(n2 + 1));
                properties.setProperty(string3, string4);
            }
            return Version.platform.makeCollation(configuration, properties, string);
        }
        if (string.startsWith("http://www.w3.org/2013/collation/UCA")) {
            Object object;
            Object object2 = Version.platform.makeUcaCollator(string, configuration);
            if (object2 != null) {
                return object2;
            }
            if (string.contains("fallback=no")) {
                return null;
            }
            try {
                object = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new XPathException(uRISyntaxException);
            }
            object2 = new Properties();
            String string5 = AnyURIValue.decode(((URI)object).getRawQuery());
            for (String string2 : string5.split(";")) {
                object = string2.split("=");
                if (((String[])object).length != 2) continue;
                string5 = object[0];
                object = object[1];
                if (string5.equals("fallback")) {
                    if (((String)object).equals("no")) {
                        return null;
                    }
                    if (!((String)object).equals("yes")) {
                        return null;
                    }
                }
                switch (string5) {
                    case "strength": {
                        switch (object) {
                            case "1": {
                                object = "primary";
                                break;
                            }
                            case "2": {
                                object = "secondary";
                                break;
                            }
                            case "3": {
                                object = "tertiary";
                                break;
                            }
                            case "quaternary": 
                            case "4": 
                            case "5": {
                                object = "identical";
                            }
                        }
                        break;
                    }
                    case "caseFirst": {
                        string5 = "case-order";
                        object = (String)object + "-first";
                        break;
                    }
                    case "numeric": {
                        string5 = "alphanumeric";
                    }
                }
                ((Properties)object2).setProperty(string5, (String)object);
            }
            return Version.platform.makeCollation(configuration, (Properties)object2, string);
        }
        return null;
    }
}

