/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.IntPredicate;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.URIQueryParameters;
import net.sf.saxon.functions.UnparsedTextFunction;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.resource.StandardCollectionFinder;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.Maker;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.wrapper.AbstractVirtualNode;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.ExternalObject;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.TextFragmentValue;
import org.xml.sax.XMLReader;

public class StandardCollectionURIResolver
implements CollectionURIResolver {
    @Override
    public SequenceIterator<?> resolve(String string, String string2, XPathContext xPathContext) {
        Object object;
        Comparable<URI> comparable;
        StandardCollectionFinder.checkNotNull(string, xPathContext);
        URIQueryParameters uRIQueryParameters = null;
        try {
            comparable = new URI(ResolveURI.escapeSpaces(string));
            object = ((URI)comparable).getQuery();
            if (object != null) {
                uRIQueryParameters = new URIQueryParameters((String)object, xPathContext.getConfiguration());
                int n2 = string.indexOf(63);
                string = ResolveURI.escapeSpaces(string.substring(0, n2));
                comparable = new URI(string);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            XPathException xPathException = new XPathException("Invalid relative URI " + Err.wrap(string, 4) + " passed to collection() function");
            xPathException.setErrorCode("FODC0004");
            xPathException.setXPathContext(xPathContext);
            throw xPathException;
        }
        object = this.makeAbsoluteURI(string, string2, xPathContext, (URI)comparable);
        if ("file".equals(((URI)object).getScheme())) {
            comparable = new File((URI)object);
            StandardCollectionURIResolver.checkFileExists((File)comparable, (URI)object, xPathContext);
            if (((File)comparable).isDirectory()) {
                return this.directoryContents((File)comparable, uRIQueryParameters, xPathContext);
            }
        }
        return this.catalogContents(string, string2, ((URI)object).toString(), xPathContext);
    }

    public static void checkFileExists(File serializable, URI uRI, XPathContext xPathContext) {
        if (!((File)serializable).exists()) {
            serializable = new XPathException("The file or directory " + uRI + " does not exist");
            ((XPathException)serializable).setErrorCode("FODC0002");
            ((XPathException)serializable).setXPathContext(xPathContext);
            throw serializable;
        }
    }

    protected URI makeAbsoluteURI(String object, String string, XPathContext xPathContext, URI uRI) {
        if (!uRI.isAbsolute()) {
            if (string == null) {
                string = ResolveURI.tryToExpand(string);
            }
            try {
                object = ResolveURI.makeAbsolute((String)object, string);
            }
            catch (URISyntaxException uRISyntaxException) {
                XPathException xPathException = new XPathException("Cannot resolve relative URI: " + uRISyntaxException.getMessage());
                xPathException.setErrorCode("FODC0004");
                xPathException.setXPathContext(xPathContext);
                throw xPathException;
            }
        } else {
            object = uRI;
        }
        return object;
    }

    protected SequenceIterator<?> directoryContents(File object, URIQueryParameters object2, XPathContext object3) {
        int n2;
        Object object4;
        File[] fileArray = null;
        if (object2 != null && (object4 = ((URIQueryParameters)object2).getFilenameFilter()) != null) {
            fileArray = object4;
        }
        object4 = fileArray == null ? object.listFiles() : object.listFiles((FilenameFilter)fileArray);
        object = new ObjectValue[((File[])object4).length];
        for (n2 = 0; n2 < ((File[])object4).length; ++n2) {
            object[n2] = new ObjectValue<File>(object4[n2]);
        }
        n2 = 1;
        if (object2 != null && ((URIQueryParameters)object2).getOnError() != null) {
            n2 = ((URIQueryParameters)object2).getOnError();
        }
        object4 = object3.getController();
        PipelineConfiguration pipelineConfiguration = object3.getConfiguration().makePipelineConfiguration();
        pipelineConfiguration.setController(object3.getController());
        object3 = new PipelineConfiguration(pipelineConfiguration);
        object4 = object4 == null ? new StandardErrorListener() : ((Controller)object4).getErrorListener();
        AbstractResourceCollection.setupErrorHandlingForCollection(((PipelineConfiguration)object3).getParseOptions(), n2, (UnfailingErrorListener)object4);
        object2 = new FileExpander((URIQueryParameters)object2, (PipelineConfiguration)object3);
        object = new ArrayIterator(object);
        return new MappingIterator(object, object2);
    }

    protected SequenceIterator<?> catalogContents(String object, String object2, String string, XPathContext xPathContext) {
        boolean bl2 = true;
        object = DocumentFn.resolveURI((String)object, (String)object2, null, xPathContext);
        object2 = new ParseOptions();
        ((ParseOptions)object2).setSchemaValidationMode(4);
        object = xPathContext.getConfiguration().buildDocument((Source)object, (ParseOptions)object2);
        if (object == null) {
            object = new XPathException("Failed to load collection catalog " + string);
            ((XPathException)object).setErrorCode("FODC0004");
            ((XPathException)object).setXPathContext(xPathContext);
            throw object;
        }
        object2 = (object = ((AbstractVirtualNode)object).iterateAxis((byte)3, NodeKindTest.ELEMENT)).next();
        if (object2 == null || !"collection".equals(object2.getLocalPart()) || !object2.getURI().isEmpty()) {
            object = object2 == null ? "No outermost element found in collection catalog" : (!object2.getURI().isEmpty() ? "Collection catalog should not use a namespace" : "Collection catalog outermost element should be <catalog> (found " + object2.getLocalPart() + ">)");
            object = new XPathException((String)object);
            ((XPathException)object).setErrorCode("FODC0004");
            ((XPathException)object).setXPathContext(xPathContext);
            throw object;
        }
        object.close();
        object = object2.getAttributeValue("", "stable");
        if (object != null) {
            if ("true".equals(object)) {
                bl2 = true;
            } else if ("false".equals(object)) {
                bl2 = false;
            } else {
                object = new XPathException("The 'stable' attribute of element <collection> must be true or false");
                ((XPathException)object).setErrorCode("FODC0004");
                ((XPathException)object).setXPathContext(xPathContext);
                throw object;
            }
        }
        boolean bl3 = bl2;
        object2 = object2.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        ItemMappingFunction<Item, Item> itemMappingFunction = item -> {
            String string;
            if (!"doc".equals((item = (NodeInfo)item).getLocalPart()) || !item.getURI().isEmpty()) {
                XPathException xPathException = new XPathException("children of <collection> element must be <doc> elements");
                xPathException.setErrorCode("FODC0004");
                xPathException.setXPathContext(xPathContext);
                throw xPathException;
            }
            String string2 = item.getAttributeValue("", "href");
            if (string2 == null) {
                XPathException xPathException = new XPathException("\"<doc> element in catalog has no @href attribute\"");
                xPathException.setErrorCode("FODC0004");
                xPathException.setXPathContext(xPathContext);
                throw xPathException;
            }
            try {
                string = new URI(item.getBaseURI()).resolve(string2).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                XPathException xPathException = new XPathException("Invalid base URI or href URI in collection catalog: (" + item.getBaseURI() + ", " + string2 + ")");
                xPathException.setErrorCode("FODC0004");
                xPathException.setXPathContext(xPathContext);
                throw xPathException;
            }
            if (bl3) {
                return new AnyURIValue(string);
            }
            return xPathContext.getConfiguration().buildDocument(new StreamSource(string));
        };
        return new ItemMappingIterator<Item, Item>((SequenceIterator<Item>)object2, itemMappingFunction);
    }

    protected static class FileExpander
    implements MappingFunction<ExternalObject<File>, Item<?>> {
        private URIQueryParameters a;
        private boolean b = false;
        private SpaceStrippingRule c = null;
        private int d = 4;
        private Boolean e = null;
        private boolean f;
        private Maker<XMLReader> g = null;
        private int h = 1;
        private FilenameFilter i = null;
        private PipelineConfiguration j;

        public FileExpander(URIQueryParameters object, PipelineConfiguration object2) {
            this.a = object;
            this.j = object2;
            if (object != null) {
                object2 = ((URIQueryParameters)object).getFilenameFilter();
                if (object2 != null) {
                    this.i = object2;
                }
                if ((object2 = ((URIQueryParameters)object).getRecurse()) != null) {
                    this.b = (Boolean)object2;
                }
                if ((object2 = ((URIQueryParameters)object).getValidationMode()) != null) {
                    this.d = (Integer)object2;
                }
                this.e = ((URIQueryParameters)object).getXInclude();
                this.c = ((URIQueryParameters)object).getSpaceStrippingRule();
                this.f = ((URIQueryParameters)object).isUnparsed();
                object2 = ((URIQueryParameters)object).getOnError();
                if (object2 != null) {
                    this.h = (Integer)object2;
                }
                if ((object = ((URIQueryParameters)object).getXMLReaderMaker()) != null) {
                    this.g = object;
                }
            }
        }

        @Override
        public SequenceIterator<?> map(ExternalObject<File> object) {
            if (((File)(object = object.getObject())).isDirectory()) {
                if (this.b) {
                    File[] fileArray = this.i == null ? ((File)object).listFiles() : ((File)object).listFiles(this.i);
                    Item[] itemArray = new ObjectValue[fileArray.length];
                    for (int i2 = 0; i2 < fileArray.length; ++i2) {
                        itemArray[i2] = new ObjectValue<File>(fileArray[i2]);
                    }
                    FileExpander fileExpander = new FileExpander(this.a, this.j);
                    return new MappingIterator(new ArrayIterator(itemArray), fileExpander);
                }
                return null;
            }
            if (this.f) {
                try {
                    Object object2 = new FileReader((File)object);
                    IntPredicate intPredicate = this.j.getConfiguration().getValidCharacterChecker();
                    CharSequence charSequence = UnparsedTextFunction.readFile(intPredicate, (Reader)object2);
                    object2 = ((File)object).toURI().toString();
                    TextFragmentValue textFragmentValue = new TextFragmentValue(this.j.getConfiguration(), charSequence, (String)object2);
                    textFragmentValue.setSystemId(((File)object).toURI().toString());
                    return SingletonIterator.makeIterator(textFragmentValue);
                }
                catch (IOException iOException) {
                    if (this.h == 3) {
                        return null;
                    }
                    if (this.h == 2) {
                        XPathException xPathException = new XPathException("Failed to read " + ((File)object).getPath(), iOException);
                        this.j.getErrorListener().warning(xPathException);
                        XPathException xPathException2 = new XPathException("The document will be excluded from the collection");
                        this.j.getErrorListener().warning(xPathException2);
                        return null;
                    }
                    throw new XPathException("Failed to read " + ((File)object).getPath(), iOException);
                }
            }
            try {
                Object object3 = ((File)object).toURI().toASCIIString();
                StreamSource streamSource = new StreamSource((String)object3);
                ParseOptions parseOptions = new ParseOptions(this.j.getParseOptions());
                if (this.d != 4 && this.d != 3) {
                    parseOptions.setSchemaValidationMode(this.d);
                }
                if (this.e != null) {
                    parseOptions.setXIncludeAware(this.e);
                }
                if (this.g != null) {
                    parseOptions.setXMLReaderMaker(this.g);
                }
                if (this.a != null && (object3 = this.a.getSpaceStrippingRule()) != null) {
                    parseOptions.setSpaceStrippingRule((SpaceStrippingRule)object3);
                }
                if (this.j.getController() != null) {
                    object3 = this.j.getController().makeBuilder();
                    if (object3 instanceof TinyBuilder) {
                        ((TinyBuilder)object3).setStatistics(this.j.getConfiguration().getTreeStatistics().SOURCE_DOCUMENT_STATISTICS);
                    }
                    Object object4 = object3;
                    if (this.j.getController().isStylesheetStrippingTypeAnnotations()) {
                        object4 = this.j.getConfiguration().getAnnotationStripper((Receiver)object4);
                    }
                    object4.setPipelineConfiguration(this.j);
                    Sender.send(streamSource, (Receiver)object4, parseOptions);
                    object = ((Builder)object3).getCurrentRoot();
                    ((Builder)object3).reset();
                    return SingletonIterator.makeIterator(object);
                }
                object3 = this.j.getConfiguration().buildDocument(streamSource, parseOptions);
                return SingletonIterator.makeIterator(object3);
            }
            catch (XPathException xPathException) {
                if (this.h == 3) {
                    return null;
                }
                if (this.h == 2) {
                    if (!xPathException.hasBeenReported()) {
                        this.j.getErrorListener().warning(xPathException);
                        XPathException xPathException3 = new XPathException("The document will be excluded from the collection");
                        xPathException3.setLocator(xPathException.getLocator());
                        this.j.getErrorListener().warning(xPathException3);
                    }
                    return null;
                }
                throw xPathException;
            }
        }
    }
}

