/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMLocator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Locatable;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.AnalyzeString;
import net.sf.saxon.expr.instruct.ApplyImports;
import net.sf.saxon.expr.instruct.ApplyTemplates;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.CallTemplate;
import net.sf.saxon.expr.instruct.ForEachGroup;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.IterateInstr;
import net.sf.saxon.expr.instruct.NamedTemplate;
import net.sf.saxon.expr.instruct.NextMatch;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.StandardLogger;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.regex.BMPString;
import net.sf.saxon.regex.GeneralUnicodeString;
import net.sf.saxon.regex.LatinString;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.BuiltInRuleSet;
import net.sf.saxon.trans.rules.Rule;
import net.sf.saxon.tree.AttributeLocation;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import org.xml.sax.SAXException;

public class StandardErrorListener
implements UnfailingErrorListener {
    private int a = 1;
    private int b = 1;
    private int c = 0;
    private int d = 25;
    private int e = 255;
    private int f = 2;
    protected transient Logger logger = new StandardLogger();

    public StandardErrorListener makeAnother(int n2) {
        StandardErrorListener standardErrorListener;
        try {
            standardErrorListener = (StandardErrorListener)this.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            standardErrorListener = new StandardErrorListener();
        }
        standardErrorListener.logger = this.logger;
        return standardErrorListener;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setRecoveryPolicy(int n2) {
        this.a = n2;
        this.b = n2;
    }

    public int getRecoveryPolicy() {
        return this.a;
    }

    public int getRequestedRecoveryPolicy() {
        return this.b;
    }

    public void setMaximumNumberOfWarnings(int n2) {
        this.d = n2;
    }

    public int getMaximumNumberOfWarnings() {
        return this.d;
    }

    public void setStackTraceDetail(int n2) {
        this.f = n2;
    }

    public int getStackTraceDetail() {
        return this.f;
    }

    public void setMaxOrdinaryCharacter(int n2) {
        this.e = n2;
    }

    public int getMaxOrdinaryCharacter(int n2) {
        return this.e;
    }

    @Override
    public void warning(TransformerException transformerException) {
        if (this.a == 0) {
            return;
        }
        if (this.logger == null) {
            this.logger = new StandardLogger();
        }
        Object object = XPathException.makeXPathException(transformerException);
        object = this.a(transformerException, (XPathException)object, "", "Warning ");
        if (transformerException instanceof ValidationException) {
            this.logger.error((String)object);
            return;
        }
        this.logger.warning((String)object);
        ++this.c;
        if (this.c > this.getMaximumNumberOfWarnings()) {
            this.logger.info("No more warnings will be displayed");
            this.a = 0;
            this.c = 0;
        }
    }

    @Override
    public void error(TransformerException transformerException) {
        String string;
        if (this.a == 0 && !(transformerException instanceof ValidationException)) {
            return;
        }
        if (this.logger == null) {
            this.logger = new StandardLogger();
        }
        if (transformerException instanceof ValidationException) {
            string = this.getExpandedMessage(transformerException);
            ValidationFailure validationFailure = ((ValidationException)transformerException).getValidationFailure();
            String string2 = validationFailure.getConstraintReferenceMessage();
            String string3 = validationFailure.getValidationLocationText();
            String string4 = validationFailure.getContextLocationText();
            string = "Validation error " + this.getLocationMessage(transformerException) + "\n  " + StandardErrorListener.wordWrap(string) + StandardErrorListener.wordWrap(string3.isEmpty() ? "" : "\n  " + string3) + StandardErrorListener.wordWrap(string4.isEmpty() ? "" : "\n  " + string4) + StandardErrorListener.wordWrap(string2 == null ? "" : "\n  " + string2) + StandardErrorListener.getOffenderListText(validationFailure);
        } else {
            string = this.a == 1 ? "Recoverable error " : "Error ";
            TransformerException transformerException2 = transformerException;
            string = this.a(transformerException2, XPathException.makeXPathException(transformerException2), "", string);
        }
        if (transformerException instanceof ValidationException) {
            this.logger.error(string);
            return;
        }
        if (this.a == 1) {
            this.logger.warning(string);
            ++this.c;
            if (this.c > this.getMaximumNumberOfWarnings()) {
                this.logger.info("No more warnings will be displayed");
                this.a = 0;
                this.c = 0;
                return;
            }
        } else {
            this.logger.error(string);
            this.logger.info("Processing terminated because error recovery is disabled");
        }
    }

    @Override
    public void fatalError(TransformerException object) {
        Object object2 = XPathException.makeXPathException((Exception)object);
        if (((XPathException)object2).hasBeenReported()) {
            return;
        }
        if (this.logger == null) {
            this.logger = new StandardLogger();
        }
        String string = ((XPathException)object2).getHostLanguage();
        String string2 = "";
        if ("XPath".equals(string)) {
            string2 = "in expression ";
        } else if ("XQuery".equals(string)) {
            string2 = "in query ";
        } else if ("XSLT Pattern".equals(string)) {
            string2 = "in pattern ";
        }
        string = "Error ";
        if (((XPathException)object2).isSyntaxError()) {
            string = "Syntax error ";
        } else if (((XPathException)object2).isStaticError()) {
            string = "Static error ";
        } else if (((XPathException)object2).isTypeError()) {
            string = "Type error ";
        }
        object2 = this.a((TransformerException)object, (XPathException)object2, string2, string);
        this.logger.error((String)object2);
        if (object instanceof XPathException) {
            ((XPathException)object).setHasBeenReported(true);
        }
        if (object instanceof XPathException && (object = ((XPathException)object).getXPathContext()) != null && this.getRequestedRecoveryPolicy() != 0 && !(object instanceof EarlyEvaluationContext)) {
            StandardErrorListener standardErrorListener = this;
            standardErrorListener.outputStackTrace(standardErrorListener.logger, (XPathContext)object);
        }
    }

    private String a(TransformerException object, XPathException object2, String string, String string2) {
        Object object3 = null;
        if (object instanceof XPathException) {
            object3 = ((XPathException)object).getFailingExpression();
        }
        if (((XPathException)object2).getLocator() instanceof AttributeLocation) {
            String string3 = string2 + string + StandardErrorListener.getLocationMessageText(((XPathException)object2).getLocator()) + "\n";
            object2 = "  " + StandardErrorListener.wordWrap(this.getExpandedMessage((TransformerException)object));
            object = string3 + (String)object2;
        } else if (((XPathException)object2).getLocator() instanceof XPathParser.NestedLocation) {
            Object object4 = (XPathParser.NestedLocation)((XPathException)object2).getLocator();
            if ((object2 = ((XPathParser.NestedLocation)object4).getContainingLocation()) instanceof AttributeLocation) {
                String string4;
                int n2 = ((XPathParser.NestedLocation)object4).getLocalLineNumber();
                int n3 = ((XPathParser.NestedLocation)object4).getColumnNumber();
                String string5 = string4 = n2 <= 0 ? "" : "on line " + n2 + ' ';
                String string6 = n3 <= 0 ? "" : "at " + (n2 <= 0 ? "char " : "column ") + n3 + ' ';
                object4 = ((XPathParser.NestedLocation)object4).getNearbyText();
                String string7 = string4 + string6;
                if (object3 != null) {
                    string7 = string4 + "evaluating (" + ((Expression)object3).toShortString() + ") ";
                } else if (object4 != null && !((String)object4).isEmpty()) {
                    string7 = string4 + (((String)object4).startsWith("...") ? "near" : "in") + ' ' + Err.wrap((CharSequence)object4) + ' ' + string6;
                }
                object3 = string7;
                object2 = string2 + (String)object3 + string + StandardErrorListener.getLocationMessageText((SourceLocator)object2) + "\n";
                object = "  " + StandardErrorListener.wordWrap(this.getExpandedMessage((TransformerException)object));
                object = (String)object2 + (String)object;
            } else {
                int n4 = ((XPathParser.NestedLocation)object4).getLocalLineNumber();
                int n5 = ((XPathParser.NestedLocation)object4).getColumnNumber();
                String string8 = "";
                string8 = string8 + (n4 < 0 ? "" : "on line " + (n4 + 1) + ' ');
                if (n5 >= 0) {
                    string8 = string8 + "at " + (n4 < 0 ? "char " : "column ") + (n5 + 1) + ' ';
                }
                if (object2.getLineNumber() > 1) {
                    string8 = string8 + "(" + string + "on line " + object2.getLineNumber() + ") ";
                }
                if (object2.getSystemId() != null) {
                    string8 = string8 + "of " + object2.getSystemId() + " ";
                }
                String string9 = ((XPathParser.NestedLocation)object4).getNearbyText();
                if (object3 != null) {
                    string8 = string8 + "evaluating (" + ((Expression)object3).toShortString() + ")";
                } else if (string9 != null && !string9.isEmpty()) {
                    string8 = string8 + (string9.startsWith("...") ? "near" : "in") + ' ' + Err.wrap(string9) + ' ';
                }
                String string10 = string2 + string8 + "\n";
                object4 = "  " + StandardErrorListener.wordWrap(this.getExpandedMessage((TransformerException)object));
                object = string10 + (String)object4;
            }
        } else if (object2 instanceof ValidationException) {
            String string11 = this.getExpandedMessage((TransformerException)object);
            String string12 = ((ValidationFailure)(object2 = ((ValidationException)object2).getValidationFailure())).getConstraintReferenceMessage();
            if (string12 != null) {
                string11 = string11 + " (" + string12 + ')';
            }
            object = "Validation error " + this.getLocationMessage((TransformerException)object) + "\n  " + StandardErrorListener.wordWrap(string11);
            object = (String)object + StandardErrorListener.getOffenderListText((ValidationFailure)object2);
        } else {
            object = string2 + (object3 != null ? "evaluating (" + ((Expression)object3).toShortString() + ") " : "") + this.getLocationMessage((TransformerException)object) + "\n  " + StandardErrorListener.wordWrap(this.getExpandedMessage((TransformerException)object));
        }
        return this.expandSpecialCharacters((CharSequence)object).toString();
    }

    public static String getOffenderListText(ValidationFailure iterator) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!(iterator = ((ValidationFailure)((Object)iterator)).getOffendingNodes()).isEmpty()) {
            stringBuilder.append("\n  Nodes for which the assertion fails:");
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                NodeInfo nodeInfo = (NodeInfo)iterator.next();
                String string = Type.displayTypeName(nodeInfo);
                if (nodeInfo.getNodeKind() == 3) {
                    string = string + " " + Err.wrap(nodeInfo.getStringValueCS(), 4);
                }
                if (nodeInfo.getLineNumber() != -1) {
                    string = string + " on line " + nodeInfo.getLineNumber();
                    if (nodeInfo.getColumnNumber() != -1) {
                        string = string + " column " + nodeInfo.getColumnNumber();
                    }
                    if (nodeInfo.getSystemId() != null) {
                        string = string + " of " + nodeInfo.getSystemId();
                    }
                } else {
                    string = string + " at " + Navigator.getPath(nodeInfo);
                }
                stringBuilder.append("\n  * ").append(string);
            }
        }
        return stringBuilder.toString();
    }

    protected void outputStackTrace(Logger logger, XPathContext xPathContext) {
        StandardErrorListener.printStackTrace(xPathContext, logger, this.f);
    }

    public String getLocationMessage(TransformerException transformerException) {
        SourceLocator sourceLocator = transformerException.getLocator();
        while (sourceLocator == null) {
            if (transformerException.getException() instanceof TransformerException) {
                transformerException = (TransformerException)transformerException.getException();
                sourceLocator = transformerException.getLocator();
                continue;
            }
            if (transformerException.getCause() instanceof TransformerException) {
                transformerException = (TransformerException)transformerException.getCause();
                sourceLocator = transformerException.getLocator();
                continue;
            }
            return "";
        }
        return StandardErrorListener.getLocationMessageText(sourceLocator);
    }

    public static String getLocationMessageText(SourceLocator sourceLocator) {
        boolean bl2;
        Object object;
        Object object2;
        String string = "";
        String string2 = null;
        NodeInfo nodeInfo = null;
        String string3 = null;
        int n2 = -1;
        if (sourceLocator == null) {
            sourceLocator = ExplicitLocation.UNKNOWN_LOCATION;
        }
        if (sourceLocator instanceof XPathParser.NestedLocation) {
            sourceLocator = ((XPathParser.NestedLocation)sourceLocator).getContainingLocation();
        }
        if (sourceLocator instanceof AttributeLocation) {
            object2 = (AttributeLocation)sourceLocator;
            string3 = "in " + ((AttributeLocation)object2).getElementName().getDisplayName();
            if (((AttributeLocation)object2).getAttributeName() != null) {
                string3 = string3 + "/@" + ((AttributeLocation)object2).getAttributeName();
            }
            string3 = string3 + ' ';
        } else if (sourceLocator instanceof DOMLocator) {
            string3 = "at " + ((DOMLocator)sourceLocator).getOriginatingNode().getNodeName() + ' ';
        } else if (sourceLocator instanceof NodeInfo) {
            nodeInfo = (NodeInfo)sourceLocator;
            string3 = "at " + nodeInfo.getDisplayName() + ' ';
        } else if (sourceLocator instanceof ValidationException && (nodeInfo = ((ValidationException)((Object)sourceLocator)).getNode()) != null) {
            string3 = "at " + nodeInfo.getDisplayName() + ' ';
        } else if (sourceLocator instanceof ValidationException && sourceLocator.getLineNumber() == -1 && (object2 = ((ValidationException)((Object)sourceLocator)).getPath()) != null) {
            string3 = "at " + (String)object2 + ' ';
        } else if (sourceLocator instanceof Instruction) {
            object2 = StandardErrorListener.getInstructionName((Instruction)((Object)sourceLocator));
            if (!"".equals(object2)) {
                string3 = "at " + (String)object2 + ' ';
            }
            string2 = sourceLocator.getSystemId();
            n2 = sourceLocator.getLineNumber();
        } else if (sourceLocator instanceof Actor) {
            object2 = "procedure";
            if (sourceLocator instanceof UserFunction) {
                object2 = "function";
            } else if (sourceLocator instanceof NamedTemplate) {
                object2 = "template";
            } else if (sourceLocator instanceof AttributeSet) {
                object2 = "attribute-set";
            } else if (sourceLocator instanceof KeyDefinition) {
                object2 = "key";
            }
            string2 = sourceLocator.getSystemId();
            n2 = sourceLocator.getLineNumber();
            string3 = "at " + (String)object2 + " ";
            object = ((InstructionInfo)sourceLocator).getObjectName();
            if (object != null) {
                string3 = string3 + ((StructuredQName)object).toString();
                string3 = string3 + " ";
            }
        }
        if (n2 == -1) {
            n2 = sourceLocator.getLineNumber();
        }
        boolean bl3 = bl2 = n2 != -1;
        if (nodeInfo != null && !bl2) {
            string3 = "at " + Navigator.getPath(nodeInfo) + ' ';
        }
        if (string3 != null) {
            string = string + string3;
        }
        if (bl2) {
            string = string + "on line " + n2 + ' ';
            if (sourceLocator.getColumnNumber() != -1) {
                string = string + "column " + sourceLocator.getColumnNumber() + ' ';
            }
        }
        if (string2 != null && string2.isEmpty()) {
            string2 = null;
        }
        if (string2 == null) {
            try {
                string2 = sourceLocator.getSystemId();
            }
            catch (Exception exception) {
                object = exception;
                exception.printStackTrace();
            }
        }
        if (string2 != null && !string2.isEmpty()) {
            string = string + (bl2 ? "of " : "in ") + StandardErrorListener.abbreviatePath(string2) + ':';
        }
        return string;
    }

    public static String abbreviatePath(String string) {
        if (string == null) {
            return "*unknown*";
        }
        int n2 = string.lastIndexOf(47);
        if (n2 >= 0 && n2 < string.length() - 1) {
            return string.substring(n2 + 1);
        }
        return string;
    }

    public String getExpandedMessage(TransformerException transformerException) {
        String string;
        Object object = null;
        if (transformerException instanceof XPathException) {
            object = ((XPathException)transformerException).getErrorCodeQName();
        }
        if (object == null && transformerException.getException() instanceof XPathException) {
            object = ((XPathException)transformerException.getException()).getErrorCodeQName();
        }
        String string2 = "";
        if (object != null) {
            string2 = ((StructuredQName)object).hasURI("http://www.w3.org/2005/xqt-errors") ? ((StructuredQName)object).getLocalPart() : ((StructuredQName)object).getDisplayName();
        }
        if (transformerException instanceof XPathException && (object = ((XPathException)transformerException).getErrorObject()) != null && (string = this.getErrorObjectString((Sequence<?>)object)) != null) {
            string2 = string2 + " " + string;
        }
        object = transformerException;
        while (object != null) {
            string = ((Throwable)object).getMessage();
            if (string == null) {
                string = "";
            }
            if (string.startsWith("net.sf.saxon.trans.XPathException: ")) {
                String string3 = string;
                string = string3.substring(string3.indexOf(": ") + 2);
            }
            if (!"TRaX Transform Exception".equals(string) && !string2.endsWith(string)) {
                if (!"".equals(string2) && !string2.trim().endsWith(":")) {
                    string2 = string2 + ": ";
                }
                string2 = string2 + string;
            }
            if (object instanceof TransformerException) {
                object = ((TransformerException)object).getException();
                continue;
            }
            if (!(object instanceof SAXException)) break;
            object = ((SAXException)object).getException();
        }
        return string2;
    }

    public String getErrorObjectString(Sequence<?> sequence) {
        return null;
    }

    public static String getInstructionName(Instruction object) {
        int n2;
        block19: {
            try {
                n2 = ((Instruction)object).getInstructionNameCode();
                if (n2 < 0) {
                    return "";
                }
                if (n2 >= 1024 || n2 == 158 || n2 == 200) break block19;
                if (((Expression)object).getPackageData().getHostLanguage() == 50) {
                    return StandardNames.getDisplayName(n2);
                }
                object = StandardNames.getDisplayName(n2);
                if ((n2 = ((String)object).indexOf(58)) > 0) {
                    String string = ((String)object).substring(n2 + 1);
                    if (string.equals("document")) {
                        return "document node constructor";
                    }
                    if (string.equals("text") || ((String)object).equals("value-of")) {
                        return "text node constructor";
                    }
                    if (string.equals("element")) {
                        return "computed element constructor";
                    }
                    if (string.equals("attribute")) {
                        return "computed attribute constructor";
                    }
                    if (string.equals("variable")) {
                        return "variable declaration";
                    }
                    if (string.equals("param")) {
                        return "external variable declaration";
                    }
                    if (string.equals("comment")) {
                        return "comment constructor";
                    }
                    if (string.equals("processing-instruction")) {
                        return "processing-instruction constructor";
                    }
                    if (string.equals("namespace")) {
                        return "namespace node constructor";
                    }
                }
                return object;
            }
            catch (Exception exception) {
                return "";
            }
        }
        switch (n2) {
            case 2006: {
                object = ((Expression)object).getObjectName();
                return "element constructor <" + ((StructuredQName)object).getDisplayName() + '>';
            }
            case 2007: {
                object = ((Expression)object).getObjectName();
                return "attribute constructor " + ((StructuredQName)object).getDisplayName() + "=\"{...}\"";
            }
        }
        return "";
    }

    public static String wordWrap(String string) {
        int n2;
        if (string.length() > 1000) {
            string = string.substring(0, 1000);
        }
        if ((n2 = string.indexOf(10)) < 0) {
            n2 = string.length();
        }
        if (n2 > 100) {
            for (n2 = 90; string.charAt(n2) != ' ' && n2 > 0; --n2) {
            }
            if (n2 > 10) {
                return string.substring(0, n2) + "\n  " + StandardErrorListener.wordWrap(string.substring(n2 + 1));
            }
            return string;
        }
        if (n2 < string.length()) {
            return string.substring(0, n2) + '\n' + StandardErrorListener.wordWrap(string.substring(n2 + 1));
        }
        return string;
    }

    public static void printStackTrace(XPathContext xPathContext, Logger logger, int n2) {
        if (n2 > 0) {
            int n3 = 20;
            while (n3-- > 0) {
                StringBuilder stringBuilder;
                Object object;
                if (n2 > 0) {
                    object = xPathContext.getCurrentComponent();
                    if (object != null) {
                        if (((Component)object).getActor() instanceof Mode) {
                            object = xPathContext.getCurrentTemplateRule();
                            if (object != null) {
                                stringBuilder = new StringBuilder();
                                Location location = ((Rule)object).getPattern().getLocation();
                                stringBuilder.append("  In template rule with match=\"").append(((Expression)((Rule)object).getPattern()).toShortString()).append("\" ");
                                if (location != null && location.getLineNumber() != -1) {
                                    stringBuilder.append("on line ").append(location.getLineNumber()).append(" ");
                                }
                                if (location != null && location.getSystemId() != null) {
                                    stringBuilder.append("of ").append(StandardErrorListener.abbreviatePath(location.getSystemId()));
                                }
                                logger.error(stringBuilder.toString());
                            }
                        } else {
                            logger.error(StandardErrorListener.getLocationMessageText(((Component)object).getActor()).replace("$at ", "In "));
                        }
                    }
                    xPathContext.getStackFrame().getStackFrameMap().showStackFrame(xPathContext, logger);
                }
                while (!(xPathContext instanceof XPathContextMajor)) {
                    xPathContext = xPathContext.getCaller();
                }
                object = ((XPathContextMajor)xPathContext).getOrigin();
                if (object instanceof Controller) {
                    return;
                }
                StringBuilder stringBuilder2 = new StringBuilder("     invoked by ");
                stringBuilder = new StringBuilder();
                if (object == null) {
                    stringBuilder.append("unknown caller (null)");
                } else if (object instanceof ApplyTemplates) {
                    stringBuilder.append("xsl:apply-templates");
                } else if (object instanceof NextMatch) {
                    stringBuilder.append("xsl:next-match");
                } else if (object instanceof ApplyImports) {
                    stringBuilder.append("xsl:apply-imports");
                } else if (object instanceof UserFunctionCall) {
                    stringBuilder.append("function call");
                } else if (object instanceof CallTemplate) {
                    stringBuilder.append("xsl:call-template");
                } else if (object instanceof Controller) {
                    stringBuilder.append("external application");
                } else if (object instanceof BuiltInRuleSet) {
                    stringBuilder.append("built-in template rule (" + ((BuiltInRuleSet)object).getName() + ")");
                } else if (object instanceof IterateInstr) {
                    stringBuilder.append("xsl:iterate");
                } else if (object instanceof ForEachGroup) {
                    stringBuilder.append("xsl:for-each-group");
                } else if (object instanceof AnalyzeString) {
                    stringBuilder.append("xsl:analyze-string");
                } else if (object instanceof ResultDocument) {
                    stringBuilder.append("xsl:result-document");
                } else if (object instanceof KeyDefinition) {
                    stringBuilder.append("xsl:key definition");
                } else if (object instanceof GlobalParam) {
                    stringBuilder.append("global xsl:param");
                } else if (object instanceof GlobalVariable) {
                    stringBuilder.append("global xsl:variable");
                } else {
                    stringBuilder.append("unknown caller (" + object.getClass() + ")");
                }
                if (object instanceof Locatable && (object = ((Locatable)object).getLocation()).getLineNumber() != -1) {
                    stringBuilder.append(" at ").append(object.getSystemId() == null ? "line " : object.getSystemId() + "#");
                    stringBuilder.append(object.getLineNumber());
                }
                logger.error(stringBuilder2.append(stringBuilder.toString()).toString());
                if ((xPathContext = xPathContext.getCaller()) != null) continue;
                return;
            }
        }
    }

    public CharSequence expandSpecialCharacters(CharSequence charSequence) {
        if (this.logger.isUnicodeAware()) {
            return charSequence;
        }
        return StandardErrorListener.expandSpecialCharacters(charSequence, this.e);
    }

    public static CharSequence expandSpecialCharacters(CharSequence charSequence, int n2) {
        if (n2 >= 0x10FFFF) {
            return charSequence;
        }
        int n3 = 0;
        boolean bl2 = false;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 > n3) {
                n3 = c2;
            }
            if (!UTF16CharacterSet.isSurrogate(c2)) continue;
            bl2 = true;
        }
        if (n3 <= n2 && !bl2) {
            return charSequence;
        }
        UnicodeString unicodeString = n3 <= 255 ? new LatinString(charSequence) : (!bl2 ? new BMPString(charSequence) : new GeneralUnicodeString(charSequence));
        FastStringBuffer fastStringBuffer = new FastStringBuffer(unicodeString.uLength() << 1);
        for (int i3 = 0; i3 < unicodeString.uLength(); ++i3) {
            n3 = unicodeString.uCharAt(i3);
            fastStringBuffer.appendWideChar(n3);
            if (n3 <= n2) continue;
            fastStringBuffer.append("[x");
            fastStringBuffer.append(Integer.toHexString(n3));
            fastStringBuffer.append("]");
        }
        return fastStringBuffer;
    }
}

