/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import javax.xml.transform.dom.DOMLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.NamedTemplate;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.lib.Invalidity;
import net.sf.saxon.lib.InvalidityHandler;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.EmptySequence;

public class StandardInvalidityHandler
implements InvalidityHandler {
    private Configuration a;
    private Logger b;

    public StandardInvalidityHandler(Configuration configuration) {
        this.a = configuration;
    }

    public void setLogger(Logger logger) {
        this.b = logger;
    }

    public Logger getLogger() {
        return this.b;
    }

    public Configuration getConfiguration() {
        return this.a;
    }

    @Override
    public void startReporting(String string) {
    }

    @Override
    public void reportInvalidity(Invalidity object) {
        Logger logger = this.b;
        if (logger == null) {
            logger = this.a.getLogger();
        }
        String string = this.getExpandedMessage((Invalidity)object);
        String string2 = StandardInvalidityHandler.getConstraintReferenceMessage((Invalidity)object);
        ((ValidationFailure)object).getValidationLocationText();
        String string3 = ((ValidationFailure)object).getContextLocationText();
        StringBuilder stringBuilder = new StringBuilder("Validation error ").append(this.getLocationMessage((Invalidity)object)).append("\n  ").append(StandardErrorListener.wordWrap(string));
        string = string3.isEmpty() ? "" : "\n  " + string3;
        StringBuilder stringBuilder2 = stringBuilder.append(StandardErrorListener.wordWrap(string));
        string = string2 == null ? "" : "\n  " + string2;
        object = stringBuilder2.append(StandardErrorListener.wordWrap(string)).append(StandardErrorListener.getOffenderListText((ValidationFailure)object)).toString();
        logger.error((String)object);
    }

    public String getLocationMessage(Invalidity object) {
        boolean bl2;
        String string = "";
        String string2 = null;
        NodeInfo nodeInfo = ((ValidationFailure)object).getInvalidNode();
        String string3 = null;
        int n2 = -1;
        Object object2 = object;
        if (object2 instanceof DOMLocator) {
            string3 = "at " + ((DOMLocator)object2).getOriginatingNode().getNodeName() + ' ';
        } else if (object2 instanceof ValidationException && object2.getLineNumber() == -1 && (object = ((ValidationException)object2).getPath()) != null) {
            string3 = "at " + (String)object + ' ';
        } else if (object2 instanceof Instruction) {
            object = StandardErrorListener.getInstructionName((Instruction)object2);
            if (!"".equals(object)) {
                string3 = "at " + (String)object + ' ';
            }
            string2 = object2.getSystemId();
            n2 = object2.getLineNumber();
        } else if (object2 instanceof Actor) {
            object = "procedure";
            if (object2 instanceof UserFunction) {
                object = "function";
            } else if (object2 instanceof NamedTemplate) {
                object = "template";
            } else if (object2 instanceof AttributeSet) {
                object = "attribute-set";
            } else if (object2 instanceof KeyDefinition) {
                object = "key";
            }
            string2 = object2.getSystemId();
            n2 = object2.getLineNumber();
            string3 = "at " + (String)object + " ";
            object = ((InstructionInfo)object2).getObjectName();
            if (object != null) {
                string3 = string3 + ((StructuredQName)object).toString();
                string3 = string3 + " ";
            }
        }
        if (n2 == -1) {
            n2 = object2.getLineNumber();
        }
        boolean bl3 = bl2 = n2 != -1;
        if (nodeInfo != null) {
            string3 = "at " + Navigator.getPath(nodeInfo) + ' ';
        }
        if (string3 != null) {
            string = string + string3;
        }
        if (bl2) {
            string = string + "on line " + n2 + ' ';
            if (object2.getColumnNumber() != -1) {
                string = string + "column " + object2.getColumnNumber() + ' ';
            }
        }
        if (string2 != null && string2.isEmpty()) {
            string2 = null;
        }
        if (string2 == null) {
            string2 = object2.getSystemId();
        }
        if (string2 != null && string2.length() != 0) {
            string = string + (bl2 ? "of " : "in ") + StandardInvalidityHandler.abbreviatePath(string2) + ':';
        }
        return string;
    }

    public static String abbreviatePath(String string) {
        if (string == null) {
            return "*unknown*";
        }
        int n2 = string.lastIndexOf(47);
        if (n2 >= 0 && n2 < string.length() - 1) {
            return string.substring(n2 + 1);
        }
        return string;
    }

    public String getExpandedMessage(Invalidity invalidity) {
        String string = invalidity.getErrorCode();
        return (string == null ? "" : string + ": ") + invalidity.getMessage();
    }

    public static String getConstraintReferenceMessage(Invalidity invalidity) {
        if (invalidity.getSchemaPart() == -1) {
            return null;
        }
        return "See http://www.w3.org/TR/xmlschema-" + invalidity.getSchemaPart() + "/#" + invalidity.getConstraintName() + " clause " + invalidity.getConstraintClauseNumber();
    }

    @Override
    public Sequence<?> endReporting() {
        return EmptySequence.getInstance();
    }
}

