/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.trans.XPathException;

public class StandardModuleURIResolver
implements ModuleURIResolver {
    private Configuration a;

    public StandardModuleURIResolver() {
    }

    public StandardModuleURIResolver(Configuration configuration) {
        this.a = configuration;
    }

    @Override
    public StreamSource[] resolve(String object, String string, String[] stringArray) {
        if (stringArray.length == 0) {
            object = new XPathException("Cannot locate module for namespace " + (String)object);
            ((XPathException)object).setErrorCode("XQST0059");
            ((XPathException)object).setIsStaticError(true);
            throw object;
        }
        object = new StreamSource[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            URI uRI;
            String string2 = stringArray[i2];
            try {
                uRI = ResolveURI.makeAbsolute(string2, string);
            }
            catch (URISyntaxException uRISyntaxException) {
                XPathException xPathException = new XPathException("Cannot resolve relative URI " + string2, uRISyntaxException);
                xPathException.setErrorCode("XQST0059");
                xPathException.setIsStaticError(true);
                throw xPathException;
            }
            object[i2] = this.getQuerySource(uRI);
        }
        return object;
    }

    protected StreamSource getQuerySource(URI uRI) {
        String string = null;
        try {
            InputStream inputStream;
            Object object;
            if ("classpath".equals(uRI.getScheme())) {
                object = uRI.getPath();
                inputStream = this.a.getDynamicLoader().getResourceAsStream((String)object);
                if (inputStream == null) {
                    object = new XPathException("Cannot locate module " + (String)object + " on class path");
                    ((XPathException)object).setErrorCode("XQST0059");
                    ((XPathException)object).setIsStaticError(true);
                    throw object;
                }
            } else {
                int n2;
                object = uRI.toURL();
                object = ((URL)object).openConnection();
                ((URLConnection)object).connect();
                inputStream = ((URLConnection)object).getInputStream();
                if (!"file".equals(((URLConnection)object).getURL().getProtocol()) && (object = ((URLConnection)object).getContentType()) != null && (n2 = ((String)object).indexOf("charset")) >= 0) {
                    if ((n2 = ((String)object).indexOf(61, n2 + 7)) >= 0) {
                        object = ((String)object).substring(n2 + 1);
                    }
                    if ((n2 = ((String)object).indexOf(59)) > 0) {
                        object = ((String)object).substring(0, n2);
                    }
                    if ((n2 = ((String)object).indexOf(40)) > 0) {
                        object = ((String)object).substring(0, n2);
                    }
                    if ((n2 = ((String)object).indexOf(34)) > 0) {
                        object = ((String)object).substring(n2 + 1, ((String)object).indexOf(34, n2 + 2));
                    }
                    string = ((String)object).trim();
                }
            }
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            object = new StreamSource();
            if (string == null) {
                ((StreamSource)object).setInputStream(inputStream);
            } else {
                ((StreamSource)object).setReader(new InputStreamReader(inputStream, string));
            }
            ((StreamSource)object).setSystemId(uRI.toString());
            return object;
        }
        catch (IOException iOException) {
            XPathException xPathException = new XPathException(iOException);
            xPathException.setErrorCode("XQST0059");
            xPathException.setIsStaticError(true);
            throw xPathException;
        }
    }
}

