/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.StandardResultDocumentResolver;
import net.sf.saxon.trans.XPathException;

public class StandardOutputResolver
implements OutputURIResolver {
    private static StandardOutputResolver a = new StandardOutputResolver();

    public static StandardOutputResolver getInstance() {
        return a;
    }

    @Override
    public StandardOutputResolver newInstance() {
        return this;
    }

    @Override
    public Result resolve(String string, String object) {
        String string2 = "base";
        try {
            URI uRI;
            if (string.isEmpty()) {
                if (object == null) {
                    throw new XPathException("The system identifier of the principal output file is unknown", "SXRD0002");
                }
                uRI = new URI((String)object);
            } else {
                string2 = "relative";
                uRI = new URI(string);
            }
            if (!uRI.isAbsolute()) {
                if (object == null) {
                    throw new XPathException("The system identifier of the principal output file is unknown", "SXRD0002");
                }
                string2 = "base";
                object = new URI((String)object);
                string2 = "relative";
                uRI = ((URI)object).resolve(string);
            }
            return this.createResult(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            object = new XPathException("Invalid syntax for " + string2 + " URI");
            ((XPathException)object).setErrorCode("SXRD0001");
            throw object;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = new XPathException("Invalid " + string2 + " URI syntax");
            ((XPathException)object).setErrorCode("SXRD0001");
            throw object;
        }
        catch (MalformedURLException malformedURLException) {
            object = new XPathException("Resolved URL is malformed", malformedURLException);
            ((XPathException)object).setErrorCode("SXRD0001");
            throw object;
        }
        catch (UnknownServiceException unknownServiceException) {
            object = new XPathException("Specified protocol does not allow output", unknownServiceException);
            ((XPathException)object).setErrorCode("SXRD0001");
            throw object;
        }
        catch (IOException iOException) {
            object = new XPathException("Cannot open connection to specified URL", iOException);
            ((XPathException)object).setErrorCode("SXRD0001");
            throw object;
        }
    }

    protected Result createResult(URI uRI) {
        if ("file".equals(uRI.getScheme())) {
            return StandardResultDocumentResolver.makeOutputFile(uRI);
        }
        Object object = uRI.toURL().openConnection();
        ((URLConnection)object).setDoInput(false);
        ((URLConnection)object).setDoOutput(true);
        ((URLConnection)object).connect();
        object = ((URLConnection)object).getOutputStream();
        object = new StreamResult((OutputStream)object);
        ((StreamResult)object).setSystemId(uRI.toASCIIString());
        return object;
    }

    @Override
    public void close(Result object) {
        if (object instanceof StreamResult) {
            OutputStream outputStream = ((StreamResult)object).getOutputStream();
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    XPathException xPathException = new XPathException("Failed while closing output file", iOException);
                    xPathException.setErrorCode("SXRD0003");
                    throw xPathException;
                }
            }
            if ((object = ((StreamResult)object).getWriter()) != null) {
                try {
                    ((Writer)object).close();
                    return;
                }
                catch (IOException iOException) {
                    XPathException xPathException = new XPathException("Failed while closing output file", iOException);
                    xPathException.setErrorCode("SXRD0003");
                    throw xPathException;
                }
            }
        }
    }
}

