/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ResultDocumentResolver;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trans.XPathException;

public class StandardResultDocumentResolver
implements ResultDocumentResolver {
    private static StandardResultDocumentResolver a = new StandardResultDocumentResolver();

    public static StandardResultDocumentResolver getInstance() {
        return a;
    }

    @Override
    public Receiver resolve(XPathContext object, String object2, String object3, SerializationProperties serializationProperties) {
        object2 = this.resolve((String)object2, (String)object3);
        object3 = object.getConfiguration().getSerializerFactory();
        object = object.getController().makePipelineConfiguration();
        return ((SerializerFactory)object3).getReceiver((Result)object2, serializationProperties, (PipelineConfiguration)object);
    }

    public StreamResult resolve(String string, String object) {
        String string2 = "base";
        try {
            URI uRI;
            if (string.isEmpty()) {
                if (object == null) {
                    throw new XPathException("The system identifier of the principal output file is unknown");
                }
                uRI = new URI((String)object);
            } else {
                string2 = "relative";
                uRI = new URI(string);
            }
            if (!uRI.isAbsolute()) {
                if (object == null) {
                    throw new XPathException("The system identifier of the principal output file is unknown");
                }
                string2 = "base";
                object = new URI((String)object);
                string2 = "relative";
                uRI = ((URI)object).resolve(string);
            }
            return this.createResult(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XPathException("Invalid syntax for " + string2 + " URI", uRISyntaxException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new XPathException("Invalid " + string2 + " URI syntax", illegalArgumentException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new XPathException("Resolved URL is malformed", malformedURLException);
        }
        catch (UnknownServiceException unknownServiceException) {
            throw new XPathException("Specified protocol does not allow output", unknownServiceException);
        }
        catch (IOException iOException) {
            throw new XPathException("Cannot open connection to specified URL", iOException);
        }
    }

    protected StreamResult createResult(URI uRI) {
        if ("file".equals(uRI.getScheme())) {
            return StandardResultDocumentResolver.makeOutputFile(uRI);
        }
        Object object = uRI.toURL().openConnection();
        ((URLConnection)object).setDoInput(false);
        ((URLConnection)object).setDoOutput(true);
        ((URLConnection)object).connect();
        object = ((URLConnection)object).getOutputStream();
        object = new StreamResult((OutputStream)object);
        ((StreamResult)object).setSystemId(uRI.toASCIIString());
        return object;
    }

    public static synchronized StreamResult makeOutputFile(URI uRI) {
        try {
            return new StreamResult(new File(uRI));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new XPathException("Cannot write to URI " + uRI + " (" + illegalArgumentException.getMessage() + ")");
        }
    }

    public void close(Result object) {
        if (object instanceof StreamResult) {
            OutputStream outputStream = ((StreamResult)object).getOutputStream();
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    throw new XPathException("Failed while closing output file", iOException);
                }
            }
            if ((object = ((StreamResult)object).getWriter()) != null) {
                try {
                    ((Writer)object).close();
                    return;
                }
                catch (IOException iOException) {
                    throw new XPathException("Failed while closing output file", iOException);
                }
            }
        }
    }
}

