/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.expr.sort.LRUCache;
import net.sf.saxon.functions.IriToUri;
import net.sf.saxon.lib.URIChecker;
import net.sf.saxon.value.Whitespace;

public class StandardURIChecker
implements URIChecker {
    private static StandardURIChecker a = new StandardURIChecker();
    private static ThreadLocal<LRUCache<CharSequence, Boolean>> b = new ThreadLocal();

    public static StandardURIChecker getInstance() {
        return a;
    }

    protected StandardURIChecker() {
    }

    @Override
    public boolean isValidURI(CharSequence charSequence) {
        LRUCache<CharSequence, Boolean> lRUCache = b.get();
        if (lRUCache == null) {
            lRUCache = new LRUCache(50);
            b.set(lRUCache);
        }
        if (lRUCache.get(charSequence) != null) {
            return true;
        }
        String string = Whitespace.trim(charSequence);
        if (string.isEmpty()) {
            return true;
        }
        try {
            new URI(string);
            lRUCache.put(charSequence, Boolean.TRUE);
            return true;
        }
        catch (URISyntaxException uRISyntaxException) {
            string = IriToUri.iriToUri(string).toString();
            try {
                new URI(string);
                lRUCache.put(charSequence, Boolean.TRUE);
                return true;
            }
            catch (URISyntaxException uRISyntaxException2) {
                return false;
            }
        }
    }

    public static void main(String[] stringArray) {
        System.err.println(stringArray[0] + " is valid? - " + StandardURIChecker.getInstance().isValidURI(stringArray[0]));
    }
}

