/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.Version;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.event.IDFilter;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.functions.EncodeForUri;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.URIQueryParameters;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.resource.BinaryResource;
import net.sf.saxon.resource.DataURIScheme;
import net.sf.saxon.resource.UnparsedTextResource;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.Maker;
import net.sf.saxon.trans.NonDelegatingURIResolver;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class StandardURIResolver
implements NonDelegatingURIResolver {
    private Configuration a = null;
    protected boolean recognizeQueryParameters = false;

    public StandardURIResolver() {
        this(null);
    }

    public StandardURIResolver(Configuration configuration) {
        this.a = configuration;
    }

    public void setRecognizeQueryParameters(boolean bl2) {
        this.recognizeQueryParameters = bl2;
    }

    public boolean queryParametersAreRecognized() {
        return this.recognizeQueryParameters;
    }

    protected Platform getPlatform() {
        return Version.platform;
    }

    public void setConfiguration(Configuration configuration) {
        this.a = configuration;
    }

    public Configuration getConfiguration() {
        return this.a;
    }

    @Override
    public Source resolve(String object, String string) {
        Maker<XMLReader> maker;
        Object object2;
        Object object3;
        if (this.a != null && this.a.isTiming()) {
            assert (this.a != null);
            this.a.getStandardErrorOutput().println("URIResolver.resolve href=\"" + (String)object + "\" base=\"" + string + "\"");
        }
        String string2 = object;
        String string3 = null;
        int n2 = ((String)object).indexOf(35);
        if (n2 >= 0) {
            string2 = ((String)object).substring(0, n2);
            string3 = ((String)object).substring(n2 + 1);
        }
        URIQueryParameters uRIQueryParameters = null;
        try {
            string2 = ResolveURI.escapeSpaces(string2);
            object3 = new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XPathException("Invalid relative URI " + Err.wrap(string2), uRISyntaxException);
        }
        object3 = ((URI)object3).getQuery();
        if (object3 != null && this.recognizeQueryParameters) {
            uRIQueryParameters = new URIQueryParameters((String)object3, this.a);
            int n3 = string2.indexOf(63);
            string2 = string2.substring(0, n3);
        }
        Object object4 = null;
        if (this.recognizeQueryParameters && string2.endsWith(".ptree")) {
            object4 = this.getPTreeSource(string2, string);
        }
        if (object4 == null) {
            try {
                object4 = ResolveURI.makeAbsolute(string2, string);
            }
            catch (URISyntaxException uRISyntaxException) {
                String string4 = ResolveURI.tryToExpand(string);
                if (!string4.equals(string)) {
                    return this.resolve((String)object, string4);
                }
                throw new XPathException("Invalid URI " + Err.wrap(string2) + " - base " + Err.wrap(string), uRISyntaxException);
            }
            object2 = ((URI)object4).toString();
            EncodeForUri.checkPercentEncoding((String)object2);
            if ("data".equals(((URI)object4).getScheme())) {
                try {
                    maker = DataURIScheme.decode((URI)object4);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new XPathException("Invalid URI using 'data' scheme: " + illegalArgumentException.getMessage());
                }
                if (maker instanceof BinaryResource) {
                    object = ((BinaryResource)((Object)maker)).getData();
                    object = new InputSource(new ByteArrayInputStream((byte[])object));
                    object4 = new SAXSource((InputSource)object);
                    object4.setSystemId((String)object2);
                } else {
                    assert (maker instanceof UnparsedTextResource);
                    object = new StringReader(((UnparsedTextResource)((Object)maker)).getContent());
                    object4 = new SAXSource(new InputSource((Reader)object));
                    object4.setSystemId((String)object2);
                }
            } else {
                object4 = new SAXSource();
                this.setSAXInputSource((SAXSource)object4, (String)object2);
            }
            if (uRIQueryParameters != null && (maker = uRIQueryParameters.getXMLReaderMaker()) != null) {
                ((SAXSource)object4).setXMLReader(maker.make());
            }
            if (((SAXSource)object4).getXMLReader() == null && this.a == null) {
                try {
                    ((SAXSource)object4).setXMLReader(Version.platform.loadParser());
                }
                catch (Exception exception) {
                    throw new XPathException(exception);
                }
            }
        }
        if (uRIQueryParameters != null) {
            object2 = uRIQueryParameters.getSpaceStrippingRule();
            object4 = AugmentedSource.makeAugmentedSource((Source)object4);
            ((AugmentedSource)object4).getParseOptions().setSpaceStrippingRule((SpaceStrippingRule)object2);
        }
        if (string3 != null) {
            object2 = string3;
            maker = new FilterFactory(this, (String)object2){
                private /* synthetic */ String a;
                private /* synthetic */ StandardURIResolver b;
                {
                    this.b = standardURIResolver;
                    this.a = string;
                }

                @Override
                public final /* synthetic */ Receiver makeFilter(Receiver object) {
                    Receiver receiver = object;
                    object = this;
                    return new IDFilter(receiver, object.a);
                }
            };
            object4 = AugmentedSource.makeAugmentedSource((Source)object4);
            ((AugmentedSource)object4).addFilter((FilterFactory)((Object)maker));
        }
        if (uRIQueryParameters != null && (object2 = uRIQueryParameters.getValidationMode()) != null) {
            object4 = AugmentedSource.makeAugmentedSource((Source)object4);
            ((AugmentedSource)object4).setSchemaValidationMode((Integer)object2);
        }
        if (uRIQueryParameters != null && (object2 = uRIQueryParameters.getXInclude()) != null) {
            object4 = AugmentedSource.makeAugmentedSource((Source)object4);
            ((AugmentedSource)object4).setXIncludeAware((Boolean)object2);
        }
        return object4;
    }

    protected Source getPTreeSource(String string, String string2) {
        throw new XPathException("PTree files can only be read using a Saxon-EE configuration");
    }

    protected void setSAXInputSource(SAXSource sAXSource, String string) {
        InputStream inputStream;
        if (string.startsWith("classpath:") && string.length() > 10 && (inputStream = this.getConfiguration().getDynamicLoader().getResourceAsStream(string.substring(10))) != null) {
            sAXSource.setInputSource(new InputSource(inputStream));
            sAXSource.setSystemId(string);
            return;
        }
        sAXSource.setInputSource(new InputSource(string));
        sAXSource.setSystemId(string);
    }
}

