/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.zip.GZIPInputStream;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.resource.BinaryResource;
import net.sf.saxon.resource.DataURIScheme;
import net.sf.saxon.resource.UnparsedTextResource;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;

public class StandardUnparsedTextResolver
implements UnparsedTextURIResolver {
    private boolean a = false;

    public void setDebugging(boolean bl2) {
        this.a = bl2;
    }

    @Override
    public Reader resolve(URI object, String object2, Configuration object3) {
        Object object4;
        Logger logger = ((Configuration)object3).getLogger();
        if (this.a) {
            logger.info("unparsed-text(): processing " + object);
            logger.info("unparsed-text(): requested encoding = " + (String)object2);
        }
        if (!((URI)object).isAbsolute()) {
            throw new XPathException("Resolved URI supplied to unparsed-text() is not absolute: " + ((URI)object).toString(), "FOUT1170");
        }
        InputStream inputStream = null;
        if (((URI)object).getScheme().equals("data")) {
            try {
                object3 = DataURIScheme.decode((URI)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XPathException("Invalid URI in 'data' scheme: " + illegalArgumentException.getMessage(), "FOUT1170");
            }
            if (!(object3 instanceof BinaryResource)) {
                assert (object3 instanceof UnparsedTextResource);
                return new StringReader(((UnparsedTextResource)object3).getContent());
            }
            object4 = ((BinaryResource)object3).getData();
            inputStream = new ByteArrayInputStream((byte[])object4);
            object = "utf-8";
            if (object2 == null) {
                object2 = object;
            }
            object3.getContentType();
        } else if (((URI)object).getScheme().equals("classpath")) {
            if ((object3 = ((Configuration)object3).getDynamicLoader().getResourceAsStream(((URI)object).toString().substring(10))) != null) {
                try {
                    if (object2 == null) {
                        object2 = "UTF-8";
                    }
                    return new InputStreamReader((InputStream)object3, (String)object2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new AssertionError((Object)unsupportedEncodingException);
                }
            }
        } else {
            try {
                object = ((URI)object).toURL();
            }
            catch (MalformedURLException malformedURLException) {
                XPathException xPathException = new XPathException("Cannot convert absolute URI to URL", malformedURLException);
                xPathException.setErrorCode("FOUT1170");
                throw xPathException;
            }
            try {
                object3 = ((URL)object).openConnection();
                ((URLConnection)object3).setRequestProperty("Accept-Encoding", "gzip");
                try {
                    ((URLConnection)object3).connect();
                }
                catch (IOException iOException) {
                    if (this.a) {
                        logger.error("unparsed-text(): connection failure. " + iOException.getMessage());
                    }
                    object = new XPathException("Failed to read input file", iOException);
                    ((XPathException)object).setErrorCode("FOUT1170");
                    throw object;
                }
                inputStream = ((URLConnection)object3).getInputStream();
                object = ((URLConnection)object3).getContentEncoding();
                if ("gzip".equals(object)) {
                    inputStream = new GZIPInputStream(inputStream);
                }
                if (this.a) {
                    logger.info("unparsed-text(): established connection " + ("gzip".equals(object) ? " (zipped)" : ""));
                }
                if (!((InputStream)inputStream).markSupported()) {
                    inputStream = new BufferedInputStream(inputStream);
                }
                boolean bl2 = false;
                if (!"file".equals(((URLConnection)object3).getURL().getProtocol())) {
                    object4 = ((URLConnection)object3).getContentType();
                    if (this.a) {
                        logger.info("unparsed-text(): content type = " + (String)object4);
                    }
                    if (object4 != null) {
                        int n2 = ((String)object4).indexOf(59);
                        Object object5 = n2 >= 0 ? ((String)object4).substring(0, n2) : object4;
                        object5 = ((String)object5).trim();
                        if (this.a) {
                            logger.info("unparsed-text(): media type = " + (String)object5);
                        }
                        bl2 = !(!((String)object5).startsWith("application/") && !((String)object5).startsWith("text/") || !((String)object5).endsWith("/xml") && !((String)object5).endsWith("+xml"));
                        String string = "";
                        n2 = ((String)object4).toLowerCase().indexOf("charset");
                        if (n2 >= 0) {
                            if ((n2 = ((String)object4).indexOf(61, n2 + 7)) >= 0) {
                                string = ((String)object4).substring(n2 + 1);
                            }
                            if ((n2 = string.indexOf(59)) > 0) {
                                string = string.substring(0, n2);
                            }
                            if ((n2 = string.indexOf(40)) > 0) {
                                string = string.substring(0, n2);
                            }
                            if ((n2 = string.indexOf(34)) > 0) {
                                string = string.substring(n2 + 1, string.indexOf(34, n2 + 2));
                            }
                            if (this.a) {
                                logger.info("unparsed-text(): charset = " + string.trim());
                            }
                            object2 = string.trim();
                        }
                    }
                }
                try {
                    if (object2 == null || bl2) {
                        object2 = StandardUnparsedTextResolver.inferStreamEncoding(inputStream, this.a ? logger : null);
                        if (this.a) {
                            logger.info("unparsed-text(): inferred encoding = " + (String)object2);
                        }
                    }
                }
                catch (IOException iOException) {
                    object2 = "UTF-8";
                }
            }
            catch (IOException iOException) {
                throw new XPathException(iOException.getMessage(), "FOUT1170");
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                throw new XPathException("Invalid encoding name: " + (String)object2, "FOUT1190");
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new XPathException("Invalid encoding name: " + (String)object2, "FOUT1190");
            }
        }
        object3 = Charset.forName((String)object2);
        CharsetDecoder charsetDecoder = ((Charset)object3).newDecoder();
        object4 = charsetDecoder;
        CharsetDecoder charsetDecoder2 = charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
        object4 = charsetDecoder2;
        object4 = charsetDecoder2.onUnmappableCharacter(CodingErrorAction.REPORT);
        return new BufferedReader(new InputStreamReader(inputStream, (CharsetDecoder)object4));
    }

    public static String inferStreamEncoding(InputStream object, Logger logger) {
        Object object2;
        ((InputStream)object).mark(100);
        Object object3 = new byte[100];
        int n2 = ((InputStream)object).read((byte[])object3, 0, 100);
        ((InputStream)object).reset();
        byte[] byArray = object3;
        object3 = logger;
        int n3 = n2;
        object = byArray;
        int n4 = n2 = object3 != null ? 1 : 0;
        if (n3 >= 2) {
            object2 = object[0];
            if ((object2 & 0xFF) == 254 && ((object2 = object[1]) & 0xFF) == 255) {
                if (n2 != 0) {
                    ((Logger)object3).info("unparsed-text(): found UTF-16 byte order mark");
                }
                return "UTF-16";
            }
            object2 = object[0];
            if ((object2 & 0xFF) == 255 && ((object2 = object[1]) & 0xFF) == 254) {
                if (n2 != 0) {
                    ((Logger)object3).info("unparsed-text(): found UTF-16LE byte order mark");
                }
                return "UTF-16LE";
            }
        }
        if (n3 >= 3 && ((object2 = object[0]) & 0xFF) == 239 && ((object2 = object[1]) & 0xFF) == 187 && ((object2 = object[2]) & 0xFF) == 191) {
            if (n2 != 0) {
                ((Logger)object3).info("unparsed-text(): found UTF-8 byte order mark");
            }
            return "UTF-8";
        }
        if (n3 >= 4) {
            object2 = object[0];
            if ((object2 & 0xFF) == 60 && ((object2 = object[1]) & 0xFF) == 63 && ((object2 = object[2]) & 0xFF) == 120 && ((object2 = object[3]) & 0xFF) == 109 && ((object2 = object[4]) & 0xFF) == 108) {
                if (n2 != 0) {
                    ((Logger)object3).info("unparsed-text(): found XML declaration");
                }
                FastStringBuffer fastStringBuffer = new FastStringBuffer(n3);
                for (int i2 = 0; i2 < n3; ++i2) {
                    fastStringBuffer.append((char)object[i2]);
                }
                String string = fastStringBuffer.toString();
                int n5 = string.indexOf("encoding");
                if (n5 >= 0) {
                    n5 += 8;
                    while (n5 < string.length() && " \n\r\t=\"'".indexOf(string.charAt(n5)) >= 0) {
                        ++n5;
                    }
                    fastStringBuffer.setLength(0);
                    while (n5 < string.length() && string.charAt(n5) != '\"' && string.charAt(n5) != '\'') {
                        fastStringBuffer.append(string.charAt(n5++));
                    }
                    if (n2 != 0) {
                        ((Logger)object3).info("unparsed-text(): encoding in XML declaration = " + fastStringBuffer.toString());
                    }
                    return fastStringBuffer.toString();
                }
                if (n2 != 0) {
                    ((Logger)object3).info("unparsed-text(): no encoding found in XML declaration");
                }
            }
        } else {
            if (n3 > 0 && object[0] == false && object[2] == false && object[4] == false && object[6] == false) {
                if (n2 != 0) {
                    ((Logger)object3).info("unparsed-text(): even-numbered bytes are zero, inferring UTF-16");
                }
                return "UTF-16";
            }
            if (n3 > 1 && object[1] == false && object[3] == false && object[5] == false && object[7] == false) {
                if (n2 != 0) {
                    ((Logger)object3).info("unparsed-text(): odd-numbered bytes are zero, inferring UTF-16LE");
                }
                return "UTF-16LE";
            }
        }
        if (n2 != 0) {
            ((Logger)object3).info("unparsed-text(): assuming fallback encoding (UTF-8)");
        }
        return "UTF-8";
    }
}

