/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.arrays;

import java.util.ArrayList;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.ma.arrays.ArrayFunctionSet;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public abstract class AbstractArrayItem
implements ArrayItem {
    private SequenceType a = null;

    @Override
    public OperandRole[] getOperandRoles() {
        return new OperandRole[]{OperandRole.SINGLE_ATOMIC};
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public AtomicSequence atomize() {
        ArrayList<AtomicValue> arrayList = new ArrayList<AtomicValue>(this.arrayLength());
        for (GroundedValue<?> groundedValue : this.members()) {
            groundedValue.iterate().forEachOrFail(object -> {
                object = object.atomize();
                object = object.iterator();
                while (object.hasNext()) {
                    AtomicValue atomicValue = (AtomicValue)object.next();
                    arrayList.add(atomicValue);
                }
            });
        }
        return new AtomicArray(arrayList);
    }

    @Override
    public AnnotationList getAnnotations() {
        return AnnotationList.EMPTY;
    }

    @Override
    public FunctionItemType getFunctionItemType() {
        return ArrayItemType.ANY_ARRAY_TYPE;
    }

    @Override
    public StructuredQName getFunctionName() {
        return null;
    }

    @Override
    public String getDescription() {
        return "array";
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public XPathContext makeNewContext(XPathContext xPathContext, ContextOriginator contextOriginator) {
        return xPathContext;
    }

    public GroundedValue<?> call(XPathContext object, Sequence[] sequenceArray) {
        object = (IntegerValue)sequenceArray[0].head();
        return this.get(ArrayFunctionSet.checkSubscript((IntegerValue)object) - 1);
    }

    @Override
    public boolean deepEquals(Function function, XPathContext xPathContext, AtomicComparer atomicComparer, int n2) {
        if (function instanceof ArrayItem) {
            function = (ArrayItem)function;
            if (this.arrayLength() != function.arrayLength()) {
                return false;
            }
            for (int i2 = 0; i2 < this.arrayLength(); ++i2) {
                if (DeepEqual.deepEqual(this.get(i2).iterate(), function.get(i2).iterate(), atomicComparer, xPathContext, n2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean effectiveBooleanValue() {
        throw new XPathException("Effective boolean value is not defined for arrays", "FORG0006");
    }

    @Override
    public String getStringValue() {
        throw new UnsupportedOperationException("An array does not have a string value");
    }

    @Override
    public CharSequence getStringValueCS() {
        throw new UnsupportedOperationException("An array does not have a string value");
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("array");
        expressionPresenter.emitAttribute("size", "" + this.arrayLength());
        for (GroundedValue<?> groundedValue : this.members()) {
            Literal.exportValue(groundedValue, expressionPresenter);
        }
        expressionPresenter.endElement();
    }

    @Override
    public boolean isTrustedResultType() {
        return false;
    }

    public String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
        fastStringBuffer.append("[");
        for (GroundedValue<?> groundedValue : this.members()) {
            if (fastStringBuffer.length() > 1) {
                fastStringBuffer.append(", ");
            }
            fastStringBuffer.append(groundedValue.toString());
        }
        fastStringBuffer.append("]");
        return fastStringBuffer.toString();
    }

    @Override
    public SequenceType getMemberType(TypeHierarchy typeHierarchy) {
        if (this.a == null) {
            if (this.isEmpty()) {
                this.a = SequenceType.makeSequenceType(ErrorType.getInstance(), 16384);
            } else {
                ItemType itemType = null;
                int n2 = 16384;
                for (GroundedValue<?> groundedValue : this.members()) {
                    if (itemType == null) {
                        itemType = SequenceTool.getItemType(groundedValue, typeHierarchy);
                        n2 = SequenceTool.getCardinality(groundedValue);
                        continue;
                    }
                    itemType = Type.getCommonSuperType(itemType, SequenceTool.getItemType(groundedValue, typeHierarchy));
                    n2 = Cardinality.union(n2, SequenceTool.getCardinality(groundedValue));
                }
                this.a = SequenceType.makeSequenceType(itemType, n2);
            }
        }
        return this.a;
    }
}

