/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.arrays;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Fold;
import net.sf.saxon.functions.FoldingFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.arrays.ArraySort;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.om.Chain;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntSet;

public class ArrayFunctionSet
extends BuiltInFunctionSet {
    public static ArrayFunctionSet THE_INSTANCE = new ArrayFunctionSet();

    public ArrayFunctionSet() {
        ArrayFunctionSet arrayFunctionSet = this;
        arrayFunctionSet.register("append", 2, ArrayAppend.class, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, AnyItemType.getInstance(), 0x800E000, null);
        SpecificFunctionType specificFunctionType = new SpecificFunctionType(new SequenceType[]{SequenceType.ANY_SEQUENCE}, SequenceType.SINGLE_BOOLEAN);
        arrayFunctionSet.register("filter", 2, ArrayFilter.class, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, specificFunctionType, 0x1004000, null);
        arrayFunctionSet.register("flatten", 1, ArrayFlatten.class, AnyItemType.getInstance(), 57344, 0, 0).arg(0, AnyItemType.getInstance(), 0x200E000, null);
        specificFunctionType = new SpecificFunctionType(new SequenceType[]{SequenceType.ANY_SEQUENCE, SequenceType.ANY_SEQUENCE}, SequenceType.ANY_SEQUENCE);
        arrayFunctionSet.register("fold-left", 3, ArrayFoldLeft.class, AnyItemType.getInstance(), 57344, 0, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, AnyItemType.getInstance(), 0x800E000, null).arg(2, specificFunctionType, 0x1004000, null);
        arrayFunctionSet.register("fold-right", 3, ArrayFoldRight.class, AnyItemType.getInstance(), 57344, 0, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, AnyItemType.getInstance(), 0x800E000, null).arg(2, specificFunctionType, 0x1004000, null);
        SpecificFunctionType specificFunctionType2 = new SpecificFunctionType(new SequenceType[]{SequenceType.ANY_SEQUENCE}, SequenceType.ANY_SEQUENCE);
        arrayFunctionSet.register("for-each", 2, ArrayForEach.class, AnyItemType.getInstance(), 57344, 0, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, specificFunctionType2, 0x1004000, null);
        arrayFunctionSet.register("for-each-pair", 3, ArrayForEachPair.class, AnyItemType.getInstance(), 57344, 0, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(2, specificFunctionType, 0x1004000, null);
        arrayFunctionSet.register("get", 2, ArrayGet.class, AnyItemType.getInstance(), 57344, 0, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.INTEGER, 0x2004000, null);
        arrayFunctionSet.register("head", 1, ArrayHead.class, AnyItemType.getInstance(), 57344, 0, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null);
        arrayFunctionSet.register("insert-before", 3, ArrayInsertBefore.class, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.INTEGER, 0x200E000, null).arg(2, AnyItemType.getInstance(), 0x800E000, null);
        arrayFunctionSet.register("join", 1, ArrayJoin.class, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x100E000, null);
        arrayFunctionSet.register("put", 3, ArrayPut.class, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.INTEGER, 0x100E000, null).arg(2, AnyItemType.getInstance(), 0x800E000, null);
        arrayFunctionSet.register("remove", 2, ArrayRemove.class, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.INTEGER, 0x200E000, null);
        arrayFunctionSet.register("reverse", 1, ArrayReverse.class, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null);
        arrayFunctionSet.register("size", 1, ArraySize.class, BuiltInAtomicType.INTEGER, 16384, 0, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null);
        specificFunctionType = new SpecificFunctionType(new SequenceType[]{SequenceType.ANY_SEQUENCE}, SequenceType.ATOMIC_SEQUENCE);
        arrayFunctionSet.register("sort", 1, ArraySort.class, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null);
        arrayFunctionSet.register("sort", 2, ArraySort.class, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.STRING, 0x2006000, null);
        arrayFunctionSet.register("sort", 3, ArraySort.class, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.STRING, 0x2006000, null).arg(2, specificFunctionType, 0x1004000, null);
        arrayFunctionSet.register("subarray", 2, ArraySubarray.class, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.INTEGER, 0x2004000, null);
        arrayFunctionSet.register("subarray", 3, ArraySubarray.class, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.INTEGER, 0x2004000, null).arg(2, BuiltInAtomicType.INTEGER, 0x2004000, null);
        arrayFunctionSet.register("tail", 1, ArrayTail.class, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null);
        arrayFunctionSet.register("_to-sequence", 1, ArrayToSequence.class, AnyItemType.getInstance(), 57344, 0, 0).arg(0, ArrayItemType.ANY_ARRAY_TYPE, 0x1004000, null);
        arrayFunctionSet.register("_from-sequence", 1, ArrayFromSequence.class, ArrayItemType.ANY_ARRAY_TYPE, 16384, 0, 0).arg(0, AnyItemType.getInstance(), 0x100E000, null);
    }

    public static ArrayFunctionSet getInstance() {
        return THE_INSTANCE;
    }

    @Override
    public String getNamespace() {
        return "http://www.w3.org/2005/xpath-functions/array";
    }

    @Override
    public String getConventionalPrefix() {
        return "array";
    }

    public static int checkSubscript(IntegerValue integerValue) {
        int n2 = integerValue.asSubscript();
        if (n2 <= 0) {
            throw new XPathException("Array subscript " + integerValue.getStringValue() + " is out of range", "FOAY0001");
        }
        return n2;
    }

    public static class ArrayFromSequence
    extends FoldingFunction {
        public ArrayItem call(XPathContext xPathContext, Sequence[] sequenceArray) {
            return SimpleArrayItem.makeSimpleArrayItem(sequenceArray[0].iterate());
        }

        @Override
        public Fold getFold(XPathContext xPathContext, Sequence ... sequenceArray) {
            return new Fold(this){
                private List<GroundedValue<?>> a = new ArrayList();
                private /* synthetic */ ArrayFromSequence b;
                {
                    this.b = arrayFromSequence;
                }

                @Override
                public final void processItem(Item<?> item) {
                    this.a.add(item);
                }

                @Override
                public final boolean isFinished() {
                    return false;
                }

                public final /* synthetic */ Sequence result() {
                    1 var1_1 = this;
                    return new SimpleArrayItem(var1_1.a);
                }
            };
        }
    }

    public static class ArrayToSequence
    extends SystemFunction {
        @Override
        public Sequence<?> call(XPathContext object, Sequence[] sequenceArray) {
            object = (ArrayItem)sequenceArray[0].head();
            return ArrayToSequence.toSequence((ArrayItem)object);
        }

        public static Sequence<?> toSequence(ArrayItem object) {
            ArrayList arrayList = new ArrayList();
            for (Sequence sequence : object.members()) {
                arrayList.add(sequence.materialize());
            }
            return new Chain(arrayList);
        }
    }

    public static class ArrayTail
    extends SystemFunction {
        public ArrayItem call(XPathContext object, Sequence[] sequenceArray) {
            object = (ArrayItem)sequenceArray[0].head();
            assert (object != null);
            if (object.arrayLength() <= 0) {
                throw new XPathException("Argument to array:tail is an empty array", "FOAY0001");
            }
            return object.remove(0);
        }
    }

    public static class ArraySubarray
    extends SystemFunction {
        public ArrayItem call(XPathContext object, Sequence[] object2) {
            int n2;
            object = (ArrayItem)object2[0].head();
            assert (object != null);
            int n3 = ArrayFunctionSet.checkSubscript((IntegerValue)object2[1].head());
            if (((Sequence[])object2).length == 3) {
                int n4 = (object2 = (IntegerValue)object2[2].head()).signum();
                if (n4 < 0) {
                    throw new XPathException("Specified length of subarray is less than zero", "FOAY0002");
                }
                n2 = n4 == 0 ? 0 : ArrayFunctionSet.checkSubscript((IntegerValue)object2);
            } else {
                n2 = object.arrayLength() - n3 + 1;
            }
            if (n3 <= 0) {
                throw new XPathException("Start position is less than one", "FOAY0001");
            }
            if (n3 > object.arrayLength() + 1) {
                throw new XPathException("Start position is out of bounds", "FOAY0001");
            }
            if (n3 + n2 > object.arrayLength() + 1) {
                throw new XPathException("Specified length of subarray is too great for start position given", "FOAY0001");
            }
            return object.subArray(n3 - 1, n3 + n2 - 1);
        }
    }

    public static class ArraySize
    extends SystemFunction {
        public IntegerValue call(XPathContext object, Sequence[] sequenceArray) {
            object = (ArrayItem)sequenceArray[0].head();
            assert (object != null);
            return new Int64Value(object.arrayLength());
        }
    }

    public static class ArrayReverse
    extends SystemFunction {
        public ArrayItem call(XPathContext object, Sequence[] object2) {
            object = (ArrayItem)object2[0].head();
            assert (object != null);
            object2 = new ArrayList(1);
            for (int i2 = 0; i2 < object.arrayLength(); ++i2) {
                Object object3 = object;
                object2.add(object3.get(object3.arrayLength() - i2 - 1));
            }
            return new SimpleArrayItem((List<GroundedValue<?>>)object2);
        }
    }

    public static class ArrayRemove
    extends SystemFunction {
        public ArrayItem call(XPathContext object, Sequence[] object2) {
            object = (ArrayItem)object2[0].head();
            if (object2[1] instanceof IntegerValue) {
                int n2 = ArrayFunctionSet.checkSubscript((IntegerValue)object2[1]);
                if (n2 > object.arrayLength()) {
                    throw new XPathException("Position " + n2 + " is not in range", "FOAY0001");
                }
                return object.remove(n2 - 1);
            }
            IntHashSet intHashSet = new IntHashSet();
            object2 = object2[1].iterate();
            object2.forEachOrFail(arg_0 -> ArrayRemove.a((ArrayItem)object, intHashSet, arg_0));
            return object.removeSeveral(intHashSet);
        }

        private static /* synthetic */ void a(ArrayItem arrayItem, IntSet intSet, IntegerValue integerValue) {
            int n2 = ArrayFunctionSet.checkSubscript(integerValue);
            if (n2 > arrayItem.arrayLength()) {
                throw new XPathException("Position " + n2 + " is not in range", "FOAY0001");
            }
            intSet.add(n2 - 1);
        }
    }

    public static class ArrayPut
    extends SystemFunction {
        public ArrayItem call(XPathContext object, Sequence[] object2) {
            object = (ArrayItem)object2[0].head();
            int n2 = ArrayFunctionSet.checkSubscript((IntegerValue)object2[1].head()) - 1;
            if (n2 > object.arrayLength()) {
                throw new XPathException("Array subscript " + n2 + " exceeds length of array (" + object.arrayLength() + ")", "FOAY0001");
            }
            object2 = object2[2].materialize();
            return object.put(n2, (GroundedValue<?>)object2);
        }
    }

    public static class ArrayJoin
    extends SystemFunction {
        public ArrayItem call(XPathContext object, Sequence[] object2) {
            ArrayItem arrayItem;
            object = object2[0].iterate();
            object2 = SimpleArrayItem.EMPTY_ARRAY;
            while ((arrayItem = (ArrayItem)object.next()) != null) {
                object2 = object2.concat(arrayItem);
            }
            return object2;
        }
    }

    public static class ArrayInsertBefore
    extends SystemFunction {
        public ArrayItem call(XPathContext object, Sequence[] object2) {
            object = (ArrayItem)object2[0].head();
            assert (object != null);
            int n2 = ArrayFunctionSet.checkSubscript((IntegerValue)object2[1].head()) - 1;
            if (n2 < 0 || n2 > object.arrayLength()) {
                throw new XPathException("Specified position is not in range", "FOAY0001");
            }
            object2 = object2[2];
            return object.insert(n2, object2.materialize());
        }
    }

    public static class ArrayHead
    extends SystemFunction {
        @Override
        public Sequence<?> call(XPathContext object, Sequence[] sequenceArray) {
            object = (ArrayItem)sequenceArray[0].head();
            assert (object != null);
            if (object.arrayLength() == 0) {
                throw new XPathException("Argument to array:head is an empty array", "FOAY0001");
            }
            return object.get(0);
        }
    }

    public static class ArrayGet
    extends SystemFunction {
        @Override
        public Sequence<?> call(XPathContext object, Sequence[] object2) {
            object = (ArrayItem)object2[0].head();
            int n2 = ArrayFunctionSet.checkSubscript((IntegerValue)(object2 = (IntegerValue)object2[1].head()));
            if (n2 > object.arrayLength()) {
                throw new XPathException("Array subscript " + n2 + " exceeds length of array (" + object.arrayLength() + ")", "FOAY0001");
            }
            return object.get(n2 - 1);
        }
    }

    public static class ArrayForEachPair
    extends SystemFunction {
        public ArrayItem call(XPathContext xPathContext, Sequence[] object) {
            ArrayItem arrayItem = (ArrayItem)object[0].head();
            assert (arrayItem != null);
            ArrayItem arrayItem2 = (ArrayItem)object[1].head();
            assert (arrayItem2 != null);
            object = (Function)object[2].head();
            ArrayList arrayList = new ArrayList(1);
            for (int i2 = 0; i2 < arrayItem.arrayLength() && i2 < arrayItem2.arrayLength(); ++i2) {
                arrayList.add(ArrayForEachPair.dynamicCall((Function)object, xPathContext, new Sequence[]{arrayItem.get(i2), arrayItem2.get(i2)}).materialize());
            }
            return new SimpleArrayItem(arrayList);
        }
    }

    public static class ArrayForEach
    extends SystemFunction {
        public ArrayItem call(XPathContext xPathContext, Sequence[] object) {
            ArrayItem arrayItem = (ArrayItem)object[0].head();
            assert (arrayItem != null);
            object = (Function)object[1].head();
            ArrayList arrayList = new ArrayList(1);
            for (int i2 = 0; i2 < arrayItem.arrayLength(); ++i2) {
                arrayList.add(ArrayForEach.dynamicCall((Function)object, xPathContext, new GroundedValue[]{arrayItem.get(i2)}).materialize());
            }
            return new SimpleArrayItem(arrayList);
        }
    }

    public static class ArrayFoldRight
    extends SystemFunction {
        @Override
        public Sequence<?> call(XPathContext xPathContext, Sequence[] object) {
            ArrayItem arrayItem = (ArrayItem)object[0].head();
            assert (arrayItem != null);
            Sequence<?> sequence = object[1];
            object = (Function)object[2].head();
            for (int i2 = arrayItem.arrayLength() - 1; i2 >= 0; --i2) {
                sequence = ArrayFoldRight.dynamicCall((Function)object, xPathContext, new Sequence[]{arrayItem.get(i2), sequence});
            }
            return sequence;
        }
    }

    public static class ArrayFoldLeft
    extends SystemFunction {
        @Override
        public Sequence<?> call(XPathContext xPathContext, Sequence[] object) {
            ArrayItem arrayItem = (ArrayItem)object[0].head();
            assert (arrayItem != null);
            int n2 = arrayItem.arrayLength();
            Sequence<?> sequence = object[1];
            object = (Function)object[2].head();
            for (int i2 = 0; i2 < n2; ++i2) {
                sequence = ArrayFoldLeft.dynamicCall((Function)object, xPathContext, new Sequence[]{sequence, arrayItem.get(i2)});
            }
            return sequence;
        }
    }

    public static class ArrayFlatten
    extends SystemFunction {
        private void a(Sequence<?> sequence, List<Item<?>> list) {
            sequence.iterate().forEachOrFail(object -> {
                if (object instanceof ArrayItem) {
                    for (Sequence sequence : ((ArrayItem)((Object)object)).members()) {
                        this.a(sequence, list);
                    }
                    return;
                }
                list.add(object);
            });
        }

        @Override
        public Sequence<?> call(XPathContext object, Sequence[] sequenceArray) {
            object = new ArrayList();
            this.a(sequenceArray[0], (List<Item<?>>)object);
            return SequenceExtent.makeSequenceExtent(object);
        }
    }

    public static class ArrayFilter
    extends SystemFunction {
        public ArrayItem call(XPathContext xPathContext, Sequence[] object) {
            ArrayItem arrayItem = (ArrayItem)object[0].head();
            assert (arrayItem != null);
            object = (Function)object[1].head();
            ArrayList arrayList = new ArrayList(1);
            for (int i2 = 0; i2 < arrayItem.arrayLength(); ++i2) {
                if (!((BooleanValue)ArrayFilter.dynamicCall((Function)object, xPathContext, new Sequence[]{arrayItem.get(i2)}).head()).getBooleanValue()) continue;
                arrayList.add(arrayItem.get(i2));
            }
            return new SimpleArrayItem(arrayList);
        }
    }

    public static class ArrayAppend
    extends SystemFunction {
        public ArrayItem call(XPathContext object, Sequence[] sequenceArray) {
            object = (ArrayItem)sequenceArray[0].head();
            assert (object != null);
            return ArrayAppend.append((ArrayItem)object, sequenceArray[1]);
        }

        public static ArrayItem append(ArrayItem arrayItem, Sequence<?> simpleArrayItem) {
            ArrayList arrayList = new ArrayList(1);
            arrayList.add(simpleArrayItem.materialize());
            simpleArrayItem = new SimpleArrayItem(arrayList);
            return arrayItem.concat(simpleArrayItem);
        }
    }
}

