/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.arrays;

import java.util.Optional;
import java.util.function.Function;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class ArrayItemType
extends AnyFunctionType {
    public static final ArrayItemType ANY_ARRAY_TYPE = new ArrayItemType(SequenceType.ANY_SEQUENCE);
    public static final SequenceType SINGLE_ARRAY = SequenceType.makeSequenceType(ANY_ARRAY_TYPE, 16384);
    private SequenceType a;

    public ArrayItemType(SequenceType sequenceType) {
        this.a = sequenceType;
    }

    @Override
    public Genre getGenre() {
        return Genre.ARRAY;
    }

    public SequenceType getMemberType() {
        return this.a;
    }

    @Override
    public boolean isMapType() {
        return false;
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public String getAlphaCode() {
        return "FA";
    }

    @Override
    public boolean isAtomizable(TypeHierarchy typeHierarchy) {
        return true;
    }

    @Override
    public PlainType getAtomizedItemType() {
        return this.a.getPrimaryType().getAtomizedItemType();
    }

    public int getArity() {
        return 1;
    }

    @Override
    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{BuiltInAtomicType.INTEGER.one()};
    }

    @Override
    public boolean matches(Item object, TypeHierarchy typeHierarchy) {
        if (!(object instanceof ArrayItem)) {
            return false;
        }
        if (this == ANY_ARRAY_TYPE) {
            return true;
        }
        for (Sequence sequence : ((ArrayItem)((Object)object)).members()) {
            if (this.a.matches(sequence, typeHierarchy)) continue;
            return false;
        }
        return true;
    }

    @Override
    public SequenceType getResultType() {
        return this.a;
    }

    @Override
    public String toString() {
        return this.a(SequenceType::toString);
    }

    private String a(Function<SequenceType, String> function) {
        if (this.equals(ANY_ARRAY_TYPE)) {
            return "array(*)";
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
        fastStringBuffer.append("array(");
        fastStringBuffer.append(function.apply(this.a));
        fastStringBuffer.append(")");
        return fastStringBuffer.toString();
    }

    @Override
    public String toExportString() {
        return this.a(SequenceType::toExportString);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ArrayItemType) {
            object = (ArrayItemType)object;
            return this.a.equals(((ArrayItemType)object).a);
        }
        return false;
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    @Override
    public int relationship(FunctionItemType functionItemType, TypeHierarchy typeHierarchy) {
        if (functionItemType == AnyFunctionType.getInstance()) {
            return 2;
        }
        if (this.equals(functionItemType)) {
            return 0;
        }
        if (functionItemType == ANY_ARRAY_TYPE) {
            return 2;
        }
        if (functionItemType.isMapType()) {
            return 4;
        }
        if (functionItemType instanceof ArrayItemType) {
            functionItemType = (ArrayItemType)functionItemType;
            int n2 = typeHierarchy.sequenceTypeRelationship(this.a, ((ArrayItemType)functionItemType).a);
            if (n2 == 4) {
                return 3;
            }
            return n2;
        }
        return 4;
    }

    @Override
    public Expression makeFunctionSequenceCoercer(Expression expression, RoleDiagnostic roleDiagnostic) {
        return expression;
    }

    @Override
    public Optional<String> explainMismatch(Item object, TypeHierarchy object2) {
        if (object instanceof ArrayItem) {
            for (int i2 = 0; i2 < ((ArrayItem)object).arrayLength(); ++i2) {
                try {
                    GroundedValue<?> groundedValue = ((ArrayItem)object).get(i2);
                    if (this.a.matches(groundedValue, (TypeHierarchy)object2)) continue;
                    object = "The " + RoleDiagnostic.ordinal(i2 + 1) + " member of the supplied array {" + Err.depictSequence(groundedValue) + "} does not match the required member type " + this.a;
                    if (((Optional)(object2 = this.a.explainMismatch(groundedValue, (TypeHierarchy)object2))).isPresent()) {
                        object = (String)object + ". " + (String)((Optional)object2).get();
                    }
                    return Optional.of(object);
                }
                catch (XPathException xPathException) {
                    return Optional.empty();
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public String generateJavaScriptItemTypeTest(ItemType object, int n2) {
        if (this == ANY_ARRAY_TYPE) {
            return "return SaxonJS.U.isArray(item)";
        }
        if (n2 == 1) {
            object = new FastStringBuffer(256);
            ((FastStringBuffer)object).append("function v(item) {" + this.a.getPrimaryType().generateJavaScriptItemTypeTest(AnyItemType.getInstance(), n2) + "};");
            ((FastStringBuffer)object).append(Cardinality.generateJavaScriptChecker(this.a.getCardinality()));
            ((FastStringBuffer)object).append("return SaxonJS.U.isArray(item) && SaxonJS.U.ForArray(item.value).every(function(seq){return c(seq.length) && SaxonJS.U.ForArray(seq).every(v)});");
            return ((FastStringBuffer)object).toString();
        }
        object = new FastStringBuffer(256);
        ((FastStringBuffer)object).append("function v(item) {" + this.a.getPrimaryType().generateJavaScriptItemTypeTest(AnyItemType.getInstance(), n2) + "};");
        ((FastStringBuffer)object).append(Cardinality.generateJavaScriptChecker(this.a.getCardinality()));
        ((FastStringBuffer)object).append("return SaxonJS.U.isConstrainedArray(item, v, c);");
        return ((FastStringBuffer)object).toString();
    }
}

