/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.arrays;

import java.util.Arrays;
import net.sf.saxon.ma.arrays.AbstractArrayItem;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.ma.parray.ImmList;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.z.IntSet;

public class ImmutableArrayItem
extends AbstractArrayItem {
    private ImmList<GroundedValue<?>> a;

    public ImmutableArrayItem(SimpleArrayItem simpleArrayItem) {
        this.a = ImmList.fromList(simpleArrayItem.getMembers());
    }

    private ImmutableArrayItem(ImmList<GroundedValue<?>> immList) {
        this.a = immList;
    }

    @Override
    public GroundedValue<?> get(int n2) {
        if (n2 < 0 || n2 >= this.a.size()) {
            throw new XPathException("Array index (" + (n2 + 1) + ") out of range (1 to " + this.a.size() + ")", "FOAY0001");
        }
        return this.a.get(n2);
    }

    public ArrayItem put(int n2, GroundedValue groundedValue) {
        if (n2 < 0 || n2 >= this.a.size()) {
            throw new XPathException("Array index (" + (n2 + 1) + ") out of range (1 to " + this.a.size() + ")", "FOAY0001");
        }
        ImmList<GroundedValue<?>> immList = this.a.replace(n2, groundedValue);
        if (immList == this.a) {
            return this;
        }
        return new ImmutableArrayItem(immList);
    }

    @Override
    public ArrayItem insert(int n2, GroundedValue<?> groundedValue) {
        ImmList<GroundedValue<?>> immList = this.a.insert(n2, groundedValue);
        return new ImmutableArrayItem(immList);
    }

    @Override
    public int arrayLength() {
        return this.a.size();
    }

    @Override
    public boolean isEmpty() {
        return this.a.isEmpty();
    }

    @Override
    public Iterable<GroundedValue<?>> members() {
        return this.a;
    }

    @Override
    public ArrayItem subArray(int n2, int n3) {
        return new ImmutableArrayItem(this.a.subList(n2, n3));
    }

    @Override
    public ArrayItem concat(ArrayItem iterable) {
        if (iterable.arrayLength() == 0) {
            return this;
        }
        iterable = iterable instanceof ImmutableArrayItem ? ((ImmutableArrayItem)iterable).a : new ImmutableArrayItem((SimpleArrayItem)((SimpleArrayItem)iterable)).a;
        iterable = this.a.appendList((ImmList<GroundedValue<?>>)iterable);
        return new ImmutableArrayItem((ImmList<GroundedValue<?>>)iterable);
    }

    @Override
    public ArrayItem remove(int n2) {
        ImmList<GroundedValue<?>> immList = this.a.remove(n2);
        if (immList == this.a) {
            return this;
        }
        return new ImmutableArrayItem(immList);
    }

    @Override
    public ArrayItem removeSeveral(IntSet immList) {
        int[] nArray = new int[immList.size()];
        int n2 = 0;
        immList = immList.iterator();
        while (immList.hasNext()) {
            nArray[n2++] = immList.next();
        }
        Arrays.sort(nArray);
        immList = this.a;
        for (n2 = nArray.length - 1; n2 >= 0; --n2) {
            immList = immList.remove(nArray[n2]);
        }
        if (immList == this.a) {
            return this;
        }
        return new ImmutableArrayItem(immList);
    }
}

