/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.arrays;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.ma.arrays.AbstractArrayItem;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ImmutableArrayItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.ExternalObject;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.z.IntSet;

public class SimpleArrayItem
extends AbstractArrayItem
implements ArrayItem {
    public static final SimpleArrayItem EMPTY_ARRAY = new SimpleArrayItem(new ArrayList());
    private List<GroundedValue<?>> a;
    private boolean b = false;
    private SequenceType c = null;

    public SimpleArrayItem(List<GroundedValue<?>> list) {
        this.a = list;
    }

    public static SimpleArrayItem makeSimpleArrayItem(SequenceIterator<?> object) {
        ArrayList arrayList = new ArrayList();
        object.forEachOrFail(item -> {
            if (item.getClass().getName().equals("com.saxonica.functions.extfn.ArrayMemberValue")) {
                arrayList.add((GroundedValue)((ExternalObject)item).getObject());
                return;
            }
            arrayList.add(item);
        });
        object = new SimpleArrayItem(arrayList);
        new SimpleArrayItem(arrayList).b = true;
        return object;
    }

    @Override
    public OperandRole[] getOperandRoles() {
        return new OperandRole[]{OperandRole.SINGLE_ATOMIC};
    }

    public void makeGrounded() {
        if (!this.b) {
            SimpleArrayItem simpleArrayItem = this;
            synchronized (simpleArrayItem) {
                for (int i2 = 0; i2 < this.a.size(); ++i2) {
                    List<GroundedValue<?>> list = this.a;
                    list.set(i2, ((Sequence)list.get(i2)).materialize());
                }
                this.b = true;
                return;
            }
        }
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public AnnotationList getAnnotations() {
        return AnnotationList.EMPTY;
    }

    @Override
    public GroundedValue<?> get(int n2) {
        if (n2 < 0 || n2 >= this.a.size()) {
            throw new XPathException("Array index (" + (n2 + 1) + ") out of range (1 to " + this.a.size() + ")", "FOAY0001");
        }
        return this.a.get(n2);
    }

    public ArrayItem put(int n2, GroundedValue groundedValue) {
        ImmutableArrayItem immutableArrayItem = new ImmutableArrayItem(this);
        return immutableArrayItem.put(n2, groundedValue);
    }

    @Override
    public int arrayLength() {
        return this.a.size();
    }

    @Override
    public boolean isEmpty() {
        return this.a.isEmpty();
    }

    @Override
    public Iterable<GroundedValue<?>> members() {
        return this.a;
    }

    @Override
    public ArrayItem removeSeveral(IntSet intSet) {
        ImmutableArrayItem immutableArrayItem = new ImmutableArrayItem(this);
        return immutableArrayItem.removeSeveral(intSet);
    }

    @Override
    public ArrayItem remove(int n2) {
        ImmutableArrayItem immutableArrayItem = new ImmutableArrayItem(this);
        return immutableArrayItem.remove(n2);
    }

    @Override
    public ArrayItem subArray(int n2, int n3) {
        return new SimpleArrayItem(this.a.subList(n2, n3));
    }

    @Override
    public ArrayItem insert(int n2, GroundedValue<?> groundedValue) {
        ImmutableArrayItem immutableArrayItem = new ImmutableArrayItem(this);
        return immutableArrayItem.insert(n2, groundedValue);
    }

    @Override
    public ArrayItem concat(ArrayItem arrayItem) {
        ImmutableArrayItem immutableArrayItem = new ImmutableArrayItem(this);
        return immutableArrayItem.concat(arrayItem);
    }

    public List<GroundedValue<?>> getMembers() {
        return this.a;
    }

    @Override
    public String toShortString() {
        int n2 = this.getLength();
        if (n2 == 0) {
            return "[]";
        }
        if (n2 > 5) {
            return "[(:size " + n2 + ":)]";
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
        fastStringBuffer.append("[");
        for (GroundedValue<?> groundedValue : this.members()) {
            fastStringBuffer.append(Err.depictSequence(groundedValue).toString().trim());
            fastStringBuffer.append(", ");
        }
        if (n2 == 1) {
            fastStringBuffer.append("]");
        } else {
            FastStringBuffer fastStringBuffer2 = fastStringBuffer;
            fastStringBuffer2.setCharAt(fastStringBuffer2.length() - 2, ']');
        }
        return fastStringBuffer.toString().trim();
    }
}

