/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.arrays;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.oper.OperandArray;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class SquareArrayConstructor
extends Expression {
    private OperandArray a;

    public SquareArrayConstructor(List<Expression> object) {
        Expression[] expressionArray = object.toArray(new Expression[0]);
        object = object.iterator();
        while (object.hasNext()) {
            Expression expression = (Expression)object.next();
            this.adoptChildExpression(expression);
        }
        this.setOperanda(new OperandArray((Expression)this, expressionArray, OperandRole.NAVIGATE));
    }

    protected void setOperanda(OperandArray operandArray) {
        this.a = operandArray;
    }

    public OperandArray getOperanda() {
        return this.a;
    }

    public Operand getOperand(int n2) {
        return this.a.getOperand(n2);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.a.operands();
    }

    @Override
    public String getExpressionName() {
        return "SquareArrayConstructor";
    }

    @Override
    public String getStreamerName() {
        return "ArrayBlock";
    }

    @Override
    public int computeSpecialProperties() {
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SquareArrayConstructor)) {
            return false;
        }
        if (((SquareArrayConstructor)(object = (SquareArrayConstructor)object)).getOperanda().getNumberOfOperands() != this.getOperanda().getNumberOfOperands()) {
            return false;
        }
        for (int i2 = 0; i2 < this.getOperanda().getNumberOfOperands(); ++i2) {
            if (this.getOperanda().getOperand(i2).equals(((SquareArrayConstructor)object).getOperanda().getOperand(i2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int computeHashCode() {
        int n2 = -2020896096;
        for (Operand operand : ((Expression)this).operands()) {
            n2 ^= operand.getChildExpression().hashCode();
        }
        return n2;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        if ((object = super.typeCheck(expressionVisitor, (ContextItemStaticInfo)object)) != this) {
            return object;
        }
        return this.a(expressionVisitor);
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        if ((object = super.optimize(expressionVisitor, (ContextItemStaticInfo)object)) != this) {
            return object;
        }
        return this.a(expressionVisitor);
    }

    private Expression a(ExpressionVisitor expressionVisitor) {
        for (Operand operand : ((Expression)this).operands()) {
            if (operand.getChildExpression() instanceof Literal) continue;
            return this;
        }
        try {
            return Literal.makeLiteral(((Expression)this).evaluateItem(expressionVisitor.makeDynamicContext()), this);
        }
        catch (XPathException xPathException) {
            return this;
        }
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(this.getOperanda().getNumberOfOperands());
        for (Operand operand : ((Expression)this).operands()) {
            arrayList.add(operand.getChildExpression().copy(rebindingMap));
        }
        SquareArrayConstructor squareArrayConstructor = new SquareArrayConstructor(arrayList);
        ExpressionTool.copyLocationInfo(this, squareArrayConstructor);
        return squareArrayConstructor;
    }

    @Override
    public final ItemType getItemType() {
        ItemType itemType = null;
        int n2 = 16384;
        TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
        for (Expression expression : this.getOperanda().operandExpressions()) {
            if (itemType == null) {
                itemType = expression.getItemType();
                n2 = expression.getCardinality();
                continue;
            }
            itemType = Type.getCommonSuperType(itemType, expression.getItemType(), typeHierarchy);
            n2 = Cardinality.union(n2, expression.getCardinality());
        }
        if (itemType == null) {
            itemType = ErrorType.getInstance();
        }
        return new ArrayItemType(SequenceType.makeSequenceType(itemType, n2));
    }

    @Override
    public UType getStaticUType(UType uType) {
        return UType.FUNCTION;
    }

    @Override
    public final int computeCardinality() {
        return 16384;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("arrayBlock", this);
        for (Operand operand : ((Expression)this).operands()) {
            operand.getChildExpression().export(expressionPresenter);
        }
        expressionPresenter.endElement();
    }

    @Override
    public String toShortString() {
        int n2 = this.getOperanda().getNumberOfOperands();
        switch (n2) {
            case 0: {
                return "[]";
            }
            case 1: {
                return "[" + this.getOperanda().getOperand(0).getChildExpression().toShortString() + "]";
            }
            case 2: {
                return "[" + this.getOperanda().getOperand(0).getChildExpression().toShortString() + ", " + this.getOperanda().getOperand(1).getChildExpression().toShortString() + "]";
            }
        }
        return "[" + this.getOperanda().getOperand(0).getChildExpression().toShortString() + ", ...]";
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    public Item evaluateItem(XPathContext xPathContext) {
        ArrayList arrayList = new ArrayList(this.getOperanda().getNumberOfOperands());
        for (Iterable<Operand> iterable : ((Expression)this).operands()) {
            iterable = ExpressionTool.eagerEvaluate(iterable.getChildExpression(), xPathContext);
            arrayList.add((GroundedValue<?>)iterable);
        }
        return new SimpleArrayItem(arrayList);
    }
}

