/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.json;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.function.IntPredicate;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.UnparsedTextFunction;
import net.sf.saxon.ma.json.ParseJsonFn;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.z.IntSetPredicate;

public class JsonDoc
extends SystemFunction {
    @Override
    public Sequence<?> call(XPathContext xPathContext, Sequence[] object) {
        Object object2 = object[0].head();
        if (object2 == null) {
            return EmptySequence.getInstance();
        }
        object2 = object2.getStringValue();
        Object object3 = xPathContext.getConfiguration();
        IntPredicate intPredicate = IntSetPredicate.ALWAYS_TRUE;
        object2 = UnparsedTextFunction.getAbsoluteURI(object2, this.getStaticBaseUriString(), xPathContext);
        String string = "UTF-8";
        try {
            object3 = xPathContext.getController().getUnparsedTextURIResolver().resolve((URI)object2, string, (Configuration)object3);
        }
        catch (XPathException xPathException) {
            object3 = xPathException;
            xPathException.maybeSetErrorCode("FOUT1170");
            throw object3;
        }
        try {
            object3 = UnparsedTextFunction.readFile(intPredicate, (Reader)object3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            XPathException xPathException = new XPathException("Unknown encoding " + Err.wrap(string), unsupportedEncodingException);
            xPathException.setErrorCode("FOUT1190");
            throw xPathException;
        }
        catch (IOException iOException) {
            throw UnparsedTextFunction.handleIOError(object2, iOException, xPathContext);
        }
        if (this.getArity() == 2) {
            object = (MapItem)object[1].head();
            object = this.getDetails().optionDetails.processSuppliedOptions((MapItem)object, xPathContext);
        } else {
            object = ParseJsonFn.OPTION_DETAILS.getDefaultOptions();
        }
        object = ParseJsonFn.parse(object3.toString(), object, xPathContext);
        if (object == null) {
            return EmptySequence.getInstance();
        }
        return object;
    }
}

