/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.json;

import java.util.ArrayList;
import java.util.Stack;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.ma.json.JsonHandler;
import net.sf.saxon.ma.map.DictionaryMap;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;

public class JsonHandlerMap
extends JsonHandler {
    private Stack<Sequence<?>> a;
    protected Stack<String> keys;

    public JsonHandlerMap(XPathContext xPathContext, int n2) {
        this.setContext(xPathContext);
        this.a = new Stack();
        this.keys = new Stack();
        this.escape = (n2 & 1) != 0;
        this.charChecker = xPathContext.getConfiguration().getValidCharacterChecker();
    }

    @Override
    public Sequence<?> getResult() {
        return this.a.peek();
    }

    @Override
    public boolean setKey(String object, String string) {
        this.keys.push(string);
        object = (MapItem)this.a.peek();
        return object.get(new StringValue(string)) != null;
    }

    @Override
    public void startArray() {
        SimpleArrayItem simpleArrayItem = new SimpleArrayItem(new ArrayList());
        this.a.push(simpleArrayItem);
    }

    @Override
    public void endArray() {
        ArrayItem arrayItem = (ArrayItem)this.a.pop();
        if (this.a.empty()) {
            this.a.push(arrayItem);
            return;
        }
        this.a(arrayItem);
    }

    @Override
    public void startMap() {
        DictionaryMap dictionaryMap = new DictionaryMap();
        this.a.push(dictionaryMap);
    }

    @Override
    public void endMap() {
        DictionaryMap dictionaryMap = (DictionaryMap)this.a.pop();
        if (this.a.empty()) {
            this.a.push(dictionaryMap);
            return;
        }
        this.a(dictionaryMap);
    }

    private void a(GroundedValue<?> groundedValue) {
        if (this.a.empty()) {
            this.a.push(groundedValue);
            return;
        }
        if (this.a.peek() instanceof ArrayItem) {
            SimpleArrayItem simpleArrayItem = (SimpleArrayItem)this.a.peek();
            simpleArrayItem.getMembers().add(groundedValue.materialize());
            return;
        }
        DictionaryMap dictionaryMap = (DictionaryMap)this.a.peek();
        dictionaryMap.initialPut(this.keys.pop(), groundedValue);
    }

    @Override
    public void writeNumeric(String string, double d2) {
        this.a(new DoubleValue(d2));
    }

    @Override
    public void writeString(String string) {
        this.a(new StringValue(this.reEscape(string)));
    }

    @Override
    public void writeBoolean(boolean bl2) {
        this.a(BooleanValue.get(bl2));
    }

    @Override
    public void writeNull() {
        this.a(EmptySequence.getInstance());
    }
}

