/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.json;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.lib.StandardEntityResolver;
import net.sf.saxon.ma.json.JsonHandler;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JsonHandlerXML
extends JsonHandler {
    private NamespaceReducer a;
    private Builder b;
    private Stack<String> c;
    private Stack<Boolean> d = new Stack();
    public boolean allowAnyTopLevel;
    public boolean liberal;
    public boolean validate;
    public boolean checkForDuplicates;
    public static final String SCHEMA_URI = "http://www.w3.org/2005/xpath-functions.xsd";
    public static final String JSON_NS = "http://www.w3.org/2005/xpath-functions";
    public static final String PREFIX = "";
    private NamePool e;
    private FingerprintedQName f;
    private FingerprintedQName g;
    private FingerprintedQName h;
    private FingerprintedQName i;
    private FingerprintedQName j;
    private FingerprintedQName k;
    private FingerprintedQName l;
    private FingerprintedQName m;
    private FingerprintedQName n;
    private static final Untyped o = Untyped.getInstance();
    private static final AnySimpleType p = AnySimpleType.getInstance();
    private static final BuiltInAtomicType q = BuiltInAtomicType.BOOLEAN;
    private static final BuiltInAtomicType r = BuiltInAtomicType.STRING;
    public HashMap<String, SchemaType> types;
    private Stack<HashSet<String>> s = new Stack();

    private FingerprintedQName a(String object) {
        object = new FingerprintedQName(PREFIX, PREFIX, (String)object);
        ((FingerprintedQName)object).obtainFingerprint(this.e);
        return object;
    }

    private FingerprintedQName b(String object) {
        object = new FingerprintedQName(PREFIX, JSON_NS, (String)object);
        ((FingerprintedQName)object).obtainFingerprint(this.e);
        return object;
    }

    public JsonHandlerXML(XPathContext xPathContext, String string, int n2) {
        int n3 = n2;
        Object object = xPathContext;
        JsonHandlerXML jsonHandlerXML = this;
        this.c = new Stack();
        jsonHandlerXML.setContext((XPathContext)object);
        jsonHandlerXML.charChecker = object.getConfiguration().getValidCharacterChecker();
        jsonHandlerXML.escape = (n3 & 1) != 0;
        jsonHandlerXML.allowAnyTopLevel = (n3 & 2) != 0;
        jsonHandlerXML.validate = (n3 & 8) != 0;
        jsonHandlerXML.checkForDuplicates = jsonHandlerXML.validate || (n3 & 0x20) == 0;
        jsonHandlerXML.types = new HashMap();
        jsonHandlerXML.e = object.getConfiguration().getNamePool();
        jsonHandlerXML.f = jsonHandlerXML.b("map");
        jsonHandlerXML.g = jsonHandlerXML.b("array");
        jsonHandlerXML.h = jsonHandlerXML.b("string");
        jsonHandlerXML.i = jsonHandlerXML.b("number");
        jsonHandlerXML.j = jsonHandlerXML.b("boolean");
        jsonHandlerXML.k = jsonHandlerXML.b("null");
        jsonHandlerXML.l = jsonHandlerXML.a("key");
        jsonHandlerXML.m = jsonHandlerXML.a("escaped");
        jsonHandlerXML.n = jsonHandlerXML.a("escaped-key");
        if (jsonHandlerXML.validate) {
            try {
                object = object.getConfiguration();
                String[] stringArray = object;
                synchronized (object) {
                    String[] stringArray2;
                    ((Configuration)object).checkLicensedFeature(1, "validation", -1);
                    if (!((Configuration)object).isSchemaAvailable(JSON_NS)) {
                        stringArray2 = StandardEntityResolver.getInstance().resolveEntity(null, SCHEMA_URI);
                        if (((Configuration)object).isTiming()) {
                            ((Configuration)object).getLogger().info("Loading a schema from resources for: http://www.w3.org/2005/xpath-functions");
                        }
                        ((Configuration)object).addSchemaSource(new SAXSource((InputSource)stringArray2));
                    }
                    // ** MonitorExit[var5_7] (shouldn't be in output)
                    stringArray = new String[]{"mapType", "arrayType", "stringType", "numberType", "booleanType", "nullType", "mapWithinMapType", "arrayWithinMapType", "stringWithinMapType", "numberWithinMapType", "booleanWithinMapType", "nullWithinMapType"};
                    stringArray2 = stringArray;
                    int cfr_ignored_0 = stringArray.length;
                    for (int i2 = 0; i2 < 12; ++i2) {
                        String string2 = stringArray2[i2];
                        jsonHandlerXML.setType(string2, ((Configuration)object).getSchemaType(new StructuredQName(PREFIX, JSON_NS, string2)));
                    }
                }
            }
            catch (SchemaException schemaException) {
                throw new XPathException(schemaException);
            }
            catch (SAXException sAXException) {
                throw new XPathException(sAXException);
            }
            catch (IOException iOException) {
                throw new XPathException(iOException);
            }
        }
        {
            this.b = xPathContext.getController().makeBuilder();
            this.b.setSystemId(string);
            this.b.setTiming(false);
            this.a = new NamespaceReducer(this.b);
            this.a.open();
            this.a.startDocument(0);
            return;
        }
    }

    public void setType(String string, SchemaType schemaType) {
        this.types.put(string, schemaType);
    }

    @Override
    public boolean setKey(String string, String string2) {
        this.c.push(string);
        return this.checkForDuplicates && !this.s.peek().add(string2);
    }

    public Item getResult() {
        this.a.endDocument();
        this.a.close();
        return this.b.getCurrentRoot();
    }

    protected boolean containsEscape(String string) {
        return string.indexOf(92) >= 0;
    }

    private boolean a() {
        return !this.d.isEmpty() && this.d.peek() != false;
    }

    private void a(FingerprintedQName object, String object2) {
        SchemaType schemaType = this.types.get(object2);
        object2 = object;
        object = this;
        ((JsonHandlerXML)object).a.startElement((NodeName)object2, ((JsonHandlerXML)object).validate && schemaType != null ? schemaType : o, ExplicitLocation.UNKNOWN_LOCATION, 0);
        if (super.a()) {
            object2 = ((JsonHandlerXML)object).c.pop();
            object2 = ((JsonHandler)object).reEscape((String)object2);
            if (((JsonHandler)object).escape) {
                ((JsonHandlerXML)object).markAsEscaped((CharSequence)object2, true);
            }
            ((JsonHandlerXML)object).a.attribute(((JsonHandlerXML)object).l, ((JsonHandlerXML)object).validate ? r : p, (CharSequence)object2, ExplicitLocation.UNKNOWN_LOCATION, 0);
        }
    }

    private void c(String string) {
        this.a.characters(string, ExplicitLocation.UNKNOWN_LOCATION, 0);
    }

    private void b() {
        this.a.endElement();
    }

    @Override
    public void startArray() {
        JsonHandlerXML jsonHandlerXML = this;
        jsonHandlerXML.a(jsonHandlerXML.g, this.a() ? "arrayWithinMapType" : "arrayType");
        this.d.push(Boolean.FALSE);
    }

    @Override
    public void endArray() {
        this.d.pop();
        this.b();
    }

    @Override
    public void startMap() {
        JsonHandlerXML jsonHandlerXML = this;
        jsonHandlerXML.a(jsonHandlerXML.f, this.a() ? "mapWithinMapType" : "mapType");
        if (this.checkForDuplicates) {
            this.s.push(new HashSet());
        }
        this.d.push(Boolean.TRUE);
    }

    @Override
    public void endMap() {
        this.d.pop();
        if (this.checkForDuplicates) {
            this.s.pop();
        }
        this.b();
    }

    @Override
    public void writeNumeric(String string, double d2) {
        JsonHandlerXML jsonHandlerXML = this;
        jsonHandlerXML.a(jsonHandlerXML.i, this.a() ? "numberWithinMapType" : "numberType");
        this.c(string);
        this.b();
    }

    @Override
    public void writeString(String string) {
        JsonHandlerXML jsonHandlerXML = this;
        jsonHandlerXML.a(jsonHandlerXML.h, this.a() ? "stringWithinMapType" : "stringType");
        string = this.reEscape(string);
        if (this.escape) {
            this.markAsEscaped(string, false);
        }
        this.c(string.toString());
        this.b();
    }

    @Override
    protected void markAsEscaped(CharSequence object, boolean bl2) {
        if (this.containsEscape(object.toString()) && this.escape) {
            object = bl2 ? this.n : this.m;
            this.a.attribute((NodeName)object, this.validate ? q : p, "true", ExplicitLocation.UNKNOWN_LOCATION, 0);
        }
    }

    @Override
    public void writeBoolean(boolean bl2) {
        JsonHandlerXML jsonHandlerXML = this;
        jsonHandlerXML.a(jsonHandlerXML.j, this.a() ? "booleanWithinMapType" : "booleanType");
        this.c(Boolean.toString(bl2));
        this.b();
    }

    @Override
    public void writeNull() {
        JsonHandlerXML jsonHandlerXML = this;
        jsonHandlerXML.a(jsonHandlerXML.k, this.a() ? "nullWithinMapType" : "nullType");
        this.b();
    }
}

