/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.json;

import java.util.Map;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.ma.json.JsonHandler;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class JsonParser {
    public static final int ESCAPE = 1;
    public static final int ALLOW_ANY_TOP_LEVEL = 2;
    public static final int LIBERAL = 4;
    public static final int VALIDATE = 8;
    public static final int DEBUG = 16;
    public static final int DUPLICATES_RETAINED = 32;
    public static final int DUPLICATES_LAST = 64;
    public static final int DUPLICATES_FIRST = 128;
    public static final int DUPLICATES_REJECTED = 256;
    public static final int DUPLICATES_SPECIFIED = 480;

    public void parse(String object, int n2, JsonHandler jsonHandler, XPathContext xPathContext) {
        if (((String)object).isEmpty()) {
            JsonParser.b("An empty string is not valid JSON", "FOJS0001");
        }
        object = new a(this, (String)object);
        ((a)object).a();
        this.a(jsonHandler, (a)object, n2, xPathContext);
        if (((a)object).a() != 999) {
            JsonParser.b("Unexpected token beyond end of JSON input", "FOJS0001");
        }
    }

    public static int getFlags(Map<String, Sequence<?>> object, XPathContext object2, Boolean bl2) {
        boolean bl3;
        int n2 = 0;
        BooleanValue booleanValue = (BooleanValue)object.get("debug");
        if (booleanValue != null && booleanValue.getBooleanValue()) {
            n2 = 16;
        }
        if (bl3 = ((BooleanValue)object.get("escape")).getBooleanValue()) {
            n2 |= 1;
            if (object.get("fallback") != null) {
                throw new XPathException("Cannot specify a fallback function when escape=true", "FOJS0005");
            }
        }
        if (((BooleanValue)object.get("liberal")).getBooleanValue()) {
            n2 |= 4;
            n2 |= 2;
        }
        bl3 = false;
        if (bl2.booleanValue() && (bl3 = ((BooleanValue)object.get("validate")).getBooleanValue())) {
            if (!object2.getController().getExecutable().isSchemaAware()) {
                JsonParser.a("Requiring validation on non-schema-aware processor", "FOJS0004");
            }
            n2 |= 8;
        }
        if (object.containsKey("duplicates")) {
            switch (object = ((StringValue)object.get("duplicates")).getStringValue()) {
                case "reject": {
                    n2 |= 0x100;
                    break;
                }
                case "use-last": {
                    n2 |= 0x40;
                    break;
                }
                case "use-first": {
                    n2 |= 0x80;
                    break;
                }
                case "retain": {
                    n2 |= 0x20;
                    break;
                }
                default: {
                    JsonParser.a("Invalid value for 'duplicates' option", "FOJS0005");
                }
            }
            if (bl3 && "retain".equals(object)) {
                JsonParser.a("The options validate:true and duplicates:retain cannot be used together", "FOJS0005");
            }
        }
        return n2;
    }

    private void a(JsonHandler jsonHandler, a object, int n2, XPathContext xPathContext) {
        boolean bl2 = (n2 & 0x10) != 0;
        if (bl2) {
            System.err.println("token:" + ((a)object).a + " :" + ((a)object).b);
        }
        switch (((a)object).a) {
            case 3: {
                this.b(jsonHandler, (a)object, n2, xPathContext);
                return;
            }
            case 1: {
                this.c(jsonHandler, (a)object, n2, xPathContext);
                return;
            }
            case 6: {
                object = ((a)object).b.toString();
                double d2 = this.a((String)object, n2);
                jsonHandler.writeNumeric((String)object, d2);
                return;
            }
            case 7: {
                jsonHandler.writeBoolean(true);
                return;
            }
            case 8: {
                jsonHandler.writeBoolean(false);
                return;
            }
            case 9: {
                jsonHandler.writeNull();
                return;
            }
            case 5: {
                object = ((a)object).b.toString();
                jsonHandler.writeString(JsonParser.unescape((String)object, n2, "FOJS0001"));
                return;
            }
        }
        JsonParser.b("Unexpected symbol: " + ((a)object).b, "FOJS0001");
    }

    private void b(JsonHandler jsonHandler, a a2, int n2, XPathContext xPathContext) {
        boolean bl2 = (n2 & 4) != 0;
        jsonHandler.startMap();
        int n3 = a2.a();
        while (n3 != 4) {
            if (!(n3 == 5 || n3 == 12 && bl2)) {
                JsonParser.b("Property name must be a string literal", "FOJS0001");
            }
            String string = a2.b.toString();
            string = JsonParser.unescape(string, n2, "FOJS0001");
            String string2 = jsonHandler.reEscape(string);
            n3 = a2.a();
            if (n3 != 10) {
                JsonParser.b("Missing colon after \"" + Err.wrap(string) + "\"", "FOJS0001");
            }
            a2.a();
            boolean bl3 = jsonHandler.setKey(string, string2);
            n3 = bl3 ? 1 : 0;
            if (bl3 && (n2 & 0x100) != 0) {
                JsonParser.b("Duplicate key value \"" + Err.wrap(string) + "\"", "FOJS0003");
            }
            try {
                if (n3 == 0 || (n2 & 0x60) != 0) {
                    this.a(jsonHandler, a2, n2, xPathContext);
                } else {
                    JsonHandler jsonHandler2 = new JsonHandler();
                    jsonHandler2.setContext(xPathContext);
                    this.a(jsonHandler2, a2, n2, xPathContext);
                }
            }
            catch (StackOverflowError stackOverflowError) {
                JsonParser.b("Objects are too deeply nested", "FOJS0001");
            }
            n3 = a2.a();
            if (n3 == 11) {
                n3 = a2.a();
                if (n3 != 4) continue;
                if (bl2) break;
                JsonParser.b("Trailing comma after entry in object", "FOJS0001");
                continue;
            }
            if (n3 == 4) break;
            JsonParser.b("Unexpected token after value of \"" + Err.wrap(string) + "\" property", "FOJS0001");
        }
        jsonHandler.endMap();
    }

    private void c(JsonHandler jsonHandler, a a2, int n2, XPathContext xPathContext) {
        boolean bl2 = (n2 & 4) != 0;
        jsonHandler.startArray();
        int n3 = a2.a();
        if (n3 == 2) {
            jsonHandler.endArray();
            return;
        }
        while (true) {
            try {
                this.a(jsonHandler, a2, n2, xPathContext);
            }
            catch (StackOverflowError stackOverflowError) {
                JsonParser.b("Arrays are too deeply nested", "FOJS0001");
            }
            n3 = a2.a();
            if (n3 == 11) {
                n3 = a2.a();
                if (n3 != 2) continue;
                if (bl2) break;
                JsonParser.b("Trailing comma after entry in array", "FOJS0001");
                continue;
            }
            if (n3 == 2) break;
            JsonParser.b("Unexpected token (" + JsonParser.toString(n3, a2.b.toString()) + ") after entry in array", "FOJS0001");
        }
        jsonHandler.endArray();
    }

    private double a(String string, int n2) {
        try {
            if ((n2 & 4) == 0) {
                if (string.startsWith("+")) {
                    JsonParser.b("Leading + sign not allowed: " + string, "FOJS0001");
                } else {
                    String string2 = string;
                    if (string2.startsWith("-")) {
                        string2 = string2.substring(1);
                    }
                    if (!(!string2.startsWith("0") || string2.equals("0") || string2.startsWith("0.") || string2.startsWith("0e") || string2.startsWith("0E"))) {
                        JsonParser.b("Redundant leading zeroes not allowed: " + string, "FOJS0001");
                    }
                    if (string2.endsWith(".") || string2.contains(".e") || string2.contains(".E")) {
                        JsonParser.b("Empty fractional part not allowed", "FOJS0001");
                    }
                    if (string2.startsWith(".")) {
                        JsonParser.b("Empty integer part not allowed", "FOJS0001");
                    }
                }
            }
            return StringToDouble.getInstance().stringToNumber(string);
        }
        catch (NumberFormatException numberFormatException) {
            JsonParser.b("Invalid numeric literal: " + numberFormatException.getMessage(), "FOJS0001");
            return Double.NaN;
        }
    }

    public static String unescape(String string, int n2, String string2) {
        if (string.indexOf(92) < 0) {
            return string;
        }
        n2 = (n2 & 4) != 0 ? 1 : 0;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(string.length());
        block13: for (int i2 = 0; i2 < string.length(); ++i2) {
            int n3 = string.charAt(i2);
            if (n3 == 92) {
                if (i2++ == string.length() - 1) {
                    throw new XPathException("Invalid JSON escape: String " + Err.wrap(string) + " ends in backslash", string2);
                }
                switch (string.charAt(i2)) {
                    case '\"': {
                        fastStringBuffer.append('\"');
                        continue block13;
                    }
                    case '\\': {
                        fastStringBuffer.append('\\');
                        continue block13;
                    }
                    case '/': {
                        fastStringBuffer.append('/');
                        continue block13;
                    }
                    case 'b': {
                        fastStringBuffer.append('\b');
                        continue block13;
                    }
                    case 'f': {
                        fastStringBuffer.append('\f');
                        continue block13;
                    }
                    case 'n': {
                        fastStringBuffer.append('\n');
                        continue block13;
                    }
                    case 'r': {
                        fastStringBuffer.append('\r');
                        continue block13;
                    }
                    case 't': {
                        fastStringBuffer.append('\t');
                        continue block13;
                    }
                    case 'u': {
                        try {
                            String string3 = string.substring(i2 + 1, i2 + 5);
                            n3 = Integer.parseInt(string3, 16);
                            fastStringBuffer.append((char)n3);
                            i2 += 4;
                            continue block13;
                        }
                        catch (Exception exception) {
                            if (n2 != 0) {
                                fastStringBuffer.append("\\u");
                                continue block13;
                            }
                            throw new XPathException("Invalid JSON escape: \\u must be followed by four hex characters", string2);
                        }
                    }
                    default: {
                        if (n2 != 0) {
                            fastStringBuffer.append(string.charAt(i2));
                            continue block13;
                        }
                        n3 = string.charAt(i2);
                        String string4 = n3 < 256 ? "" + (char)n3 : "x" + Integer.toHexString(n3);
                        throw new XPathException("Unknown escape sequence \\" + string4, string2);
                    }
                }
            }
            fastStringBuffer.append((char)n3);
        }
        return fastStringBuffer.toString();
    }

    private static void a(String string, String string2) {
        throw new XPathException(string, string2);
    }

    private static void b(String string, String string2) {
        JsonParser.a("Invalid JSON input: " + string, string2);
    }

    public static String toString(int n2, String string) {
        switch (n2) {
            case 1: {
                return "[";
            }
            case 2: {
                return "]";
            }
            case 3: {
                return "{";
            }
            case 4: {
                return "}";
            }
            case 5: {
                return "string (\"" + string + "\")";
            }
            case 6: {
                return "number (" + string + ")";
            }
            case 7: {
                return "true";
            }
            case 8: {
                return "false";
            }
            case 9: {
                return "null";
            }
            case 10: {
                return ":";
            }
            case 11: {
                return ",";
            }
            case 999: {
                return "<eof>";
            }
        }
        return "<" + n2 + ">";
    }

    private final class a {
        private String c;
        private int d;
        public int a;
        public FastStringBuffer b = new FastStringBuffer(64);
        private /* synthetic */ JsonParser e;

        public a(JsonParser jsonParser, String string) {
            this.e = jsonParser;
            this.c = string;
            this.d = 0;
            if (!string.isEmpty() && string.charAt(0) == '\ufeff') {
                ++this.d;
            }
        }

        public final int a() {
            this.a = this.b();
            return this.a;
        }

        private int b() {
            if (this.d >= this.c.length()) {
                return 999;
            }
            while (Whitespace.isWhitespace(this.c.charAt(this.d))) {
                if (++this.d < this.c.length()) continue;
                return 999;
            }
            char c2 = this.c.charAt(this.d++);
            switch (c2) {
                case '[': {
                    return 1;
                }
                case '{': {
                    return 3;
                }
                case ']': {
                    return 2;
                }
                case '}': {
                    return 4;
                }
                case '\"': {
                    this.b.setLength(0);
                    c2 = '\u0000';
                    while (true) {
                        char c3;
                        if (this.d >= this.c.length()) {
                            JsonParser.b("Unclosed quotes in string literal", "FOJS0001");
                        }
                        if ((c3 = this.c.charAt(this.d++)) < ' ') {
                            JsonParser.b("Unescaped control character (x" + Integer.toHexString(c3) + ")", "FOJS0001");
                        }
                        if (c2 != '\u0000' && c3 == 'u') {
                            try {
                            }
                            catch (Exception exception) {
                                JsonParser.b("\\u must be followed by four hex characters", "FOJS0001");
                            }
                        }
                        if (c3 == '\"' && c2 == '\u0000') break;
                        this.b.append(c3);
                        c2 = c3 == '\\' && c2 == '\u0000' ? (char)'\u0001' : '\u0000';
                    }
                    return 5;
                }
                case ':': {
                    return 10;
                }
                case ',': {
                    return 11;
                }
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.b.setLength(0);
                    this.b.append(c2);
                    if (this.d < this.c.length()) {
                        char c4;
                        while ((c4 = this.c.charAt(this.d)) >= '0' && c4 <= '9' || c4 == '-' || c4 == '+' || c4 == '.' || c4 == 'e' || c4 == 'E') {
                            this.b.append(c4);
                            if (++this.d < this.c.length()) continue;
                        }
                    }
                    return 6;
                }
            }
            if (NameChecker.isNCNameChar(c2)) {
                String string;
                char c5;
                this.b.setLength(0);
                this.b.append(c2);
                while (this.d < this.c.length() && NameChecker.isNCNameChar(c5 = this.c.charAt(this.d))) {
                    this.b.append(c5);
                    ++this.d;
                }
                switch (string = this.b.toString()) {
                    case "true": {
                        return 7;
                    }
                    case "false": {
                        return 8;
                    }
                    case "null": {
                        return 9;
                    }
                }
                return 12;
            }
            char c6 = this.c.charAt(--this.d);
            JsonParser.b("Unexpected character '" + c6 + "' (\\u" + Integer.toHexString(c6) + ") at position " + this.d, "FOJS0001");
            return -1;
        }
    }
}

