/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.json;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.function.IntPredicate;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.StringToDouble11;
import net.sf.saxon.value.Whitespace;

public class JsonReceiver
implements Receiver {
    private PipelineConfiguration a;
    private FastStringBuffer b;
    private FastStringBuffer c = new FastStringBuffer(128);
    private Stack<NodeName> d = new Stack();
    private boolean e = true;
    private StartTagBuffer f;
    private boolean g = false;
    private boolean h = false;
    private Stack<Set<String>> i = new Stack();

    public JsonReceiver(PipelineConfiguration pipelineConfiguration) {
        this.setPipelineConfiguration(pipelineConfiguration);
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        this.a = pipelineConfiguration;
        this.f = (StartTagBuffer)pipelineConfiguration.getComponent(StartTagBuffer.class.getName());
    }

    @Override
    public PipelineConfiguration getPipelineConfiguration() {
        return this.a;
    }

    @Override
    public void setSystemId(String string) {
    }

    public void setIndenting(boolean bl2) {
        this.g = bl2;
    }

    public boolean isIndenting() {
        return this.g;
    }

    @Override
    public void open() {
        this.b = new FastStringBuffer(2048);
    }

    @Override
    public void startDocument(int n2) {
        if (this.b == null) {
            this.b = new FastStringBuffer(2048);
        }
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void setUnparsedEntity(String string, String string2, String string3) {
    }

    @Override
    public void startElement(NodeName nodeName, SchemaType schemaType, Location location, int n2) {
        schemaType = this.d.empty() ? null : this.d.peek().getLocalPart();
        boolean bl2 = "map".equals(schemaType);
        this.d.push(nodeName);
        if (!nodeName.hasURI("http://www.w3.org/2005/xpath-functions")) {
            throw new XPathException("xml-to-json: element found in wrong namespace: " + nodeName.getStructuredQName().getEQName(), "FOJS0006");
        }
        if (!this.e) {
            this.b.append(',');
            if (this.g) {
                JsonReceiver jsonReceiver = this;
                jsonReceiver.a(jsonReceiver.d.size());
            }
        }
        if (bl2) {
            if (this.f == null) {
                this.f = (StartTagBuffer)this.a.getComponent(StartTagBuffer.class.getName());
            }
            if (this.f == null) {
                throw new IllegalStateException();
            }
            String string = this.f.getAttribute("", "key");
            if (string == null) {
                throw new XPathException("xml-to-json: Child elements of <map> must have a key attribute", "FOJS0006");
            }
            String string2 = this.f.getAttribute("", "escaped-key");
            boolean bl3 = false;
            if (string2 != null) {
                try {
                    bl3 = ((StringConverter)StringConverter.StringToBoolean.INSTANCE).convertString(string2).asAtomic().effectiveBooleanValue();
                }
                catch (XPathException xPathException) {
                    throw new XPathException("xml-to-json: Value of escaped-key attribute '" + Err.wrap(string2) + "' is not a valid xs:boolean", "FOJS0006");
                }
            }
            string = (bl3 ? JsonReceiver.a(string) : JsonReceiver.escape(string, false, new a(0))).toString();
            string2 = bl3 ? JsonReceiver.b(string) : string;
            boolean bl4 = this.i.peek().add(string2);
            n2 = bl4 ? 1 : 0;
            if (!bl4) {
                throw new XPathException("xml-to-json: duplicate key value " + Err.wrap(string), "FOJS0006");
            }
            this.b.append('\"');
            this.b.append(string);
            this.b.append('\"');
            this.b.append(this.g ? " : " : ":");
        }
        String string = nodeName.getLocalPart();
        this.h = false;
        if (string.equals("array")) {
            if (this.g) {
                JsonReceiver jsonReceiver = this;
                jsonReceiver.a(jsonReceiver.d.size());
                this.b.append("[ ");
            } else {
                this.b.append('[');
            }
            this.e = true;
        } else if (string.equals("map")) {
            if (this.g) {
                JsonReceiver jsonReceiver = this;
                jsonReceiver.a(jsonReceiver.d.size());
                this.b.append("{ ");
            } else {
                this.b.append('{');
            }
            this.e = true;
            this.i.push(new HashSet());
        } else if (string.equals("null")) {
            JsonReceiver.a(string, (String)((Object)schemaType));
            this.b.append("null");
            this.e = false;
        } else if (string.equals("string")) {
            String string3;
            if (this.f == null) {
                this.f = (StartTagBuffer)this.a.getComponent(StartTagBuffer.class.getName());
            }
            if ((string3 = this.f.getAttribute("", "escaped")) != null) {
                try {
                    this.h = ((StringConverter)StringConverter.StringToBoolean.INSTANCE).convertString(string3).asAtomic().effectiveBooleanValue();
                }
                catch (XPathException xPathException) {
                    throw new XPathException("xml-to-json: value of escaped attribute (" + string3 + ") is not a valid xs:boolean", "FOJS0006");
                }
            }
            JsonReceiver.a(string, (String)((Object)schemaType));
            this.e = false;
        } else if (string.equals("boolean") || string.equals("number")) {
            JsonReceiver.a(string, (String)((Object)schemaType));
            this.e = false;
        } else {
            throw new XPathException("xml-to-json: unknown element <" + string + ">", "FOJS0006");
        }
        this.c.setLength(0);
    }

    private static void a(String string, String string2) {
        if ("null".equals(string2) || "string".equals(string2) || "number".equals(string2) || "boolean".equals(string2)) {
            throw new XPathException("xml-to-json: A " + Err.wrap(string, 1) + " element cannot appear as a child of " + Err.wrap(string2, 1), "FOJS0006");
        }
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindingSet, int n2) {
    }

    @Override
    public void attribute(NodeName nodeName, SimpleType simpleType, CharSequence charSequence, Location location, int n2) {
        if (nodeName.hasURI("") && (nodeName.getLocalPart().equals("key") || nodeName.getLocalPart().equals("escaped-key"))) {
            boolean bl2 = this.d.size() == 1 || ((NodeName)this.d.get(this.d.size() - 2)).getLocalPart().equals("map");
            if (!bl2) {
                throw new XPathException("xml-to-json: The " + nodeName.getLocalPart() + " attribute is allowed only on elements within a map", "FOJS0006");
            }
            return;
        }
        if (nodeName.hasURI("") && nodeName.getLocalPart().equals("escaped")) {
            boolean bl3 = this.d.size() == 1 || this.d.size() > 1 && this.d.peek().getLocalPart().equals("string");
            if (!bl3) {
                throw new XPathException("xml-to-json: The escaped attribute is allowed only on the <string> element", "FOJS0006");
            }
            return;
        }
        if (nodeName.hasURI("") || nodeName.hasURI("http://www.w3.org/2005/xpath-functions")) {
            throw new XPathException("xml-to-json: Disallowed attribute in input: " + nodeName.getDisplayName(), "FOJS0006");
        }
    }

    @Override
    public void startContent() {
    }

    @Override
    public void endElement() {
        NodeName nodeName = this.d.pop();
        String string = nodeName.getLocalPart();
        if (string.equals("boolean")) {
            try {
                boolean bl2 = ((StringConverter)StringConverter.StringToBoolean.INSTANCE).convertString(this.c).asAtomic().effectiveBooleanValue();
                this.b.append(bl2 ? "true" : "false");
            }
            catch (XPathException xPathException) {
                throw new XPathException("xml-to-json: Value of <boolean> element is not a valid xs:boolean", "FOJS0006");
            }
        } else if (string.equals("number")) {
            try {
                double d2 = StringToDouble11.getInstance().stringToNumber(this.c);
                if (Double.isNaN(d2) || Double.isInfinite(d2)) {
                    throw new XPathException("xml-to-json: Infinity and NaN are not allowed", "FOJS0006");
                }
                this.b.append(new DoubleValue(d2).getStringValueCS());
            }
            catch (NumberFormatException numberFormatException) {
                throw new XPathException("xml-to-json: Invalid number: " + this.c, "FOJS0006");
            }
        } else if (string.equals("string")) {
            this.b.append('\"');
            String string2 = this.c.toString();
            if (this.h) {
                this.b.append((CharSequence)JsonReceiver.a(string2));
            } else {
                this.b.append(JsonReceiver.escape(string2, false, new a(0)));
            }
            this.b.append('\"');
        } else if (!Whitespace.isWhite(this.c)) {
            throw new XPathException("xml-to-json: Element " + nodeName.getDisplayName() + " must have no text content", "FOJS0006");
        }
        this.c.setLength(0);
        this.h = false;
        if (string.equals("array")) {
            this.b.append(this.g ? " ]" : "]");
        } else if (string.equals("map")) {
            this.i.pop();
            this.b.append(this.g ? " }" : "}");
        }
        this.e = false;
    }

    private static FastStringBuffer a(String string) {
        JsonReceiver.b(string);
        FastStringBuffer fastStringBuffer = new FastStringBuffer(string.length() << 1);
        boolean bl2 = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\"' && !bl2) {
                fastStringBuffer.append("\\\"");
            } else if (c2 < ' ' || c2 >= '\u007f' && c2 < '\u00a0') {
                if (c2 == '\b') {
                    fastStringBuffer.append("\\b");
                } else if (c2 == '\f') {
                    fastStringBuffer.append("\\f");
                } else if (c2 == '\n') {
                    fastStringBuffer.append("\\n");
                } else if (c2 == '\r') {
                    fastStringBuffer.append("\\r");
                } else if (c2 == '\t') {
                    fastStringBuffer.append("\\t");
                } else {
                    fastStringBuffer.append("\\u");
                    String string2 = Integer.toHexString(c2).toUpperCase();
                    while (string2.length() < 4) {
                        string2 = "0" + string2;
                    }
                    fastStringBuffer.append(string2);
                }
            } else if (c2 == '/' && !bl2) {
                fastStringBuffer.append("\\/");
            } else {
                fastStringBuffer.append(c2);
            }
            bl2 = c2 == '\\' && !bl2;
        }
        return fastStringBuffer;
    }

    public static CharSequence escape(CharSequence charSequence, boolean bl2, IntPredicate intPredicate) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
        block10: for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            switch (c2) {
                case '\"': {
                    fastStringBuffer.append(bl2 ? "\"" : "\\\"");
                    continue block10;
                }
                case '\b': {
                    fastStringBuffer.append("\\b");
                    continue block10;
                }
                case '\f': {
                    fastStringBuffer.append("\\f");
                    continue block10;
                }
                case '\n': {
                    fastStringBuffer.append("\\n");
                    continue block10;
                }
                case '\r': {
                    fastStringBuffer.append("\\r");
                    continue block10;
                }
                case '\t': {
                    fastStringBuffer.append("\\t");
                    continue block10;
                }
                case '/': {
                    fastStringBuffer.append(bl2 ? "/" : "\\/");
                    continue block10;
                }
                case '\\': {
                    fastStringBuffer.append("\\\\");
                    continue block10;
                }
                default: {
                    if (intPredicate.test(c2)) {
                        fastStringBuffer.append("\\u");
                        String string = Integer.toHexString(c2).toUpperCase();
                        while (string.length() < 4) {
                            string = "0" + string;
                        }
                        fastStringBuffer.append(string);
                        continue block10;
                    }
                    fastStringBuffer.append(c2);
                }
            }
        }
        return fastStringBuffer;
    }

    @Override
    public void characters(CharSequence charSequence, Location location, int n2) {
        this.c.append(charSequence);
    }

    @Override
    public void processingInstruction(String string, CharSequence charSequence, Location location, int n2) {
    }

    @Override
    public void comment(CharSequence charSequence, Location location, int n2) {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    @Override
    public String getSystemId() {
        return null;
    }

    public String getJsonString() {
        return this.b.toString();
    }

    private void a(int n2) {
        this.b.append('\n');
        for (int i2 = 0; i2 < n2; ++i2) {
            this.b.append("  ");
        }
    }

    private static String b(String string) {
        if (string.indexOf(92) < 0) {
            return string;
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(string.length());
        block13: for (int i2 = 0; i2 < string.length(); ++i2) {
            int n2 = string.charAt(i2);
            if (n2 == 92) {
                if (i2++ == string.length() - 1) {
                    throw new XPathException("String '" + Err.wrap(string) + "' ends in backslash ", "FOJS0007");
                }
                switch (string.charAt(i2)) {
                    case '\"': {
                        fastStringBuffer.append('\"');
                        continue block13;
                    }
                    case '\\': {
                        fastStringBuffer.append('\\');
                        continue block13;
                    }
                    case '/': {
                        fastStringBuffer.append('/');
                        continue block13;
                    }
                    case 'b': {
                        fastStringBuffer.append('\b');
                        continue block13;
                    }
                    case 'f': {
                        fastStringBuffer.append('\f');
                        continue block13;
                    }
                    case 'n': {
                        fastStringBuffer.append('\n');
                        continue block13;
                    }
                    case 'r': {
                        fastStringBuffer.append('\r');
                        continue block13;
                    }
                    case 't': {
                        fastStringBuffer.append('\t');
                        continue block13;
                    }
                    case 'u': {
                        try {
                            String string2 = string.substring(i2 + 1, i2 + 5);
                            n2 = Integer.parseInt(string2, 16);
                            fastStringBuffer.append((char)n2);
                            i2 += 4;
                            continue block13;
                        }
                        catch (Exception exception) {
                            throw new XPathException("Invalid hex escape sequence in string '" + Err.wrap(string) + "'", "FOJS0007");
                        }
                    }
                    default: {
                        n2 = string.charAt(i2);
                        String string3 = n2 < 256 ? "" + (char)n2 : "x" + Integer.toHexString(n2);
                        throw new XPathException("Unknown escape sequence \\" + string3, "FOJS0007");
                    }
                }
            }
            fastStringBuffer.append((char)n2);
        }
        return fastStringBuffer.toString();
    }

    private static final class a
    implements IntPredicate {
        private a() {
        }

        @Override
        public final boolean test(int n2) {
            return n2 < 31 || n2 >= 127 && n2 <= 159;
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

