/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.json;

import java.util.Map;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.OptionsParameter;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.json.JsonHandlerXML;
import net.sf.saxon.ma.json.JsonParser;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public class JsonToXMLFn
extends SystemFunction {
    public static OptionsParameter OPTION_DETAILS;

    @Override
    public Sequence<?> call(XPathContext object, Sequence[] sequenceArray) {
        Object object2 = sequenceArray[0].head();
        if (object2 == null) {
            return EmptySequence.getInstance();
        }
        object2 = object2.getStringValue();
        MapItem mapItem = null;
        if (this.getArity() == 2) {
            mapItem = (MapItem)sequenceArray[1].head();
        }
        if ((object = this.eval((String)object2, mapItem, (XPathContext)object)) == null) {
            return EmptySequence.getInstance();
        }
        return object;
    }

    protected Item eval(String string, MapItem mapItem, XPathContext xPathContext) {
        int n2;
        JsonParser jsonParser = new JsonParser();
        Map<String, Sequence<?>> map = null;
        if (mapItem != null) {
            map = this.getDetails().optionDetails.processSuppliedOptions(mapItem, xPathContext);
            n2 = JsonParser.getFlags(map, xPathContext, Boolean.TRUE);
            if ((n2 & 0x40) != 0) {
                throw new XPathException("json-to-xml: duplicates=use-last is not allowed", "FOJS0005");
            }
            if ((n2 & 0x1E0) == 0) {
                n2 = (n2 & 8) != 0 ? (n2 |= 0x100) : (n2 |= 0x20);
            }
        } else {
            n2 = 32;
        }
        JsonHandlerXML jsonHandlerXML = new JsonHandlerXML(xPathContext, this.getStaticBaseUriString(), n2);
        if (mapItem != null) {
            jsonHandlerXML.setFallbackFunction(map, xPathContext);
        }
        jsonParser.parse(string, n2, jsonHandlerXML, xPathContext);
        return jsonHandlerXML.getResult();
    }

    static {
        SpecificFunctionType specificFunctionType = new SpecificFunctionType(new SequenceType[]{SequenceType.SINGLE_STRING}, SequenceType.SINGLE_STRING);
        OptionsParameter optionsParameter = new OptionsParameter();
        optionsParameter.addAllowedOption("liberal", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        optionsParameter.addAllowedOption("duplicates", SequenceType.SINGLE_STRING, null);
        optionsParameter.setAllowedValues("duplicates", "FOJS0005", "reject", "use-first", "retain");
        optionsParameter.addAllowedOption("validate", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        optionsParameter.addAllowedOption("escape", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        optionsParameter.addAllowedOption("fallback", SequenceType.makeSequenceType(specificFunctionType, 16384), null);
        OPTION_DETAILS = optionsParameter;
    }
}

