/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.json;

import java.util.Map;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.OptionsParameter;
import net.sf.saxon.ma.json.JsonHandler;
import net.sf.saxon.ma.json.JsonHandlerMap;
import net.sf.saxon.ma.json.JsonParser;
import net.sf.saxon.ma.json.JsonToXMLFn;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class ParseJsonFn
extends JsonToXMLFn {
    public static OptionsParameter OPTION_DETAILS;

    @Override
    protected Item eval(String string, MapItem mapItem, XPathContext xPathContext) {
        Map<String, Sequence<?>> map = null;
        if (mapItem != null) {
            map = this.getDetails().optionDetails.processSuppliedOptions(mapItem, xPathContext);
        }
        return ParseJsonFn.parse(string, map, xPathContext);
    }

    public static Item parse(String string, Map<String, Sequence<?>> map, XPathContext xPathContext) {
        JsonParser jsonParser = new JsonParser();
        int n2 = 0;
        if (map != null) {
            n2 = JsonParser.getFlags(map, xPathContext, Boolean.FALSE);
        }
        JsonHandlerMap jsonHandlerMap = new JsonHandlerMap(xPathContext, n2);
        if ((n2 & 0x20) != 0) {
            throw new XPathException("parse-json: duplicates=retain is not allowed", "FOJS0005");
        }
        if ((n2 & 0x1E0) == 0) {
            n2 |= 0x80;
        }
        if (map != null) {
            jsonHandlerMap.setFallbackFunction(map, xPathContext);
        }
        jsonParser.parse(string, n2, jsonHandlerMap, xPathContext);
        return ((JsonHandler)jsonHandlerMap).getResult().head();
    }

    static {
        SpecificFunctionType specificFunctionType = new SpecificFunctionType(new SequenceType[]{SequenceType.SINGLE_STRING}, SequenceType.SINGLE_STRING);
        OptionsParameter optionsParameter = new OptionsParameter();
        optionsParameter.addAllowedOption("liberal", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        optionsParameter.addAllowedOption("duplicates", SequenceType.SINGLE_STRING, new StringValue("use-first"));
        optionsParameter.setAllowedValues("duplicates", "FOJS0005", "reject", "use-first", "use-last");
        optionsParameter.addAllowedOption("escape", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        optionsParameter.addAllowedOption("fallback", SequenceType.makeSequenceType(specificFunctionType, 16384), null);
        OPTION_DETAILS = optionsParameter;
    }
}

