/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class DictionaryMap
implements MapItem {
    private HashMap<String, GroundedValue<?>> a = new HashMap();

    public void initialPut(String string, GroundedValue<?> groundedValue) {
        this.a.put(string, groundedValue);
    }

    @Override
    public GroundedValue<?> get(AtomicValue atomicValue) {
        if (atomicValue instanceof StringValue) {
            return this.a.get(atomicValue.getStringValue());
        }
        return null;
    }

    @Override
    public int size() {
        return this.a.size();
    }

    @Override
    public boolean isEmpty() {
        return this.a.isEmpty();
    }

    @Override
    public AtomicIterator keys() {
        Iterator<String> iterator = this.a.keySet().iterator();
        return () -> {
            if (iterator.hasNext()) {
                return new StringValue((CharSequence)iterator.next());
            }
            return null;
        };
    }

    @Override
    public Iterable<KeyValuePair> keyValuePairs() {
        ArrayList<KeyValuePair> arrayList = new ArrayList<KeyValuePair>();
        this.a.forEach((? super K string, ? super V groundedValue) -> arrayList.add(new KeyValuePair(new StringValue((CharSequence)string), (GroundedValue<?>)groundedValue)));
        return arrayList;
    }

    @Override
    public MapItem addEntry(AtomicValue atomicValue, GroundedValue<?> groundedValue) {
        return this.a().addEntry(atomicValue, (GroundedValue)groundedValue);
    }

    @Override
    public MapItem remove(AtomicValue atomicValue) {
        return this.a().remove(atomicValue);
    }

    @Override
    public boolean conforms(AtomicType object, SequenceType sequenceType, TypeHierarchy typeHierarchy) {
        if (this.isEmpty()) {
            return true;
        }
        if (object != BuiltInAtomicType.STRING && object != BuiltInAtomicType.ANY_ATOMIC) {
            return false;
        }
        if (sequenceType.equals(SequenceType.ANY_SEQUENCE)) {
            return true;
        }
        for (GroundedValue<?> groundedValue : this.a.values()) {
            try {
                if (sequenceType.matches(groundedValue, typeHierarchy)) continue;
                return false;
            }
            catch (XPathException xPathException) {
                throw new AssertionError((Object)xPathException);
            }
        }
        return true;
    }

    @Override
    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        ItemType itemType = null;
        int n2 = 0;
        for (Map.Entry<String, GroundedValue<?>> entry : this.a.entrySet()) {
            GroundedValue<?> object = entry.getValue();
            if (itemType == null) {
                itemType = SequenceTool.getItemType(object, typeHierarchy);
                n2 = SequenceTool.getCardinality(object);
                continue;
            }
            itemType = Type.getCommonSuperType(itemType, SequenceTool.getItemType(object, typeHierarchy), typeHierarchy);
            n2 = Cardinality.union(n2, SequenceTool.getCardinality(object));
        }
        if (itemType == null) {
            return MapType.EMPTY_MAP_TYPE;
        }
        return new MapType(BuiltInAtomicType.STRING, SequenceType.makeSequenceType(itemType, n2));
    }

    @Override
    public UType getKeyUType() {
        if (this.a.isEmpty()) {
            return UType.VOID;
        }
        return UType.STRING;
    }

    private HashTrieMap a() {
        HashTrieMap hashTrieMap = new HashTrieMap();
        this.a.forEach((? super K string, ? super V groundedValue) -> hashTrieMap.initialPut(new StringValue((CharSequence)string), (GroundedValue<?>)groundedValue));
        return hashTrieMap;
    }
}

