/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import java.util.Iterator;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.ma.trie.ImmutableHashTrieMap;
import net.sf.saxon.ma.trie.ImmutableMap;
import net.sf.saxon.ma.trie.Tuple2;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class HashTrieMap
implements MapItem {
    public static final SequenceType SINGLE_MAP_TYPE = SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384);
    private ImmutableMap<AtomicMatchKey, KeyValuePair> a;
    private UType b = UType.VOID;
    private UType c = UType.VOID;
    private AtomicType d = ErrorType.getInstance();
    private ItemType e = ErrorType.getInstance();
    private int f = 0;
    private int g = -1;

    public HashTrieMap() {
        this.a = ImmutableHashTrieMap.empty();
        this.g = 0;
    }

    public static HashTrieMap singleton(AtomicValue atomicValue, GroundedValue<?> groundedValue) {
        return new HashTrieMap().addEntry(atomicValue, (GroundedValue)groundedValue);
    }

    public HashTrieMap(ImmutableMap<AtomicMatchKey, KeyValuePair> immutableMap) {
        this.a = immutableMap;
        this.g = -1;
    }

    public static HashTrieMap copy(MapItem object) {
        if (object instanceof HashTrieMap) {
            return (HashTrieMap)object;
        }
        MapItem mapItem = new HashTrieMap();
        for (KeyValuePair keyValuePair : object.keyValuePairs()) {
            mapItem = mapItem.addEntry(keyValuePair.key, (GroundedValue)keyValuePair.value);
        }
        return mapItem;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private void a(AtomicValue atomicValue, GroundedValue groundedValue, boolean bl2) {
        if (bl2) {
            this.b = atomicValue.getUType();
            this.c = SequenceTool.getUType(groundedValue);
            this.d = atomicValue.getItemType();
            this.e = MapItem.getItemTypeOfSequence(groundedValue);
            this.f = SequenceTool.getCardinality(groundedValue);
            return;
        }
        this.b = this.b.union(atomicValue.getUType());
        this.c = this.c.union(SequenceTool.getUType(groundedValue));
        this.f = Cardinality.union(this.f, SequenceTool.getCardinality(groundedValue));
        if (atomicValue.getItemType() != this.d) {
            this.d = null;
        }
        if (!MapItem.isKnownToConform(groundedValue, this.e)) {
            this.e = null;
        }
    }

    @Override
    public int size() {
        if (this.g >= 0) {
            return this.g;
        }
        int n2 = 0;
        Iterator<KeyValuePair> iterator = this.keyValuePairs().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++n2;
        }
        this.g = n2;
        return this.g;
    }

    @Override
    public boolean isEmpty() {
        return this.g == 0 || !this.a.iterator().hasNext();
    }

    @Override
    public boolean conforms(AtomicType atomicType, SequenceType sequenceType, TypeHierarchy typeHierarchy) {
        ItemType itemType;
        int n2;
        ItemType itemType2;
        int n3;
        if (this.isEmpty()) {
            return true;
        }
        if (this.d == atomicType && this.e == sequenceType.getPrimaryType() && Cardinality.subsumes(sequenceType.getCardinality(), this.f)) {
            return true;
        }
        boolean bl2 = false;
        if (atomicType != BuiltInAtomicType.ANY_ATOMIC && (n3 = typeHierarchy.relationship(atomicType, itemType2 = this.b.toItemType())) != 0 && n3 != 1) {
            if (n3 == 4) {
                return false;
            }
            bl2 = true;
        }
        if ((itemType2 = sequenceType.getPrimaryType()) != BuiltInAtomicType.ANY_ATOMIC && (n2 = typeHierarchy.relationship(itemType2, itemType = this.c.toItemType())) != 0 && n2 != 1) {
            if (n2 == 4) {
                return false;
            }
            bl2 = true;
        }
        if (!Cardinality.subsumes(n3 = sequenceType.getCardinality(), this.f)) {
            bl2 = true;
        }
        if (bl2) {
            GroundedValue<AtomicValue> groundedValue;
            AtomicIterator atomicIterator = this.keys();
            while ((groundedValue = atomicIterator.next()) != null) {
                if (!atomicType.matches((Item)groundedValue, typeHierarchy)) {
                    return false;
                }
                groundedValue = this.get((AtomicValue)groundedValue);
                try {
                    if (sequenceType.matches(groundedValue, typeHierarchy)) continue;
                    return false;
                }
                catch (XPathException xPathException) {
                    throw new AssertionError((Object)xPathException);
                }
            }
        }
        return true;
    }

    @Override
    public MapType getItemType(TypeHierarchy typeHierarchy) {
        AtomicValue atomicValue;
        ItemType itemType = null;
        ItemType itemType2 = null;
        int n2 = 0;
        AtomicIterator atomicIterator = this.keys();
        while ((atomicValue = atomicIterator.next()) != null) {
            GroundedValue<?> groundedValue = this.get(atomicValue);
            if (itemType == null) {
                itemType = atomicValue.getItemType();
                itemType2 = SequenceTool.getItemType(groundedValue, typeHierarchy);
                n2 = SequenceTool.getCardinality(groundedValue);
                continue;
            }
            itemType = (AtomicType)Type.getCommonSuperType(itemType, atomicValue.getItemType(), typeHierarchy);
            itemType2 = Type.getCommonSuperType(itemType2, SequenceTool.getItemType(groundedValue, typeHierarchy), typeHierarchy);
            n2 = Cardinality.union(n2, SequenceTool.getCardinality(groundedValue));
        }
        if (itemType == null) {
            this.b = UType.VOID;
            this.c = UType.VOID;
            this.f = 0;
            return MapType.ANY_MAP_TYPE;
        }
        this.b = itemType.getUType();
        this.c = itemType2.getUType();
        this.f = n2;
        return new MapType((AtomicType)itemType, SequenceType.makeSequenceType(itemType2, n2));
    }

    @Override
    public UType getKeyUType() {
        return this.b;
    }

    @Override
    public HashTrieMap addEntry(AtomicValue atomicValue, GroundedValue<?> groundedValue) {
        boolean bl2 = this.isEmpty();
        Object object = atomicValue;
        object = this.a.put(((AtomicValue)object).asMapKey(), new KeyValuePair(atomicValue, groundedValue));
        object = new HashTrieMap((ImmutableMap<AtomicMatchKey, KeyValuePair>)object);
        v0.f = this.f;
        ((HashTrieMap)object).b = this.b;
        ((HashTrieMap)object).c = this.c;
        ((HashTrieMap)object).d = this.d;
        ((HashTrieMap)object).e = this.e;
        super.a(atomicValue, groundedValue, bl2);
        return object;
    }

    public boolean initialPut(AtomicValue atomicValue, GroundedValue<?> groundedValue) {
        boolean bl2 = this.isEmpty();
        boolean bl3 = this.get(atomicValue) != null;
        AtomicValue atomicValue2 = atomicValue;
        this.a = this.a.put(atomicValue2.asMapKey(), new KeyValuePair(atomicValue, groundedValue));
        this.a(atomicValue, groundedValue, bl2);
        this.g = -1;
        return bl3;
    }

    @Override
    public HashTrieMap remove(AtomicValue object) {
        if ((object = this.a.remove(((AtomicValue)object).asMapKey())) == this.a) {
            return this;
        }
        object = new HashTrieMap((ImmutableMap<AtomicMatchKey, KeyValuePair>)object);
        v0.b = this.b;
        ((HashTrieMap)object).c = this.c;
        ((HashTrieMap)object).f = this.f;
        ((HashTrieMap)object).g = this.g - 1;
        return object;
    }

    @Override
    public GroundedValue<?> get(AtomicValue object) {
        if ((object = this.a.get(((AtomicValue)object).asMapKey())) == null) {
            return null;
        }
        return ((KeyValuePair)object).value;
    }

    public KeyValuePair getKeyValuePair(AtomicValue atomicValue) {
        return this.a.get(atomicValue.asMapKey());
    }

    @Override
    public AtomicIterator keys() {
        return new AtomicIterator(this){
            private Iterator<Tuple2<AtomicMatchKey, KeyValuePair>> a;
            private /* synthetic */ HashTrieMap b;
            {
                this.b = hashTrieMap;
                this.a = this.b.a.iterator();
            }

            @Override
            public final AtomicValue next() {
                if (this.a.hasNext()) {
                    return ((KeyValuePair)this.a.next()._2).key;
                }
                return null;
            }
        };
    }

    @Override
    public Iterable<KeyValuePair> keyValuePairs() {
        return () -> new Iterator<KeyValuePair>(this){
            private Iterator a;
            private /* synthetic */ HashTrieMap b;
            {
                this.b = hashTrieMap;
                this.a = this.b.a.iterator();
            }

            @Override
            public final boolean hasNext() {
                return this.a.hasNext();
            }

            @Override
            public final void remove() {
                this.a.remove();
            }
        };
    }

    public void diagnosticDump() {
        System.err.println("Map details:");
        Iterator<Tuple2<AtomicMatchKey, KeyValuePair>> iterator = this.a.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            AtomicMatchKey atomicMatchKey = (AtomicMatchKey)((Tuple2)object)._1;
            AtomicValue atomicValue = ((KeyValuePair)((Tuple2)object)._2).key;
            object = ((KeyValuePair)((Tuple2)object)._2).value;
            System.err.println(atomicMatchKey.getClass() + " " + atomicMatchKey + " #:" + atomicMatchKey.hashCode() + " = (" + atomicValue.getClass() + " " + atomicValue + " : " + object + ")");
        }
    }

    @Override
    public String toShortString() {
        int n2 = this.size();
        if (n2 == 0) {
            return "map{}";
        }
        if (n2 > 5) {
            return "map{(:size " + n2 + ":)}";
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
        fastStringBuffer.append("map{");
        Iterator<Tuple2<AtomicMatchKey, KeyValuePair>> iterator = this.a.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            AtomicMatchKey cfr_ignored_0 = (AtomicMatchKey)((Tuple2)object)._1;
            AtomicValue atomicValue = ((KeyValuePair)((Tuple2)object)._2).key;
            object = ((KeyValuePair)((Tuple2)object)._2).value;
            fastStringBuffer.append(atomicValue.toShortString());
            fastStringBuffer.append(':');
            fastStringBuffer.append(Err.depictSequence(object).toString().trim());
            fastStringBuffer.append(", ");
        }
        if (n2 == 1) {
            fastStringBuffer.append("}");
        } else {
            FastStringBuffer fastStringBuffer2 = fastStringBuffer;
            fastStringBuffer2.setCharAt(fastStringBuffer2.length() - 2, '}');
        }
        return fastStringBuffer.toString().trim();
    }

    public String toString() {
        return MapItem.mapToString(this);
    }
}

