/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.InsertBefore;
import net.sf.saxon.functions.OptionsParameter;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.ma.map.DictionaryMap;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.ma.map.MapUntypedContains;
import net.sf.saxon.ma.map.SingleEntryMap;
import net.sf.saxon.ma.map.TupleItemType;
import net.sf.saxon.ma.map.TupleType;
import net.sf.saxon.om.Chain;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class MapFunctionSet
extends BuiltInFunctionSet {
    public static MapFunctionSet THE_INSTANCE = new MapFunctionSet();

    public MapFunctionSet() {
        MapFunctionSet mapFunctionSet = this;
        mapFunctionSet.register("merge", 1, MapMerge.class, MapType.ANY_MAP_TYPE, 16384, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 0x100E000, null);
        Object object = new OptionsParameter();
        ((OptionsParameter)object).addAllowedOption("duplicates", SequenceType.SINGLE_STRING, new StringValue("use-first"));
        ((OptionsParameter)object).setAllowedValues("duplicates", "FOJS0005", "use-first", "use-last", "combine", "reject", "unspecified", "use-any");
        ((OptionsParameter)object).addAllowedOption("duplicates-error-code", SequenceType.SINGLE_STRING, new StringValue("FOJS0003"));
        ((OptionsParameter)object).addAllowedOption("Q{http://saxon.sf.net/}key-type", SequenceType.SINGLE_STRING, new StringValue("anyAtomicType"));
        ((OptionsParameter)object).addAllowedOption("Q{http://saxon.sf.net/}final", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        mapFunctionSet.register("merge", 2, MapMerge.class, MapType.ANY_MAP_TYPE, 16384, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 57344, null).arg(1, MapType.ANY_MAP_TYPE, 16384, null).optionDetails((OptionsParameter)object);
        mapFunctionSet.register("entry", 2, MapEntry.class, MapType.ANY_MAP_TYPE, 16384, 0, 0).arg(0, BuiltInAtomicType.ANY_ATOMIC, 0x2004000, null).arg(1, AnyItemType.getInstance(), 0x800E000, null);
        mapFunctionSet.register("find", 2, MapFind.class, ArrayItemType.getInstance(), 16384, 0, 0).arg(0, AnyItemType.getInstance(), 0x100E000, null).arg(1, BuiltInAtomicType.ANY_ATOMIC, 0x2004000, null);
        mapFunctionSet.register("get", 2, MapGet.class, AnyItemType.getInstance(), 57344, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.ANY_ATOMIC, 0x2004000, null);
        mapFunctionSet.register("put", 3, MapPut.class, MapType.ANY_MAP_TYPE, 16384, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.ANY_ATOMIC, 0x2004000, null).arg(2, AnyItemType.getInstance(), 0x800E000, null);
        mapFunctionSet.register("contains", 2, MapContains.class, BuiltInAtomicType.BOOLEAN, 16384, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.ANY_ATOMIC, 0x2004000, null);
        mapFunctionSet.register("remove", 2, MapRemove.class, MapType.ANY_MAP_TYPE, 16384, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.ANY_ATOMIC, 0x200E000, null);
        mapFunctionSet.register("keys", 1, MapKeys.class, BuiltInAtomicType.ANY_ATOMIC, 57344, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 0x1004000, null);
        mapFunctionSet.register("size", 1, MapSize.class, BuiltInAtomicType.INTEGER, 16384, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 0x1004000, null);
        object = new SpecificFunctionType(new SequenceType[]{SequenceType.SINGLE_ATOMIC, SequenceType.ANY_SEQUENCE}, SequenceType.ANY_SEQUENCE);
        mapFunctionSet.register("for-each", 2, MapForEach.class, AnyItemType.getInstance(), 57344, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 0x1004000, null).arg(1, (ItemType)object, 0x1004000, null);
        mapFunctionSet.register("untyped-contains", 2, MapUntypedContains.class, BuiltInAtomicType.BOOLEAN, 16384, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.ANY_ATOMIC, 0x2004000, null);
    }

    public static MapFunctionSet getInstance() {
        return THE_INSTANCE;
    }

    @Override
    public String getNamespace() {
        return "http://www.w3.org/2005/xpath-functions/map";
    }

    @Override
    public String getConventionalPrefix() {
        return "map";
    }

    public static class MapSize
    extends SystemFunction {
        public IntegerValue call(XPathContext object, Sequence[] sequenceArray) {
            object = (MapItem)sequenceArray[0].head();
            return new Int64Value(object.size());
        }
    }

    public static class MapRemove
    extends SystemFunction {
        public MapItem call(XPathContext object, Sequence[] object2) {
            AtomicValue atomicValue;
            object = (MapItem)object2[0].head();
            object2 = object2[1].iterate();
            while ((atomicValue = (AtomicValue)object2.next()) != null) {
                object = object.remove(atomicValue);
            }
            return object;
        }
    }

    public static class MapPut
    extends SystemFunction {
        public MapItem call(XPathContext object, Sequence[] object2) {
            object = (MapItem)object2[0].head();
            if (!(object instanceof HashTrieMap)) {
                object = HashTrieMap.copy((MapItem)object);
            }
            AtomicValue atomicValue = (AtomicValue)object2[1].head();
            object2 = object2[2].materialize();
            return object.addEntry(atomicValue, (GroundedValue<?>)object2);
        }
    }

    public static class MapMerge
    extends SystemFunction {
        private String a = "use-first";
        private String b = "FOJS0003";
        private boolean c = false;
        private boolean d = false;

        @Override
        public Expression makeOptimizedFunctionCall(ExpressionVisitor object, ContextItemStaticInfo object2, Expression ... expressionArray) {
            if (expressionArray.length == 2 && expressionArray[1] instanceof Literal) {
                object2 = (MapItem)((Literal)expressionArray[1]).getValue().head();
                object = this.getDetails().optionDetails.processSuppliedOptions((MapItem)object2, ((ExpressionVisitor)object).getStaticContext().makeEarlyEvaluationContext());
                object2 = ((StringValue)object.get("duplicates")).getStringValue();
                String string = ((StringValue)object.get("duplicates-error-code")).getStringValue();
                boolean bl2 = ((BooleanValue)object.get("Q{http://saxon.sf.net/}final")).getBooleanValue();
                object = ((StringValue)object.get("Q{http://saxon.sf.net/}key-type")).getStringValue();
                MapMerge mapMerge = (MapMerge)MapFunctionSet.getInstance().makeFunction("merge", 1);
                ((MapMerge)MapFunctionSet.getInstance().makeFunction("merge", 1)).a = object2;
                mapMerge.b = string;
                mapMerge.c = ((String)object).equals("string");
                mapMerge.d = bl2;
                return mapMerge.makeFunctionCall(expressionArray[0]);
            }
            return super.makeOptimizedFunctionCall((ExpressionVisitor)object, (ContextItemStaticInfo)object2, expressionArray);
        }

        @Override
        public ItemType getResultItemType(Expression[] object) {
            ItemType itemType = object[0].getItemType();
            if (itemType == ErrorType.getInstance()) {
                return MapType.EMPTY_MAP_TYPE;
            }
            if (itemType instanceof MapType) {
                boolean bl2 = true;
                if (((Expression[])object).length == 1) {
                    bl2 = false;
                } else if (object[1] instanceof Literal) {
                    object = (MapItem)((Literal)object[1]).getValue().head();
                    object = object.get(new StringValue("duplicates"));
                    try {
                        if (object == null || !"combine".equals(object.getStringValue())) {
                            bl2 = false;
                        }
                    }
                    catch (XPathException xPathException) {}
                }
                if (bl2) {
                    return new MapType(((MapType)itemType).getKeyType(), SequenceType.makeSequenceType(((MapType)itemType).getValueType().getPrimaryType(), 57344));
                }
                return itemType;
            }
            return super.getResultItemType((Expression[])object);
        }

        public MapItem call(XPathContext object, Sequence[] object2) {
            String string = this.a;
            String string2 = this.b;
            boolean bl2 = this.c;
            int n2 = this.d;
            if (((Sequence[])object2).length > 1) {
                MapItem mapItem = (MapItem)object2[1].head();
                object = this.getDetails().optionDetails.processSuppliedOptions(mapItem, (XPathContext)object);
                string = ((StringValue)object.get("duplicates")).getStringValue();
                string2 = ((StringValue)object.get("duplicates-error-code")).getStringValue();
                n2 = ((BooleanValue)object.get("Q{http://saxon.sf.net/}final")).getBooleanValue() ? 1 : 0;
                bl2 = "string".equals(((StringValue)object.get("Q{http://saxon.sf.net/}key-type")).getStringValue());
            }
            if (n2 != 0 && bl2) {
                SequenceIterator sequenceIterator = object2[0].iterate();
                object = new DictionaryMap();
                switch (string) {
                    case "unspecified": 
                    case "use-any": 
                    case "use-last": {
                        while ((object2 = (MapItem)sequenceIterator.next()) != null) {
                            for (KeyValuePair keyValuePair : object2.keyValuePairs()) {
                                if (!(keyValuePair.key instanceof StringValue)) {
                                    throw new XPathException("The keys in this map must all be strings (found " + keyValuePair.key.getItemType() + ")");
                                }
                                ((DictionaryMap)object).initialPut(keyValuePair.key.getStringValue(), keyValuePair.value);
                            }
                        }
                        break;
                    }
                }
                while ((object2 = (MapItem)sequenceIterator.next()) != null) {
                    block35: for (KeyValuePair keyValuePair : object2.keyValuePairs()) {
                        if (!(keyValuePair.key instanceof StringValue)) {
                            throw new XPathException("The keys in this map must all be strings (found " + keyValuePair.key.getItemType() + ")");
                        }
                        GroundedValue<?> groundedValue = ((DictionaryMap)object).get(keyValuePair.key);
                        if (groundedValue != null) {
                            switch (string) {
                                case "use-first": 
                                case "unspecified": 
                                case "use-any": {
                                    continue block35;
                                }
                                case "use-last": {
                                    ((DictionaryMap)object).initialPut(keyValuePair.key.getStringValue(), keyValuePair.value);
                                    continue block35;
                                }
                                case "combine": {
                                    object2 = new InsertBefore.InsertIterator(keyValuePair.value.iterate(), groundedValue.iterate(), 1);
                                    object2 = object2.materialize();
                                    ((DictionaryMap)object).initialPut(keyValuePair.key.getStringValue(), (GroundedValue<?>)object2);
                                    continue block35;
                                }
                            }
                            throw new XPathException("Duplicate key in constructed map: " + Err.wrap(keyValuePair.key.getStringValueCS()), string2);
                        }
                        ((DictionaryMap)object).initialPut(keyValuePair.key.getStringValue(), keyValuePair.value);
                    }
                }
                return object;
            }
            SequenceIterator sequenceIterator = object2[0].iterate();
            object = (MapItem)sequenceIterator.next();
            if (object == null) {
                return new HashTrieMap();
            }
            if (!(object instanceof HashTrieMap)) {
                object = HashTrieMap.copy(object);
            }
            while ((object2 = (MapItem)sequenceIterator.next()) != null) {
                object2 = object2.keyValuePairs().iterator();
                block37: while (object2.hasNext()) {
                    KeyValuePair keyValuePair = (KeyValuePair)object2.next();
                    GroundedValue<?> groundedValue = object.get(keyValuePair.key);
                    if (groundedValue != null) {
                        switch (string) {
                            case "use-first": 
                            case "unspecified": 
                            case "use-any": {
                                continue block37;
                            }
                            case "use-last": {
                                object = object.addEntry(keyValuePair.key, keyValuePair.value);
                                continue block37;
                            }
                            case "combine": {
                                InsertBefore.InsertIterator insertIterator = new InsertBefore.InsertIterator(keyValuePair.value.iterate(), groundedValue.iterate(), 1);
                                GroundedValue groundedValue2 = insertIterator.materialize();
                                object = object.addEntry(keyValuePair.key, groundedValue2);
                                continue block37;
                            }
                        }
                        throw new XPathException("Duplicate key in constructed map: " + Err.wrap(keyValuePair.key.getStringValueCS()), string2);
                    }
                    object = object.addEntry(keyValuePair.key, keyValuePair.value);
                }
            }
            return object;
        }

        @Override
        public String getStreamerName() {
            return "NewMap";
        }

        @Override
        public void exportAdditionalArguments(SystemFunctionCall callable, ExpressionPresenter expressionPresenter) {
            if (((FunctionCall)((Object)callable)).getArity() == 1) {
                callable = new HashTrieMap();
                ((HashTrieMap)callable).initialPut(new StringValue("duplicates"), new StringValue(this.a));
                ((HashTrieMap)callable).initialPut(new StringValue("duplicates-error-code"), new StringValue(this.b));
                Literal.exportValue(callable, expressionPresenter);
            }
        }
    }

    public static class MapKeys
    extends SystemFunction {
        public Sequence<? extends Item<AtomicValue>> call(XPathContext object, Sequence[] sequenceArray) {
            object = (MapItem)sequenceArray[0].head();
            assert (object != null);
            return SequenceTool.toLazySequence(object.keys());
        }
    }

    public static class MapForEach
    extends SystemFunction {
        @Override
        public Sequence<?> call(XPathContext xPathContext, Sequence[] object) {
            MapItem mapItem = (MapItem)object[0].head();
            object = (Function)object[1].head();
            ArrayList arrayList = new ArrayList();
            for (KeyValuePair keyValuePair : mapItem.keyValuePairs()) {
                Sequence<?> object2 = MapForEach.dynamicCall((Function)object, xPathContext, new Sequence[]{keyValuePair.key, keyValuePair.value});
                arrayList.add(object2.materialize());
            }
            return new Chain(arrayList);
        }
    }

    public static class MapEntry
    extends SystemFunction {
        @Override
        public Sequence<?> call(XPathContext object, Sequence[] object2) {
            object = (AtomicValue)object2[0].head();
            assert (object != null);
            object2 = object2[1].iterate().materialize();
            return new SingleEntryMap((AtomicValue)object, (GroundedValue<?>)object2);
        }

        @Override
        public ItemType getResultItemType(Expression[] expressionArray) {
            PlainType plainType = expressionArray[0].getItemType().getAtomizedItemType();
            plainType = plainType instanceof AtomicType ? (AtomicType)plainType : plainType.getPrimitiveItemType();
            return new MapType((AtomicType)plainType, SequenceType.makeSequenceType(expressionArray[1].getItemType(), expressionArray[1].getCardinality()));
        }

        @Override
        public String getStreamerName() {
            return "MapEntry";
        }
    }

    public static class MapFind
    extends SystemFunction {
        public ArrayItem call(XPathContext object, Sequence[] sequenceArray) {
            object = new ArrayList();
            AtomicValue atomicValue = (AtomicValue)sequenceArray[1].head();
            this.a(sequenceArray[0], atomicValue, (List<GroundedValue<?>>)object);
            return new SimpleArrayItem((List<GroundedValue<?>>)object);
        }

        private void a(Sequence<?> sequence, AtomicValue atomicValue, List<GroundedValue<?>> list) {
            sequence.iterate().forEachOrFail(object2 -> {
                if (object2 instanceof ArrayItem) {
                    for (Sequence sequence : ((ArrayItem)object2).members()) {
                        this.a(sequence, atomicValue, list);
                    }
                    return;
                }
                if (object2 instanceof MapItem) {
                    GroundedValue<?> groundedValue = ((MapItem)object2).get(atomicValue);
                    if (groundedValue != null) {
                        list.add(groundedValue);
                    }
                    for (KeyValuePair keyValuePair : ((MapItem)object2).keyValuePairs()) {
                        this.a(keyValuePair.value, atomicValue, list);
                    }
                }
            });
        }
    }

    public static class MapGet
    extends SystemFunction {
        private String a = null;

        @Override
        public void supplyTypeInformation(ExpressionVisitor object, ContextItemStaticInfo object2, Expression[] expressionArray) {
            object2 = expressionArray[0].getItemType();
            if (object2 instanceof TupleType) {
                Object object3;
                if (expressionArray[1] instanceof Literal && ((TupleType)object2).getFieldType((String)(object3 = ((Literal)expressionArray[1]).getValue().getStringValue())) == null) {
                    object = new XPathException("Field " + (String)object3 + " is not defined for tuple type " + object2, "SXTT0001");
                    ((XPathException)object).setIsTypeError(true);
                    throw object;
                }
                object3 = ((ExpressionVisitor)object).getConfiguration().getTypeHierarchy();
                int n2 = ((TypeHierarchy)object3).relationship(expressionArray[1].getItemType(), BuiltInAtomicType.STRING);
                if (n2 == 4) {
                    XPathException xPathException = new XPathException("Key for tuple type must be a string (actual type is " + expressionArray[1].getItemType(), "XPTY0004");
                    xPathException.setIsTypeError(true);
                    throw xPathException;
                }
            }
        }

        @Override
        public ItemType getResultItemType(Expression[] object) {
            Object object2 = object[0].getItemType();
            if (object2 instanceof TupleItemType && object[1] instanceof StringLiteral) {
                object = ((StringLiteral)object[1]).getStringValue();
                object2 = (TupleItemType)object2;
                if ((object2 = ((TupleItemType)object2).getFieldType((String)object)) == null) {
                    this.a("Field " + (String)object + " is not defined in tuple type");
                    return AnyItemType.getInstance();
                }
                return ((SequenceType)object2).getPrimaryType();
            }
            if (object2 instanceof MapType) {
                return ((MapType)object2).getValueType().getPrimaryType();
            }
            return super.getResultItemType((Expression[])object);
        }

        @Override
        public int getCardinality(Expression[] object) {
            Object object2 = object[0].getItemType();
            if (object2 instanceof TupleItemType && object[1] instanceof StringLiteral) {
                object = ((StringLiteral)object[1]).getStringValue();
                object2 = (TupleItemType)object2;
                if ((object2 = ((TupleItemType)object2).getFieldType((String)object)) == null) {
                    this.a("Field " + (String)object + " is not defined in tuple type");
                    return 32768;
                }
                return ((SequenceType)object2).getCardinality();
            }
            if (object2 instanceof MapType) {
                return Cardinality.union(((MapType)object2).getValueType().getCardinality(), 8192);
            }
            return super.getCardinality((Expression[])object);
        }

        @Override
        public Expression makeOptimizedFunctionCall(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo, Expression ... expressionArray) {
            if (this.a != null && !this.a.equals("DONE")) {
                expressionVisitor.issueWarning(this.a, expressionArray[0].getLocation());
                this.a = "DONE";
            }
            return null;
        }

        private void a(String string) {
            if (!"DONE".equals(this.a)) {
                this.a = string;
            }
        }

        @Override
        public Sequence<?> call(XPathContext groundedValue, Sequence[] object) {
            groundedValue = (MapItem)object[0].head();
            assert (groundedValue != null);
            if ((groundedValue = groundedValue.get((AtomicValue)(object = (AtomicValue)object[1].head()))) == null) {
                return EmptySequence.getInstance();
            }
            return groundedValue;
        }
    }

    public static class MapContains
    extends SystemFunction {
        public BooleanValue call(XPathContext object, Sequence[] object2) {
            object = (MapItem)object2[0].head();
            return BooleanValue.get(object.get((AtomicValue)(object2 = (AtomicValue)object2[1].head())) != null);
        }
    }
}

