/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public interface MapItem
extends Function {
    public GroundedValue<?> get(AtomicValue var1);

    public int size();

    public boolean isEmpty();

    public AtomicIterator keys();

    public Iterable<KeyValuePair> keyValuePairs();

    public MapItem addEntry(AtomicValue var1, GroundedValue<?> var2);

    public MapItem remove(AtomicValue var1);

    public boolean conforms(AtomicType var1, SequenceType var2, TypeHierarchy var3);

    public ItemType getItemType(TypeHierarchy var1);

    public UType getKeyUType();

    @Override
    default public String toShortString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("map{");
        int n2 = 0;
        for (KeyValuePair keyValuePair : this.keyValuePairs()) {
            if (n2++ > 2) {
                stringBuilder.append(" ...");
                break;
            }
            stringBuilder.append(keyValuePair.key.toShortString());
            stringBuilder.append(":");
            stringBuilder.append(keyValuePair.value.toShortString());
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    default public Genre getGenre() {
        return Genre.MAP;
    }

    @Override
    default public boolean isArray() {
        return false;
    }

    @Override
    default public boolean isMap() {
        return true;
    }

    @Override
    default public AnnotationList getAnnotations() {
        return AnnotationList.EMPTY;
    }

    @Override
    default public AtomicSequence atomize() {
        throw new XPathException("Cannot atomize a map (" + this.toShortString() + ")", "FOTY0013");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isKnownToConform(Sequence<?> sequenceIterator, ItemType itemType) {
        if (itemType == AnyItemType.getInstance()) {
            return true;
        }
        try {
            sequenceIterator = sequenceIterator.iterate();
            while (true) {
                Object t2;
                if ((t2 = sequenceIterator.next()) == null) {
                    return true;
                }
                if (t2 instanceof AtomicValue) {
                    if (!(itemType instanceof AtomicType)) {
                        return false;
                    }
                    if (Type.isSubType(((AtomicValue)t2).getItemType(), (AtomicType)itemType)) continue;
                    return false;
                }
                if (!(t2 instanceof NodeInfo)) {
                    return false;
                }
                if (!(itemType instanceof NodeTest)) {
                    return false;
                }
                if (!((NodeTest)itemType).matchesNode((NodeInfo)t2)) break;
            }
            return false;
        }
        catch (XPathException xPathException) {
            return false;
        }
    }

    public static ItemType getItemTypeOfSequence(Sequence<?> sequence) {
        try {
            Object object = sequence.head();
            if (object == null) {
                return AnyItemType.getInstance();
            }
            if (MapItem.isKnownToConform(sequence, object = object instanceof AtomicValue ? ((AtomicValue)object).getItemType() : (object instanceof NodeInfo ? NodeKindTest.makeNodeKindTest(((NodeInfo)object).getNodeKind()) : AnyFunctionType.getInstance()))) {
                return object;
            }
            return AnyItemType.getInstance();
        }
        catch (XPathException xPathException) {
            return AnyItemType.getInstance();
        }
    }

    @Override
    default public OperandRole[] getOperandRoles() {
        return new OperandRole[]{OperandRole.SINGLE_ATOMIC};
    }

    @Override
    default public FunctionItemType getFunctionItemType() {
        return MapType.ANY_MAP_TYPE;
    }

    @Override
    default public StructuredQName getFunctionName() {
        return null;
    }

    @Override
    default public String getDescription() {
        return "map";
    }

    @Override
    default public int getArity() {
        return 1;
    }

    @Override
    default public XPathContext makeNewContext(XPathContext xPathContext, ContextOriginator contextOriginator) {
        return xPathContext;
    }

    @Override
    default public Sequence<?> call(XPathContext groundedValue, Sequence[] sequenceArray) {
        groundedValue = (AtomicValue)sequenceArray[0].head();
        if ((groundedValue = this.get((AtomicValue)groundedValue)) == null) {
            return EmptySequence.getInstance();
        }
        return groundedValue;
    }

    @Override
    default public String getStringValue() {
        throw new UnsupportedOperationException("A map has no string value");
    }

    @Override
    default public CharSequence getStringValueCS() {
        throw new UnsupportedOperationException("A map has no string value");
    }

    default public SequenceIterator getTypedValue() {
        throw new XPathException("A map has no typed value");
    }

    @Override
    default public boolean deepEquals(Function function, XPathContext xPathContext, AtomicComparer atomicComparer, int n2) {
        if (function instanceof MapItem && ((MapItem)function).size() == this.size()) {
            GroundedValue<AtomicValue> groundedValue;
            AtomicIterator atomicIterator = this.keys();
            while ((groundedValue = atomicIterator.next()) != null) {
                GroundedValue<?> groundedValue2 = this.get((AtomicValue)groundedValue);
                if ((groundedValue = ((MapItem)function).get((AtomicValue)groundedValue)) == null) {
                    return false;
                }
                if (DeepEqual.deepEqual(groundedValue.iterate(), groundedValue2.iterate(), atomicComparer, xPathContext, n2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    default public MapItem itemAt(int n2) {
        if (n2 == 0) {
            return this;
        }
        return null;
    }

    @Override
    default public boolean effectiveBooleanValue() {
        throw new XPathException("A map item has no effective boolean value");
    }

    public static String mapToString(MapItem object) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
        fastStringBuffer.append("map{");
        for (KeyValuePair keyValuePair : object.keyValuePairs()) {
            if (fastStringBuffer.length() > 4) {
                fastStringBuffer.append(",");
            }
            fastStringBuffer.append(keyValuePair.key.toString());
            fastStringBuffer.append(":");
            fastStringBuffer.append(keyValuePair.value.toString());
        }
        fastStringBuffer.append("}");
        return fastStringBuffer.toString();
    }

    @Override
    default public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("map");
        expressionPresenter.emitAttribute("size", "" + this.size());
        for (KeyValuePair keyValuePair : this.keyValuePairs()) {
            Literal.exportAtomicValue(keyValuePair.key, expressionPresenter);
            Literal.exportValue(keyValuePair.value, expressionPresenter);
        }
        expressionPresenter.endElement();
    }

    @Override
    default public boolean isTrustedResultType() {
        return true;
    }
}

