/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import java.util.Optional;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.TupleItemType;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class MapType
extends AnyFunctionType {
    public static final MapType ANY_MAP_TYPE = new MapType(BuiltInAtomicType.ANY_ATOMIC, SequenceType.ANY_SEQUENCE);
    public static final MapType EMPTY_MAP_TYPE = new MapType(BuiltInAtomicType.ANY_ATOMIC, SequenceType.ANY_SEQUENCE, true);
    public static final SequenceType OPTIONAL_MAP_ITEM = SequenceType.makeSequenceType(ANY_MAP_TYPE, 24576);
    public static final SequenceType SINGLE_MAP_ITEM = SequenceType.makeSequenceType(ANY_MAP_TYPE, 16384);
    public static final SequenceType SEQUENCE_OF_MAPS = SequenceType.makeSequenceType(ANY_MAP_TYPE, 57344);
    private AtomicType a;
    private SequenceType b;
    private boolean c;

    public MapType(AtomicType atomicType, SequenceType sequenceType) {
        this.a = atomicType;
        this.b = sequenceType;
        this.c = false;
    }

    public MapType(AtomicType atomicType, SequenceType sequenceType, boolean bl2) {
        this.a = atomicType;
        this.b = sequenceType;
        this.c = bl2;
    }

    @Override
    public Genre getGenre() {
        return Genre.MAP;
    }

    public AtomicType getKeyType() {
        return this.a;
    }

    public SequenceType getValueType() {
        return this.b;
    }

    @Override
    public boolean isMapType() {
        return true;
    }

    @Override
    public boolean isArrayType() {
        return false;
    }

    @Override
    public String getAlphaCode() {
        return "FM";
    }

    @Override
    public boolean isAtomizable(TypeHierarchy typeHierarchy) {
        return false;
    }

    @Override
    public boolean matches(Item item, TypeHierarchy typeHierarchy) {
        if (!(item instanceof MapItem)) {
            return false;
        }
        if (((MapItem)item).isEmpty()) {
            return true;
        }
        if (this.c) {
            return false;
        }
        if (this == ANY_MAP_TYPE) {
            return true;
        }
        return ((MapItem)item).conforms(this.a, this.b, typeHierarchy);
    }

    public int getArity() {
        return 1;
    }

    @Override
    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, 16384)};
    }

    @Override
    public SequenceType getResultType() {
        if (Cardinality.allowsZero(this.b.getCardinality())) {
            return this.b;
        }
        return SequenceType.makeSequenceType(this.b.getPrimaryType(), Cardinality.union(this.b.getCardinality(), 8192));
    }

    @Override
    public String toString() {
        if (this == ANY_MAP_TYPE) {
            return "map(*)";
        }
        if (this == EMPTY_MAP_TYPE) {
            return "map(\u00b0)";
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
        fastStringBuffer.append("map(");
        fastStringBuffer.append(this.a.toString());
        fastStringBuffer.append(", ");
        fastStringBuffer.append(this.b.toString());
        fastStringBuffer.append(")");
        return fastStringBuffer.toString();
    }

    @Override
    public String toExportString() {
        if (this == ANY_MAP_TYPE) {
            return "map(*)";
        }
        if (this == EMPTY_MAP_TYPE) {
            return "map(\u00b0)";
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
        fastStringBuffer.append("map(");
        fastStringBuffer.append(this.a.toExportString());
        fastStringBuffer.append(", ");
        fastStringBuffer.append(this.b.toExportString());
        fastStringBuffer.append(")");
        return fastStringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MapType) {
            object = (MapType)object;
            return this.a.equals(((MapType)object).a) && this.b.equals(((MapType)object).b) && this.c == ((MapType)object).c;
        }
        return false;
    }

    public int hashCode() {
        return this.a.hashCode() ^ this.b.hashCode();
    }

    @Override
    public int relationship(FunctionItemType functionItemType, TypeHierarchy typeHierarchy) {
        if (functionItemType == AnyFunctionType.getInstance()) {
            return 2;
        }
        if (this.equals(functionItemType)) {
            return 0;
        }
        if (functionItemType == ANY_MAP_TYPE) {
            return 2;
        }
        if (functionItemType.isArrayType()) {
            return 4;
        }
        if (functionItemType instanceof TupleItemType) {
            return TypeHierarchy.inverseRelationship(functionItemType.relationship(this, typeHierarchy));
        }
        if (functionItemType instanceof MapType) {
            functionItemType = (MapType)functionItemType;
            int n2 = typeHierarchy.relationship(this.a, ((MapType)functionItemType).a);
            if (n2 == 4) {
                return 3;
            }
            int n3 = typeHierarchy.sequenceTypeRelationship(this.b, ((MapType)functionItemType).b);
            if (n3 == 4) {
                return 3;
            }
            if (n2 == n3) {
                return n2;
            }
            if (!(n2 != 0 && n2 != 1 || n3 != 0 && n3 != 1)) {
                return 1;
            }
            if (!(n2 != 0 && n2 != 2 || n3 != 0 && n3 != 2)) {
                return 2;
            }
            return 3;
        }
        return 4;
    }

    @Override
    public Optional<String> explainMismatch(Item object, TypeHierarchy typeHierarchy) {
        if (object instanceof MapItem) {
            for (KeyValuePair optional : ((MapItem)((Object)object)).keyValuePairs()) {
                if (!this.a.matches(optional.key, typeHierarchy)) {
                    String string = "The map contains a key (" + optional.key + ") of type " + optional.key.getItemType() + " that is not an instance of the required type " + this.a;
                    return Optional.of(string);
                }
                try {
                    if (this.b.matches(optional.value, typeHierarchy)) continue;
                    String string = "The map contains an entry with key (" + optional.key + ") whose corresponding value (" + Err.depictSequence(optional.value) + ") is not an instance of the required type " + this.b;
                    Optional<String> optional2 = this.b.explainMismatch(optional.value, typeHierarchy);
                    if (optional2.isPresent()) {
                        string = string + ". " + optional2.get();
                    }
                    return Optional.of(string);
                }
                catch (XPathException xPathException) {
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public Expression makeFunctionSequenceCoercer(Expression expression, RoleDiagnostic roleDiagnostic) {
        return expression;
    }

    @Override
    public String generateJavaScriptItemTypeTest(ItemType object, int n2) {
        if (this == ANY_MAP_TYPE) {
            return "return SaxonJS.U.isMap(item)";
        }
        object = new FastStringBuffer(256);
        ((FastStringBuffer)object).append("function k(item) {" + this.a.generateJavaScriptItemTypeTest(BuiltInAtomicType.ANY_ATOMIC, n2) + "};");
        ((FastStringBuffer)object).append("function v(item) {" + this.b.getPrimaryType().generateJavaScriptItemTypeTest(AnyItemType.getInstance(), n2) + "};");
        int n3 = this.b.getCardinality();
        ((FastStringBuffer)object).append(Cardinality.generateJavaScriptChecker(n3));
        if (n2 == 1) {
            ((FastStringBuffer)object).append("return SaxonJS.U.isMap(item) && item.conforms(k, v, c);");
        } else {
            ((FastStringBuffer)object).append("return SaxonJS.U.isConstrainedMap(item, k, v, c);");
        }
        return ((FastStringBuffer)object).toString();
    }
}

