/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.CodepointMatchKey;
import net.sf.saxon.functions.Count;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class RangeKey
implements MapItem {
    private CodepointMatchKey a;
    private CodepointMatchKey b;
    private TreeMap<AtomicMatchKey, List<NodeInfo>> c;

    public RangeKey(String string, String string2, TreeMap<AtomicMatchKey, List<NodeInfo>> treeMap) {
        this.a = string == null ? null : new CodepointMatchKey(string);
        this.b = string2 == null ? null : new CodepointMatchKey(string2);
        this.c = treeMap;
    }

    @Override
    public GroundedValue<?> get(AtomicValue list) {
        list = new CodepointMatchKey(((AtomicValue)((Object)list)).getStringValue());
        if (!(this.a != null && this.a.compareTo((CodepointMatchKey)((Object)list)) > 0 || this.b != null && this.b.compareTo((CodepointMatchKey)((Object)list)) < 0)) {
            if ((list = this.c.get(list)) == null) {
                return EmptySequence.getInstance();
            }
            return SequenceExtent.makeSequenceExtent(list);
        }
        return EmptySequence.getInstance();
    }

    @Override
    public int size() {
        try {
            return Count.count(this.keys());
        }
        catch (XPathException xPathException) {
            return 0;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.keys().next() == null;
    }

    @Override
    public AtomicIterator keys() {
        return new a(this);
    }

    @Override
    public Iterable<KeyValuePair> keyValuePairs() {
        return () -> new Iterator<KeyValuePair>(this){
            private AtomicIterator a;
            private AtomicValue b;
            private /* synthetic */ RangeKey c;
            {
                this.c = rangeKey;
                this.a = this.c.keys();
                this.b = this.a.next();
            }

            @Override
            public final boolean hasNext() {
                return this.b != null;
            }

            @Override
            public final /* synthetic */ Object next() {
                1 var1_1 = this;
                if (var1_1.b == null) {
                    return null;
                }
                KeyValuePair keyValuePair = new KeyValuePair(var1_1.b, var1_1.c.get(var1_1.b));
                var1_1.b = var1_1.a.next();
                return keyValuePair;
            }
        };
    }

    @Override
    public MapItem remove(AtomicValue atomicValue) {
        return HashTrieMap.copy(this).remove(atomicValue);
    }

    @Override
    public UType getKeyUType() {
        return UType.STRING;
    }

    @Override
    public MapItem addEntry(AtomicValue atomicValue, GroundedValue<?> groundedValue) {
        return HashTrieMap.copy(this).addEntry(atomicValue, (GroundedValue)groundedValue);
    }

    @Override
    public boolean conforms(AtomicType object, SequenceType sequenceType, TypeHierarchy typeHierarchy) {
        GroundedValue<AtomicValue> groundedValue;
        object = this.keys();
        while ((groundedValue = object.next()) != null) {
            groundedValue = this.get((AtomicValue)groundedValue);
            try {
                if (sequenceType.matches(groundedValue, typeHierarchy)) continue;
                return false;
            }
            catch (XPathException xPathException) {
                throw new AssertionError((Object)xPathException);
            }
        }
        return true;
    }

    @Override
    public MapType getItemType(TypeHierarchy typeHierarchy) {
        return new MapType(BuiltInAtomicType.STRING, SequenceType.NODE_SEQUENCE);
    }

    @Override
    public MapType getFunctionItemType() {
        return new MapType(BuiltInAtomicType.STRING, SequenceType.NODE_SEQUENCE);
    }

    @Override
    public String getDescription() {
        return "range key";
    }

    @Override
    public boolean deepEquals(Function function, XPathContext xPathContext, AtomicComparer atomicComparer, int n2) {
        if (function instanceof RangeKey) {
            function = (RangeKey)function;
            return this.a.equals(((RangeKey)function).a) && this.b.equals(((RangeKey)function).b) && this.c.equals(((RangeKey)function).c);
        }
        return false;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("range-key-map");
        expressionPresenter.emitAttribute("size", "" + this.size());
        expressionPresenter.endElement();
    }

    @Override
    public boolean isTrustedResultType() {
        return false;
    }

    public String toString() {
        return MapItem.mapToString(this);
    }

    private final class a
    implements AtomicIterator {
        private int a = 0;
        private CodepointMatchKey b = null;
        private CodepointMatchKey c;
        private /* synthetic */ RangeKey d;

        public a(RangeKey rangeKey) {
            this.d = rangeKey;
            this.c = (CodepointMatchKey)(rangeKey.b == null ? (AtomicMatchKey)rangeKey.c.lastKey() : (AtomicMatchKey)rangeKey.c.floorKey(rangeKey.b));
        }

        private StringValue a() {
            if (this.a <= 0) {
                if (this.a < 0) {
                    return null;
                }
                if (this.d.a == null) {
                    this.b = (CodepointMatchKey)this.d.c.firstKey();
                } else {
                    this.b = this.d.c.ceilingKey(this.d.a);
                    if (this.b != null && this.d.b != null && this.b.compareTo(this.d.b) > 0) {
                        this.b = null;
                    }
                }
            } else {
                this.b = this.b.equals(this.c) ? null : this.d.c.higherKey(this.b);
            }
            if (this.b == null) {
                this.a = -1;
                return null;
            }
            ++this.a;
            return new StringValue(this.b.getValue());
        }

        @Override
        public final /* synthetic */ AtomicValue next() {
            return this.a();
        }

        @Override
        public final /* synthetic */ Item next() {
            return this.a();
        }
    }
}

