/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.SingleAtomicIterator;
import net.sf.saxon.tree.jiter.MonoIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;

public class SingleEntryMap
implements MapItem {
    public AtomicValue key;
    public GroundedValue<?> value;

    public SingleEntryMap(AtomicValue atomicValue, GroundedValue<?> groundedValue) {
        this.key = atomicValue;
        this.value = groundedValue;
    }

    @Override
    public GroundedValue<?> get(AtomicValue atomicValue) {
        if (this.key.asMapKey().equals(atomicValue.asMapKey())) {
            return this.value;
        }
        return null;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public AtomicIterator keys() {
        return new SingleAtomicIterator(this.key);
    }

    @Override
    public Iterable<KeyValuePair> keyValuePairs() {
        return () -> new MonoIterator<KeyValuePair>(new KeyValuePair(this.key, this.value));
    }

    @Override
    public MapItem addEntry(AtomicValue atomicValue, GroundedValue<?> groundedValue) {
        SingleEntryMap singleEntryMap = this;
        HashTrieMap hashTrieMap = new HashTrieMap();
        hashTrieMap.initialPut(singleEntryMap.key, singleEntryMap.value);
        return hashTrieMap.addEntry(atomicValue, (GroundedValue)groundedValue);
    }

    @Override
    public MapItem remove(AtomicValue atomicValue) {
        if (this.get(atomicValue) == null) {
            return this;
        }
        return new HashTrieMap();
    }

    @Override
    public boolean conforms(AtomicType atomicType, SequenceType sequenceType, TypeHierarchy typeHierarchy) {
        try {
            return atomicType.matches(this.key, typeHierarchy) && sequenceType.matches(this.value, typeHierarchy);
        }
        catch (XPathException xPathException) {
            throw new AssertionError((Object)xPathException);
        }
    }

    @Override
    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return new MapType(this.key.getItemType(), SequenceType.makeSequenceType(SequenceTool.getItemType(this.value, typeHierarchy), SequenceTool.getCardinality(this.value)));
    }

    @Override
    public UType getKeyUType() {
        return this.key.getUType();
    }
}

