/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.ma.map.TupleType;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class TupleItemType
extends AnyFunctionType
implements TupleType {
    private Map<String, SequenceType> a = new HashMap<String, SequenceType>();
    private Set<String> b;
    private boolean c;

    public TupleItemType(List<String> list, List<SequenceType> list2) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.a.put(list.get(i2), list2.get(i2));
        }
        this.b = Collections.emptySet();
    }

    public TupleItemType(List<String> list, List<SequenceType> list2, Set<String> set, boolean bl2) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.a.put(list.get(i2), list2.get(i2));
        }
        this.b = set;
        this.c = bl2;
    }

    @Override
    public Genre getGenre() {
        return Genre.MAP;
    }

    @Override
    public boolean isMapType() {
        return true;
    }

    @Override
    public boolean isArrayType() {
        return false;
    }

    @Override
    public Iterable<String> getFieldNames() {
        return this.a.keySet();
    }

    @Override
    public SequenceType getFieldType(String string) {
        return this.a.get(string);
    }

    @Override
    public boolean isOptional(String string) {
        return this.b.contains(string);
    }

    @Override
    public boolean isExtensible() {
        return this.c;
    }

    @Override
    public boolean matches(Item item, TypeHierarchy typeHierarchy) {
        if (!(item instanceof MapItem)) {
            return false;
        }
        item = (MapItem)item;
        for (Map.Entry<String, SequenceType> entry : this.a.entrySet()) {
            GroundedValue<?> groundedValue = item.get(new StringValue(entry.getKey()));
            if (!(groundedValue == null ? !this.b.contains(entry.getKey()) : !((SequenceType)entry.getValue()).matches(groundedValue, typeHierarchy))) continue;
            return false;
        }
        if (!this.c) {
            Map.Entry<String, SequenceType> entry;
            AtomicIterator atomicIterator = item.keys();
            while ((entry = atomicIterator.next()) != null) {
                if (entry instanceof StringValue && this.a.containsKey(((AtomicValue)((Object)entry)).getStringValue())) continue;
                return false;
            }
        }
        return true;
    }

    public int getArity() {
        return 1;
    }

    @Override
    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_ATOMIC};
    }

    @Override
    public SequenceType getResultType() {
        if (this.c) {
            return SequenceType.ANY_SEQUENCE;
        }
        ItemType itemType = null;
        boolean bl2 = false;
        for (Map.Entry<String, SequenceType> entry : this.a.entrySet()) {
            itemType = itemType == null ? entry.getValue().getPrimaryType() : Type.getCommonSuperType(itemType, entry.getValue().getPrimaryType());
            bl2 = bl2 || Cardinality.allowsMany(entry.getValue().getCardinality());
        }
        return SequenceType.makeSequenceType(itemType, bl2 ? 57344 : 24576);
    }

    @Override
    public String toString() {
        return this.a(SequenceType::toString);
    }

    @Override
    public String toExportString() {
        return this.a(SequenceType::toExportString);
    }

    private String a(Function<SequenceType, String> function) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
        fastStringBuffer.append("tuple(");
        boolean bl2 = true;
        for (Map.Entry<String, SequenceType> entry : this.a.entrySet()) {
            if (bl2) {
                bl2 = false;
            } else {
                fastStringBuffer.append(", ");
            }
            fastStringBuffer.append(entry.getKey());
            if (this.isOptional(entry.getKey())) {
                fastStringBuffer.append("?");
            }
            fastStringBuffer.append(": ");
            fastStringBuffer.append(function.apply(entry.getValue()));
        }
        if (this.isExtensible()) {
            fastStringBuffer.append(", *");
        }
        fastStringBuffer.append(")");
        return fastStringBuffer.toString();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof TupleItemType && this.a.equals(((TupleItemType)object).a);
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    @Override
    public int relationship(FunctionItemType functionItemType, TypeHierarchy typeHierarchy) {
        if (functionItemType == AnyFunctionType.getInstance()) {
            return 2;
        }
        if (this.equals(functionItemType)) {
            return 0;
        }
        if (functionItemType == MapType.ANY_MAP_TYPE) {
            return 2;
        }
        if (functionItemType.isArrayType()) {
            return 4;
        }
        if (functionItemType instanceof MapType) {
            int n2 = typeHierarchy.relationship(BuiltInAtomicType.STRING, ((MapType)(functionItemType = (MapType)functionItemType)).getKeyType());
            if (n2 == 4) {
                return 4;
            }
            if (((MapType)functionItemType).getValueType().getPrimaryType().equals(AnyItemType.getInstance()) && ((MapType)functionItemType).getValueType().getCardinality() == 57344) {
                return 2;
            }
            for (SequenceType sequenceType : this.a.values()) {
                int n3 = typeHierarchy.sequenceTypeRelationship(sequenceType, ((MapType)functionItemType).getValueType());
                if (n3 == 2 || n3 == 0) continue;
                return 3;
            }
            return 2;
        }
        int n4 = ((AnyFunctionType)new SpecificFunctionType(((AnyFunctionType)this).getArgumentTypes(), ((AnyFunctionType)this).getResultType())).relationship(functionItemType, typeHierarchy);
        return n4;
    }

    @Override
    public Optional<String> explainMismatch(Item object, TypeHierarchy object2) {
        if (object instanceof MapItem) {
            for (Map.Entry<String, SequenceType> entry : this.a.entrySet()) {
                String string = entry.getKey();
                SequenceType object3 = entry.getValue();
                GroundedValue<?> groundedValue = ((MapItem)object).get(new StringValue(string));
                if (groundedValue == null) {
                    if (this.b.contains(string)) continue;
                    return Optional.of("Field " + string + " is absent, but is not declared optional");
                }
                try {
                    if (object3.matches(groundedValue, (TypeHierarchy)((Object)object2))) continue;
                    object = "Field " + string + " has value " + Err.depictSequence(groundedValue) + " which does not match the required type " + object3.toString();
                    if ((object2 = object3.explainMismatch(groundedValue, (TypeHierarchy)((Object)object2))).isPresent()) {
                        object = (String)object + ". " + object2.get();
                    }
                    return Optional.of(object);
                }
                catch (XPathException xPathException) {
                    return Optional.empty();
                }
            }
            if (!this.c) {
                AtomicValue atomicValue;
                AtomicIterator atomicIterator = ((MapItem)object).keys();
                while ((atomicValue = atomicIterator.next()) != null) {
                    if (!(atomicValue instanceof StringValue)) {
                        return Optional.of("Undeclared field " + atomicValue + " is present, but it is not a string, and the tuple type is not extensible");
                    }
                    if (this.a.containsKey(atomicValue.getStringValue())) continue;
                    return Optional.of("Undeclared field " + atomicValue + " is present, but the tuple type is not extensible");
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public Expression makeFunctionSequenceCoercer(Expression expression, RoleDiagnostic roleDiagnostic) {
        return ((AnyFunctionType)new SpecificFunctionType(((AnyFunctionType)this).getArgumentTypes(), ((AnyFunctionType)this).getResultType())).makeFunctionSequenceCoercer(expression, roleDiagnostic);
    }

    @Override
    public String generateJavaScriptItemTypeTest(ItemType itemType, int n2) {
        throw new UnsupportedOperationException();
    }
}

