/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.parray;

import java.util.List;
import net.sf.saxon.ma.parray.ImmList0;
import net.sf.saxon.ma.parray.ImmList1;
import net.sf.saxon.ma.parray.ImmList2;

public abstract class ImmList<E>
implements Iterable<E> {
    public static <E> ImmList<E> empty() {
        return ImmList0.a;
    }

    public static <E> ImmList<E> singleton(E e2) {
        return new ImmList1<E>(e2);
    }

    public static <E> ImmList<E> pair(E e2, E e3) {
        return new ImmList2<E>(new ImmList1<E>(e2), new ImmList1<E>(e3));
    }

    public static <E> ImmList<E> fromList(List<E> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return ImmList.empty();
        }
        if (n2 == 1) {
            return ImmList.singleton(list.get(0));
        }
        int n3 = n2 / 2;
        List<E> list2 = list.subList(0, n3);
        list = list.subList(n3, n2);
        return new ImmList2<E>(ImmList.fromList(list2), ImmList.fromList(list));
    }

    public abstract E get(int var1);

    public E head() {
        return this.get(0);
    }

    public abstract int size();

    public abstract boolean isEmpty();

    public abstract ImmList<E> replace(int var1, E var2);

    public abstract ImmList<E> insert(int var1, E var2);

    public abstract ImmList<E> append(E var1);

    public abstract ImmList<E> appendList(ImmList<E> var1);

    public abstract ImmList<E> remove(int var1);

    public abstract ImmList<E> subList(int var1, int var2);

    public ImmList<E> tail() {
        return this.remove(0);
    }

    protected ImmList<E> rebalance() {
        return this;
    }

    protected IndexOutOfBoundsException outOfBounds(int n2, int n3) {
        return new IndexOutOfBoundsException("Requested " + n2 + ", actual size " + n3);
    }
}

