/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.parray;

import java.util.Iterator;
import net.sf.saxon.ma.parray.ImmList;
import net.sf.saxon.ma.parray.ImmList1;
import net.sf.saxon.tree.jiter.ConcatenatingIterator;

public class ImmList2<E>
extends ImmList<E> {
    private ImmList<E> a;
    private ImmList<E> b;
    private int c;

    protected ImmList2(ImmList<E> immList, ImmList<E> immList2) {
        this.a = immList;
        this.b = immList2;
        this.c = immList.size() + immList2.size();
    }

    @Override
    public E get(int n2) {
        if (n2 < 0) {
            throw this.outOfBounds(n2, this.c);
        }
        if (n2 < this.a.size()) {
            return this.a.get(n2);
        }
        if (n2 < this.c) {
            return this.b.get(n2 - this.a.size());
        }
        throw this.outOfBounds(n2, this.c);
    }

    @Override
    public int size() {
        return this.c;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public ImmList<E> replace(int n2, E e2) {
        if (n2 < 0) {
            throw this.outOfBounds(n2, this.c);
        }
        if (n2 < this.a.size()) {
            return new ImmList2<E>(this.a.replace(n2, e2), this.b);
        }
        if (n2 < this.c) {
            return new ImmList2<E>(this.a, this.b.replace(n2 - this.a.size(), e2));
        }
        throw this.outOfBounds(n2, this.c);
    }

    @Override
    public ImmList<E> insert(int n2, E e2) {
        if (n2 < 0) {
            throw this.outOfBounds(n2, this.c);
        }
        if (n2 <= this.a.size()) {
            return new ImmList2<E>(this.a.insert(n2, e2), this.b).rebalance();
        }
        if (n2 <= this.c) {
            return new ImmList2<E>(this.a, this.b.insert(n2 - this.a.size(), e2)).rebalance();
        }
        throw this.outOfBounds(n2, this.c);
    }

    @Override
    public ImmList<E> append(E e2) {
        return new ImmList2<E>(this, new ImmList1<E>(e2)).rebalance();
    }

    @Override
    public ImmList<E> appendList(ImmList<E> immList) {
        return new ImmList2<E>(this, immList).rebalance();
    }

    @Override
    public ImmList<E> remove(int n2) {
        if (n2 < 0) {
            throw this.outOfBounds(n2, this.c);
        }
        if (n2 < this.a.size()) {
            return new ImmList2<E>(this.a.remove(n2), this.b).rebalance();
        }
        if (n2 < this.c) {
            return new ImmList2<E>(this.a, this.b.remove(n2 - this.a.size())).rebalance();
        }
        throw this.outOfBounds(n2, this.c);
    }

    @Override
    public ImmList<E> subList(int n2, int n3) {
        if (n2 < 0 || n2 >= this.c) {
            throw this.outOfBounds(n2, this.c);
        }
        if (n3 < n2 || n3 > this.c) {
            throw this.outOfBounds(n3, this.c);
        }
        if (n2 < this.a.size() && n3 <= this.a.size()) {
            return this.a.subList(n2, n3);
        }
        if (n2 >= this.a.size() && n3 >= this.a.size()) {
            return this.b.subList(n2 - this.a.size(), n3 - this.a.size());
        }
        ImmList<E> immList = this.a;
        return new ImmList2<E>(immList.subList(n2, immList.size()), this.b.subList(0, n3 - this.a.size())).rebalance();
    }

    @Override
    public Iterator<E> iterator() {
        return new ConcatenatingIterator(this.a.iterator(), () -> this.b.iterator());
    }

    @Override
    protected ImmList<E> rebalance() {
        if (this.a.isEmpty()) {
            return this.b;
        }
        if (this.b.isEmpty()) {
            return this.a;
        }
        ImmList<E> immList = this.a;
        ImmList<E> immList2 = this.b;
        if (((ImmList)this).size() > 10) {
            if (immList instanceof ImmList2 && immList.size() > 10 * immList2.size()) {
                return new ImmList2<E>(((ImmList2)immList).a, new ImmList2<E>(((ImmList2)immList).b, immList2));
            }
            if (immList2 instanceof ImmList2 && immList2.size() > 10 * immList.size()) {
                return new ImmList2<E>(new ImmList2<E>(immList, ((ImmList2)immList2).a), ((ImmList2)immList2).b);
            }
            return this;
        }
        if (this.a == immList && this.b == immList2) {
            return this;
        }
        return new ImmList2<E>(immList, immList2);
    }
}

