/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;

public class AbsolutePath {
    private List<PathElement> a;
    private String b;

    public AbsolutePath(List<PathElement> list) {
        this.a = new ArrayList<PathElement>(list);
    }

    public void appendAttributeName(NodeName object) {
        PathElement pathElement = this.a.get(this.a.size() - 1);
        if (pathElement.getNodeKind() == 2) {
            this.a.remove(this.a.size() - 1);
        }
        object = new PathElement(2, (NodeName)object, 1);
        this.a.add((PathElement)object);
    }

    public static AbsolutePath pathToNode(NodeInfo nodeInfo) {
        LinkedList<PathElement> linkedList = new LinkedList<PathElement>();
        while (nodeInfo != null && nodeInfo.getNodeKind() != 9) {
            PathElement pathElement = new PathElement(nodeInfo.getNodeKind(), NameOfNode.makeName(nodeInfo), Navigator.getNumberSimple(nodeInfo, null));
            linkedList.addFirst(pathElement);
            nodeInfo = nodeInfo.getParent();
        }
        return new AbsolutePath(linkedList);
    }

    public String getPathUsingPrefixes() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
        for (PathElement pathElement : this.a) {
            fastStringBuffer.append('/');
            pathElement.toString(fastStringBuffer, 'p');
        }
        return fastStringBuffer.toString();
    }

    public String getPathUsingUris() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
        for (PathElement pathElement : this.a) {
            fastStringBuffer.append('/');
            pathElement.toString(fastStringBuffer, 'u');
        }
        return fastStringBuffer.toString();
    }

    public String getPathUsingAbbreviatedUris() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
        for (PathElement pathElement : this.a) {
            fastStringBuffer.append('/');
            pathElement.toString(fastStringBuffer, 's');
        }
        return fastStringBuffer.toString();
    }

    public String toString() {
        return this.getPathUsingUris();
    }

    public boolean equals(Object object) {
        return object instanceof AbsolutePath && object.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void setSystemId(String string) {
        this.b = string;
    }

    public String getSystemId() {
        return this.b;
    }

    public static class PathElement {
        private int a;
        private NodeName b;
        private int c;

        public PathElement(int n2, NodeName nodeName, int n3) {
            this.a = n2;
            this.b = nodeName;
            this.c = n3;
        }

        public int getNodeKind() {
            return this.a;
        }

        public NodeName getName() {
            return this.b;
        }

        public int getIndex() {
            return this.c;
        }

        public void toString(FastStringBuffer fastStringBuffer, char c2) {
            switch (this.a) {
                case 9: {
                    fastStringBuffer.append("(/)");
                    return;
                }
                case 2: {
                    fastStringBuffer.append('@');
                    if (!this.b.getURI().isEmpty()) {
                        if (c2 == 'u') {
                            fastStringBuffer.append("Q{");
                            fastStringBuffer.append(this.b.getURI());
                            fastStringBuffer.append("}");
                        } else if (c2 == 'p') {
                            String string = this.b.getPrefix();
                            if (!string.isEmpty()) {
                                fastStringBuffer.append(string);
                                fastStringBuffer.append(':');
                            }
                        } else if (c2 == 's') {
                            fastStringBuffer.append("Q{");
                            fastStringBuffer.append(Err.abbreviateURI(this.b.getURI()));
                            fastStringBuffer.append("}");
                        }
                    }
                    fastStringBuffer.append(this.getName().getLocalPart());
                    return;
                }
                case 1: {
                    if (c2 == 'u') {
                        fastStringBuffer.append("Q{");
                        fastStringBuffer.append(this.b.getURI());
                        fastStringBuffer.append("}");
                    } else if (c2 == 'p') {
                        String string = this.b.getPrefix();
                        if (!string.isEmpty()) {
                            fastStringBuffer.append(string);
                            fastStringBuffer.append(':');
                        }
                    } else if (c2 == 's' && !this.b.getURI().isEmpty()) {
                        fastStringBuffer.append("Q{");
                        fastStringBuffer.append(Err.abbreviateURI(this.b.getURI()));
                        fastStringBuffer.append("}");
                    }
                    fastStringBuffer.append(this.b.getLocalPart());
                    this.a(fastStringBuffer);
                    return;
                }
                case 3: {
                    fastStringBuffer.append("text()");
                    return;
                }
                case 8: {
                    fastStringBuffer.append("comment()");
                    this.a(fastStringBuffer);
                    return;
                }
                case 7: {
                    fastStringBuffer.append("processing-instruction(");
                    fastStringBuffer.append(this.b.getLocalPart());
                    fastStringBuffer.append(")");
                    this.a(fastStringBuffer);
                    return;
                }
                case 13: {
                    fastStringBuffer.append("namespace::");
                    if (this.b.getLocalPart().isEmpty()) {
                        fastStringBuffer.append("*[Q{http://www.w3.org/2005/xpath-functions}local-name()=\"\"]");
                        return;
                    }
                    fastStringBuffer.append(this.b.getLocalPart());
                }
            }
        }

        private void a(FastStringBuffer fastStringBuffer) {
            int n2 = this.getIndex();
            if (n2 != -1) {
                fastStringBuffer.append('[');
                fastStringBuffer.append("" + this.getIndex());
                fastStringBuffer.append(']');
            }
        }
    }
}

